/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.token.facade;

import io.alapierre.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import javax.crypto.Cipher;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicKeyEncoder {
    private static final Logger log = LoggerFactory.getLogger(PublicKeyEncoder.class);
    private final byte[] publicKey;

    public static PublicKeyEncoder withBundledKey(@NonNull String env) {
        String keyName;
        if (env == null) {
            throw new NullPointerException("env is marked non-null but is null");
        }
        switch (env) {
            case "TEST": {
                keyName = "publicKey-test.der";
                break;
            }
            case "DEMO": {
                keyName = "publicKey-demo.der";
                break;
            }
            case "PROD": {
                keyName = "publicKey-prod.der";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown environment name '" + env + "'");
            }
        }
        log.debug("klucz publiczny {}", (Object)keyName);
        InputStream pk = PublicKeyEncoder.class.getClassLoader().getResourceAsStream(keyName);
        if (pk == null) {
            throw new IllegalStateException("Can't load bundled key " + keyName + " from classpath");
        }
        return new PublicKeyEncoder(pk);
    }

    public PublicKeyEncoder(@NonNull InputStream publicKeyStream) throws IOException {
        if (publicKeyStream == null) {
            throw new NullPointerException("publicKeyStream is marked non-null but is null");
        }
        this.publicKey = IOUtils.toByteArray((InputStream)publicKeyStream);
    }

    @NotNull
    public static Date parseChallengeTimestamp(@NotNull String challengeTimestamp) throws ParseException {
        if (challengeTimestamp == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/token/facade/PublicKeyEncoder.parseChallengeTimestamp must not be null");
        }
        Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").parse(challengeTimestamp);
        if (date == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/token/facade/PublicKeyEncoder.parseChallengeTimestamp must not return null");
        }
        return date;
    }

    @NotNull
    public String encodeSessionToken(@NotNull String token, @NotNull Date challengeTimestamp) {
        String encryptedToken;
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/token/facade/PublicKeyEncoder.encodeSessionToken must not be null");
        }
        if (challengeTimestamp == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/token/facade/PublicKeyEncoder.encodeSessionToken must not be null");
        }
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(this.publicKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        byte[] message = (token + "|" + challengeTimestamp.getTime()).getBytes(StandardCharsets.UTF_8);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, publicKey);
        byte[] encrypted = cipher.doFinal(message);
        String string = encryptedToken = Base64.getEncoder().encodeToString(encrypted);
        if (string == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/token/facade/PublicKeyEncoder.encodeSessionToken must not return null");
        }
        return string;
    }
}

