/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.token.facade;

import io.alapierre.ksef.client.AbstractApiClient;
import io.alapierre.ksef.client.ApiException;
import io.alapierre.ksef.client.api.InterfejsyInteraktywneSesjaApi;
import io.alapierre.ksef.client.model.rest.auth.AuthorisationChallengeRequest;
import io.alapierre.ksef.client.model.rest.auth.AuthorisationChallengeResponse;
import io.alapierre.ksef.client.model.rest.auth.InitSignedResponse;
import io.alapierre.ksef.token.facade.PublicKeyEncoder;
import io.alapierre.ksef.xml.model.AuthRequestUtil;
import io.alapierre.ksef.xml.model.AuthTokenRequestSerializer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Date;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gov.mf.ksef.schema.gtw.svc.online.auth.request._2021._10._01._0001.InitSessionTokenRequest;

public class KsefTokenFacade {
    private static final Logger log = LoggerFactory.getLogger(KsefTokenFacade.class);
    private final InterfejsyInteraktywneSesjaApi api;

    private boolean isSchemaValidationEnabled() {
        boolean res = Boolean.parseBoolean(System.getProperty("io.alapierre.ksef.validateAuthRequestXML", "true"));
        if (!res) {
            log.info("AuthRequest XML validation is disabled");
        }
        return res;
    }

    public InitSignedResponse authByToken(@NonNull AbstractApiClient.Environment env, @NonNull String identifier, AuthorisationChallengeRequest.IdentifierType identifierType, @NotNull String token) throws ApiException, ParseException {
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 of io/alapierre/ksef/token/facade/KsefTokenFacade.authByToken must not be null");
        }
        if (env == null) {
            throw new NullPointerException("env is marked non-null but is null");
        }
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        AuthorisationChallengeResponse challengeResponse = this.api.authorisationChallengeCall(identifier, identifierType);
        log.debug("challengeResponse = {}", (Object)challengeResponse);
        Date timestamp = PublicKeyEncoder.parseChallengeTimestamp(challengeResponse.getTimestamp());
        PublicKeyEncoder encoder = PublicKeyEncoder.withBundledKey(env.name());
        String encryptedToken = encoder.encodeSessionToken(token, timestamp);
        InitSessionTokenRequest request = AuthRequestUtil.prepareTokenAuthRequest((String)challengeResponse.getChallenge(), (String)identifier, (String)encryptedToken);
        log.debug("Token request {}", (Object)request);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        AuthTokenRequestSerializer serializer = new AuthTokenRequestSerializer();
        serializer.toStream((Object)request, (OutputStream)os, this.isSchemaValidationEnabled());
        return this.api.initSessionTokenCall(os.toByteArray());
    }

    public KsefTokenFacade(InterfejsyInteraktywneSesjaApi api) {
        this.api = api;
    }
}

