/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.api.dss.facade;

import eu.europa.esig.dss.model.DSSDocument;
import io.alapierre.crypto.dss.signer.AbstractSigner;
import io.alapierre.ksef.client.ApiException;
import io.alapierre.ksef.client.api.InterfejsyInteraktywneSesjaApi;
import io.alapierre.ksef.client.model.rest.auth.AuthorisationChallengeRequest;
import io.alapierre.ksef.client.model.rest.auth.AuthorisationChallengeResponse;
import io.alapierre.ksef.client.model.rest.auth.InitSignedResponse;
import io.alapierre.ksef.xml.model.AuthRequestUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.gov.mf.ksef.schema.gtw.svc.online.auth.request._2021._10._01._0001.InitSessionSignedRequest;

public class KsefDssFacade {
    private static final Logger log = LoggerFactory.getLogger(KsefDssFacade.class);
    private final AbstractSigner signer;
    private final InterfejsyInteraktywneSesjaApi api;

    public InitSignedResponse authByDigitalSignature(String identifier, AuthorisationChallengeRequest.IdentifierType identifierType) throws ApiException, IOException {
        AuthorisationChallengeResponse challengeResponse = this.api.authorisationChallengeCall(identifier, identifierType);
        log.debug("challengeResponse = {}", (Object)challengeResponse);
        InitSessionSignedRequest auth = AuthRequestUtil.prepareAuthRequest((String)challengeResponse.getChallenge(), (String)identifier);
        byte[] toSigned = AuthRequestUtil.requestToBytes((InitSessionSignedRequest)auth);
        ByteArrayInputStream is = new ByteArrayInputStream(toSigned);
        DSSDocument signedDocument = this.signer.sign((InputStream)is);
        ByteArrayOutputStream signed = new ByteArrayOutputStream();
        signedDocument.writeTo((OutputStream)signed);
        InitSignedResponse signedResponse = this.api.initSessionSignedCall(signed.toByteArray());
        log.debug("signedResponse = {}", (Object)signedResponse);
        return signedResponse;
    }

    public KsefDssFacade(AbstractSigner signer, InterfejsyInteraktywneSesjaApi api) {
        this.signer = signer;
        this.api = api;
    }
}

