/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.client;

import java.util.List;
import java.util.Map;

public class ApiException
extends Exception {
    private int code = 0;
    private Map<String, List<String>> responseHeaders = null;
    private String responseBody = null;
    private List<ExceptionDetail> exceptionDetails;

    public ApiException(Throwable throwable) {
        super(throwable);
    }

    public ApiException(String message) {
        super(message);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, String responseBody, List<ExceptionDetail> details) {
        super(message, throwable);
        this.code = code;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.exceptionDetails = details;
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(message, throwable, code, responseHeaders, responseBody, null);
    }

    public ApiException(String message, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(message, null, code, responseHeaders, responseBody);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders) {
        this(message, throwable, code, responseHeaders, null);
    }

    public ApiException(int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(null, null, code, responseHeaders, responseBody);
    }

    public ApiException(int code, String message) {
        super(message);
        this.code = code;
    }

    public ApiException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody, List<ExceptionDetail> details) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.exceptionDetails = details;
    }

    public ApiException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public ApiException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public int getCode() {
        return this.code;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public List<ExceptionDetail> getExceptionDetails() {
        return this.exceptionDetails;
    }

    public ApiException() {
    }

    public static final class ExceptionDetail {
        private final int exceptionCode;
        private final String exceptionDescription;

        ExceptionDetail(int exceptionCode, String exceptionDescription) {
            this.exceptionCode = exceptionCode;
            this.exceptionDescription = exceptionDescription;
        }

        public static ExceptionDetailBuilder builder() {
            return new ExceptionDetailBuilder();
        }

        public int getExceptionCode() {
            return this.exceptionCode;
        }

        public String getExceptionDescription() {
            return this.exceptionDescription;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExceptionDetail)) {
                return false;
            }
            ExceptionDetail other = (ExceptionDetail)o;
            if (this.getExceptionCode() != other.getExceptionCode()) {
                return false;
            }
            String this$exceptionDescription = this.getExceptionDescription();
            String other$exceptionDescription = other.getExceptionDescription();
            return !(this$exceptionDescription == null ? other$exceptionDescription != null : !this$exceptionDescription.equals(other$exceptionDescription));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getExceptionCode();
            String $exceptionDescription = this.getExceptionDescription();
            result = result * 59 + ($exceptionDescription == null ? 43 : $exceptionDescription.hashCode());
            return result;
        }

        public String toString() {
            return "ApiException.ExceptionDetail(exceptionCode=" + this.getExceptionCode() + ", exceptionDescription=" + this.getExceptionDescription() + ")";
        }

        public static class ExceptionDetailBuilder {
            private int exceptionCode;
            private String exceptionDescription;

            ExceptionDetailBuilder() {
            }

            public ExceptionDetailBuilder exceptionCode(int exceptionCode) {
                this.exceptionCode = exceptionCode;
                return this;
            }

            public ExceptionDetailBuilder exceptionDescription(String exceptionDescription) {
                this.exceptionDescription = exceptionDescription;
                return this;
            }

            public ExceptionDetail build() {
                return new ExceptionDetail(this.exceptionCode, this.exceptionDescription);
            }

            public String toString() {
                return "ApiException.ExceptionDetail.ExceptionDetailBuilder(exceptionCode=" + this.exceptionCode + ", exceptionDescription=" + this.exceptionDescription + ")";
            }
        }
    }
}

