/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.client;

import io.alapierre.ksef.client.ApiClient;
import io.alapierre.ksef.client.ApiException;
import io.alapierre.ksef.client.JsonSerializer;
import io.alapierre.ksef.client.exception.BadRequestException;
import io.alapierre.ksef.client.exception.ExceptionResponse;
import io.alapierre.ksef.client.exception.MaxResultsExceededException;
import io.alapierre.ksef.client.exception.NoAuthenticationException;
import io.alapierre.ksef.client.exception.NoAuthorizationException;
import io.alapierre.ksef.client.exception.TooManyRequestsException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractApiClient
implements ApiClient {
    private final String url;
    protected final JsonSerializer serializer;

    protected AbstractApiClient(JsonSerializer serializer) {
        this.url = Environment.TEST.getUrl();
        this.serializer = serializer;
    }

    protected AbstractApiClient(JsonSerializer serializer, String url) {
        this.url = url;
        this.serializer = serializer;
    }

    protected AbstractApiClient(JsonSerializer serializer, Environment environment) {
        this.url = environment.getUrl();
        this.serializer = serializer;
    }

    protected byte[] marshalXML(@NotNull Object o) throws JAXBException {
        if (o == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/AbstractApiClient.marshalXML must not be null");
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{o.getClass()});
        Marshaller jaxbMarshaller = jc.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        jaxbMarshaller.marshal(o, (OutputStream)stream);
        return stream.toByteArray();
    }

    @NotNull
    protected String createUrl(@NotNull String endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/AbstractApiClient.createUrl must not be null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.url);
        if (!endpoint.startsWith("/")) {
            sb.append("/");
        }
        sb.append(endpoint);
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/AbstractApiClient.createUrl must not return null");
        }
        return string;
    }

    @Nullable
    protected List<ApiException.ExceptionDetail> getExceptionDetails(@Nullable String body) {
        List<ApiException.ExceptionDetail> details = this.serializer.fromJson(body, ExceptionResponse.class).map(exceptionResponse -> {
            if (exceptionResponse.getException() != null) {
                List<ExceptionResponse.ExceptionDetailList> list = exceptionResponse.getException().getExceptionDetailList();
                return list.stream().map(exceptionDetailList -> ApiException.ExceptionDetail.builder().exceptionCode(exceptionDetailList.getExceptionCode()).exceptionDescription(exceptionDetailList.getExceptionDescription()).build()).collect(Collectors.toList());
            }
            return null;
        }).orElse(Collections.emptyList());
        return details;
    }

    protected ApiException mapHttpResponseStatusToException(int code, String message, Map<String, List<String>> headers, String body) {
        Set errorCodes;
        List<ApiException.ExceptionDetail> exceptionsFromKSef = this.getExceptionDetails(body);
        Set<Object> set = errorCodes = exceptionsFromKSef != null ? this.extractKsefExceptionsCodes(exceptionsFromKSef) : Collections.emptySet();
        if (code == 429) {
            return new TooManyRequestsException(code, message, headers, body, exceptionsFromKSef);
        }
        if (code == 400) {
            if (errorCodes.contains(21177)) {
                return new MaxResultsExceededException(code, message, headers, body, exceptionsFromKSef);
            }
            if (errorCodes.contains(21301)) {
                return new NoAuthorizationException(message, code, headers, body);
            }
            if (errorCodes.contains(21304)) {
                return new NoAuthenticationException(code, message, headers, body, exceptionsFromKSef);
            }
            return new BadRequestException(code, message, headers, body, exceptionsFromKSef);
        }
        return new ApiException(code, message, headers, body, this.getExceptionDetails(body));
    }

    protected Set<Integer> extractKsefExceptionsCodes(List<ApiException.ExceptionDetail> list) {
        return list.stream().map(ApiException.ExceptionDetail::getExceptionCode).collect(Collectors.toSet());
    }

    public static enum Environment {
        DEMO("https://ksef-demo.mf.gov.pl/api"),
        PROD("https://ksef.mf.gov.pl/api"),
        TEST("https://ksef-test.mf.gov.pl/api");

        private final String url;

        public String getUrl() {
            return this.url;
        }

        private Environment(String url) {
            this.url = url;
        }
    }
}

