/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.client.okhttp;

import io.alapierre.io.IOUtils;
import io.alapierre.ksef.client.AbstractApiClient;
import io.alapierre.ksef.client.ApiException;
import io.alapierre.ksef.client.JsonSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpApiClient
extends AbstractApiClient {
    private static final Logger log = LoggerFactory.getLogger(OkHttpApiClient.class);
    public static final String API_EXCEPTION = "B\u0142\u0105d wywo\u0142ania API";
    private final OkHttpClient client;
    private final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private final MediaType XML = MediaType.get((String)"application/xml; charset=utf-8");
    private final MediaType OCTET = MediaType.get((String)"application/octet-stream; charset=utf-8");

    public OkHttpApiClient(JsonSerializer serializer) {
        super(serializer, AbstractApiClient.Environment.TEST);
        this.client = new OkHttpClient();
    }

    public OkHttpApiClient(JsonSerializer serializer, String url) {
        super(serializer, url);
        this.client = new OkHttpClient();
    }

    public OkHttpApiClient(JsonSerializer serializer, AbstractApiClient.Environment environment) {
        super(serializer, environment);
        this.client = new OkHttpClient();
    }

    public OkHttpApiClient(JsonSerializer serializer, AbstractApiClient.Environment environment, OkHttpClient client) {
        super(serializer, environment);
        this.client = client;
    }

    public <R> Optional<R> getJson(@NotNull String endpoint, @NotNull Class<R> classOfR, @NotNull String token) throws ApiException {
        if (endpoint == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getJson must not be null");
        }
        if (classOfR == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getJson must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getJson must not be null");
        }
        return this.getJson(endpoint, classOfR, token, "application/json");
    }

    public <R> Optional<R> getJson(@NotNull String endpoint, @NotNull Class<R> classOfR, @NotNull String token, @NotNull String accept) throws ApiException {
        if (endpoint == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getJson must not be null");
        }
        if (classOfR == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getJson must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getJson must not be null");
        }
        if (accept == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getJson must not be null");
        }
        Request.Builder builder = new Request.Builder();
        builder.url(this.createUrl(endpoint));
        builder.addHeader("SessionToken", token).addHeader("Accept", accept);
        builder.get();
        return this.callAndReturnJson(classOfR, builder.build());
    }

    public <R> Optional<R> getJsonWithAcceptHeader(@NotNull String endpoint, @NotNull Class<R> classOfR, @NotNull String accept) throws ApiException {
        if (endpoint == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getJsonWithAcceptHeader must not be null");
        }
        if (classOfR == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getJsonWithAcceptHeader must not be null");
        }
        if (accept == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getJsonWithAcceptHeader must not be null");
        }
        Request.Builder builder = new Request.Builder();
        builder.url(this.createUrl(endpoint)).addHeader("Accept", accept).get();
        return this.callAndReturnJson(classOfR, builder.build());
    }

    public <R> Optional<R> getJson(@NotNull String endpoint, @NotNull Class<R> classOfR) throws ApiException {
        if (endpoint == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getJson must not be null");
        }
        if (classOfR == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getJson must not be null");
        }
        Request.Builder builder = new Request.Builder();
        builder.url(this.createUrl(endpoint));
        builder.get();
        return this.callAndReturnJson(classOfR, builder.build());
    }

    public <B, R> Optional<R> postJson(@NotNull String endpoint, @NotNull B body, @NotNull Class<R> classOfR) throws ApiException {
        if (endpoint == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postJson must not be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postJson must not be null");
        }
        if (classOfR == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postJson must not be null");
        }
        return this.doPostJson(endpoint, body, classOfR, Collections.emptyMap());
    }

    public <B, R> Optional<R> postJson(@NotNull String endpoint, @NotNull B body, @NotNull Class<R> classOfR, @NotNull String token) throws ApiException {
        if (endpoint == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postJson must not be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postJson must not be null");
        }
        if (classOfR == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postJson must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postJson must not be null");
        }
        return this.doPostJson(endpoint, body, classOfR, this.addAuthTokenHeader(token));
    }

    public <B, R> Optional<R> putJson(@NotNull String endpoint, @NotNull B body, @NotNull Class<R> classOfR, @NotNull String token) throws ApiException {
        if (endpoint == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.putJson must not be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.putJson must not be null");
        }
        if (classOfR == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.putJson must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.putJson must not be null");
        }
        RequestBody requestBody = RequestBody.create((String)this.serializer.toJson(body), (MediaType)this.JSON);
        Request request = this.createRequest(endpoint, requestBody, this.addAuthTokenHeader(token), false);
        return this.callAndReturnJson(classOfR, request);
    }

    public <R> Optional<R> postXMLFromBytes(@NotNull String endpoint, byte[] body, @NotNull Class<R> classOfR) throws ApiException {
        if (endpoint == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postXMLFromBytes must not be null");
        }
        if (classOfR == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postXMLFromBytes must not be null");
        }
        try {
            RequestBody requestBody = RequestBody.create((byte[])body, (MediaType)this.OCTET);
            return this.postAndReturnJson(endpoint, classOfR, requestBody, Collections.emptyMap());
        }
        catch (IOException e) {
            throw new ApiException(API_EXCEPTION, (Throwable)e);
        }
    }

    public <R> Optional<R> postXMLFromBytes(@NotNull String endpoint, byte[] body, @NotNull Class<R> classOfR, @NotNull String token) throws ApiException {
        if (endpoint == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postXMLFromBytes must not be null");
        }
        if (classOfR == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postXMLFromBytes must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postXMLFromBytes must not be null");
        }
        try {
            RequestBody requestBody = RequestBody.create((byte[])body, (MediaType)this.OCTET);
            return this.postAndReturnJson(endpoint, classOfR, requestBody, this.addAuthTokenHeader(token));
        }
        catch (IOException e) {
            throw new ApiException(API_EXCEPTION, (Throwable)e);
        }
    }

    public <R> Optional<R> postXML(@NotNull String endpoint, @NotNull Object body, @NotNull Class<R> classOfR) throws ApiException {
        if (endpoint == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postXML must not be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postXML must not be null");
        }
        if (classOfR == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postXML must not be null");
        }
        try {
            RequestBody requestBody = RequestBody.create((byte[])this.marshalXML(body), (MediaType)this.XML);
            return this.postAndReturnJson(endpoint, classOfR, requestBody, Collections.emptyMap());
        }
        catch (Exception e) {
            throw new ApiException(API_EXCEPTION, (Throwable)e);
        }
    }

    public void getStream(@NotNull String endpoint, @NotNull String token, @NotNull OutputStream os) throws ApiException {
        block18: {
            if (endpoint == null) {
                throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getStream must not be null");
            }
            if (token == null) {
                throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getStream must not be null");
            }
            if (os == null) {
                throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.getStream must not be null");
            }
            Request.Builder builder = new Request.Builder();
            builder.url(this.createUrl(endpoint));
            builder.addHeader("SessionToken", token);
            builder.get();
            try (Response response = this.client.newCall(builder.build()).execute();){
                if (!response.isSuccessful()) {
                    throw this.createException(response);
                }
                if (response.body() == null) break block18;
                try (InputStream is = response.body().byteStream();){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
            }
            catch (IOException ex) {
                throw new ApiException((Throwable)ex);
            }
        }
    }

    public void postStream(@NotNull String endpoint, @NotNull Object body, @NotNull OutputStream os) throws ApiException {
        block18: {
            if (endpoint == null) {
                throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postStream must not be null");
            }
            if (body == null) {
                throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postStream must not be null");
            }
            if (os == null) {
                throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postStream must not be null");
            }
            RequestBody requestBody = RequestBody.create((String)this.serializer.toJson(body), (MediaType)this.JSON);
            Request request = this.createRequest(endpoint, requestBody, Collections.emptyMap(), true);
            try (Response response = this.client.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw this.createException(response);
                }
                if (response.body() == null) break block18;
                try (InputStream is = response.body().byteStream();){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
            }
            catch (IOException ex) {
                throw new ApiException((Throwable)ex);
            }
        }
    }

    protected <B, R> Optional<R> doPostJson(@NotNull String endpoint, @NotNull B body, @NotNull Class<R> classOfR, Map<String, String> headers) throws ApiException {
        if (endpoint == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.doPostJson must not be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.doPostJson must not be null");
        }
        if (classOfR == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.doPostJson must not be null");
        }
        RequestBody requestBody = RequestBody.create((String)this.serializer.toJson(body), (MediaType)this.JSON);
        Request request = this.createRequest(endpoint, requestBody, headers, true);
        return this.callAndReturnJson(classOfR, request);
    }

    @NotNull
    protected Request createRequest(@NotNull String endpoint, @NotNull RequestBody requestBody, @NotNull Map<String, String> headers, boolean post) {
        if (endpoint == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.createRequest must not be null");
        }
        if (requestBody == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.createRequest must not be null");
        }
        if (headers == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.createRequest must not be null");
        }
        Request.Builder builder = new Request.Builder();
        builder.url(this.createUrl(endpoint));
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        if (post) {
            builder.post(requestBody);
        } else {
            builder.put(requestBody);
        }
        Request request = builder.build();
        if (request == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/okhttp/OkHttpApiClient.createRequest must not return null");
        }
        return request;
    }

    /*
     * Loose catch block
     */
    @NotNull
    protected <R> Optional<R> callAndReturnJson(@NotNull Class<R> classOfR, Request request) throws ApiException {
        Optional optional;
        Response response;
        block11: {
            if (classOfR == null) {
                throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.callAndReturnJson must not be null");
            }
            response = this.client.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw this.createException(response);
            }
            Optional optional2 = optional = response.body() != null ? this.serializer.fromJson(response.body().string(), classOfR) : Optional.empty();
            if (response == null) break block11;
            response.close();
        }
        Optional optional3 = optional;
        if (optional3 == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/okhttp/OkHttpApiClient.callAndReturnJson must not return null");
        }
        return optional3;
        {
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new ApiException((Throwable)ex);
                }
            }
        }
    }

    @NotNull
    protected Map<String, String> addAuthTokenHeader(String token) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("SessionToken", token);
        HashMap<String, String> hashMap = headers;
        if (hashMap == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/okhttp/OkHttpApiClient.addAuthTokenHeader must not return null");
        }
        return hashMap;
    }

    @NotNull
    protected <R> Optional<R> postAndReturnJson(String endpoint, Class<R> classOfR, RequestBody requestBody, @NotNull Map<String, String> headers) throws ApiException, IOException {
        if (headers == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 of io/alapierre/ksef/client/okhttp/OkHttpApiClient.postAndReturnJson must not be null");
        }
        Request request = this.createRequest(endpoint, requestBody, headers, true);
        Response response = this.client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw this.createException(response);
        }
        Optional optional = response.body() != null ? this.serializer.fromJson(response.body().string(), classOfR) : Optional.empty();
        Optional optional2 = optional;
        if (optional2 == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/okhttp/OkHttpApiClient.postAndReturnJson must not return null");
        }
        return optional2;
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    protected ApiException createException(Response response) {
        String body;
        ResponseBody responseBody = response.body();
        try {
            body = responseBody != null ? responseBody.string() : null;
            log.debug("responseBody: {}", (Object)body);
        }
        catch (IOException e) {
            log.warn("Response code: {} and can't read body for error response {}", (Object)response.code(), (Object)e.getMessage());
            body = e.getMessage();
        }
        Map headers = response.headers().toMultimap();
        log.debug("headers: {}", (Object)headers);
        return this.mapHttpResponseStatusToException(response.code(), response.message(), headers, body);
    }
}

