/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.client.model.rest.invoice;

public final class SendInvoiceRequest {
    private final InvoiceHash invoiceHash;
    private final InvoicePayload invoicePayload;

    SendInvoiceRequest(InvoiceHash invoiceHash, InvoicePayload invoicePayload) {
        this.invoiceHash = invoiceHash;
        this.invoicePayload = invoicePayload;
    }

    public static SendInvoiceRequestBuilder builder() {
        return new SendInvoiceRequestBuilder();
    }

    public InvoiceHash getInvoiceHash() {
        return this.invoiceHash;
    }

    public InvoicePayload getInvoicePayload() {
        return this.invoicePayload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendInvoiceRequest)) {
            return false;
        }
        SendInvoiceRequest other = (SendInvoiceRequest)o;
        InvoiceHash this$invoiceHash = this.getInvoiceHash();
        InvoiceHash other$invoiceHash = other.getInvoiceHash();
        if (this$invoiceHash == null ? other$invoiceHash != null : !((Object)this$invoiceHash).equals(other$invoiceHash)) {
            return false;
        }
        InvoicePayload this$invoicePayload = this.getInvoicePayload();
        InvoicePayload other$invoicePayload = other.getInvoicePayload();
        return !(this$invoicePayload == null ? other$invoicePayload != null : !((Object)this$invoicePayload).equals(other$invoicePayload));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InvoiceHash $invoiceHash = this.getInvoiceHash();
        result = result * 59 + ($invoiceHash == null ? 43 : ((Object)$invoiceHash).hashCode());
        InvoicePayload $invoicePayload = this.getInvoicePayload();
        result = result * 59 + ($invoicePayload == null ? 43 : ((Object)$invoicePayload).hashCode());
        return result;
    }

    public String toString() {
        return "SendInvoiceRequest(invoiceHash=" + this.getInvoiceHash() + ", invoicePayload=" + this.getInvoicePayload() + ")";
    }

    public static final class InvoiceHash {
        private final HashSHA hashSHA;
        private final int fileSize;

        InvoiceHash(HashSHA hashSHA, int fileSize) {
            this.hashSHA = hashSHA;
            this.fileSize = fileSize;
        }

        public static InvoiceHashBuilder builder() {
            return new InvoiceHashBuilder();
        }

        public HashSHA getHashSHA() {
            return this.hashSHA;
        }

        public int getFileSize() {
            return this.fileSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceHash)) {
                return false;
            }
            InvoiceHash other = (InvoiceHash)o;
            if (this.getFileSize() != other.getFileSize()) {
                return false;
            }
            HashSHA this$hashSHA = this.getHashSHA();
            HashSHA other$hashSHA = other.getHashSHA();
            return !(this$hashSHA == null ? other$hashSHA != null : !((Object)this$hashSHA).equals(other$hashSHA));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFileSize();
            HashSHA $hashSHA = this.getHashSHA();
            result = result * 59 + ($hashSHA == null ? 43 : ((Object)$hashSHA).hashCode());
            return result;
        }

        public String toString() {
            return "SendInvoiceRequest.InvoiceHash(hashSHA=" + this.getHashSHA() + ", fileSize=" + this.getFileSize() + ")";
        }

        public static final class HashSHA {
            private final String algorithm;
            private final String encoding;
            private final String value;

            HashSHA(String algorithm, String encoding, String value) {
                this.algorithm = algorithm;
                this.encoding = encoding;
                this.value = value;
            }

            public static HashSHABuilder builder() {
                return new HashSHABuilder();
            }

            public String getAlgorithm() {
                return this.algorithm;
            }

            public String getEncoding() {
                return this.encoding;
            }

            public String getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof HashSHA)) {
                    return false;
                }
                HashSHA other = (HashSHA)o;
                String this$algorithm = this.getAlgorithm();
                String other$algorithm = other.getAlgorithm();
                if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
                    return false;
                }
                String this$encoding = this.getEncoding();
                String other$encoding = other.getEncoding();
                if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $algorithm = this.getAlgorithm();
                result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
                String $encoding = this.getEncoding();
                result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            public String toString() {
                return "SendInvoiceRequest.InvoiceHash.HashSHA(algorithm=" + this.getAlgorithm() + ", encoding=" + this.getEncoding() + ", value=" + this.getValue() + ")";
            }

            public static class HashSHABuilder {
                private String algorithm;
                private String encoding;
                private String value;

                HashSHABuilder() {
                }

                public HashSHABuilder algorithm(String algorithm) {
                    this.algorithm = algorithm;
                    return this;
                }

                public HashSHABuilder encoding(String encoding) {
                    this.encoding = encoding;
                    return this;
                }

                public HashSHABuilder value(String value) {
                    this.value = value;
                    return this;
                }

                public HashSHA build() {
                    return new HashSHA(this.algorithm, this.encoding, this.value);
                }

                public String toString() {
                    return "SendInvoiceRequest.InvoiceHash.HashSHA.HashSHABuilder(algorithm=" + this.algorithm + ", encoding=" + this.encoding + ", value=" + this.value + ")";
                }
            }
        }

        public static class InvoiceHashBuilder {
            private HashSHA hashSHA;
            private int fileSize;

            InvoiceHashBuilder() {
            }

            public InvoiceHashBuilder hashSHA(HashSHA hashSHA) {
                this.hashSHA = hashSHA;
                return this;
            }

            public InvoiceHashBuilder fileSize(int fileSize) {
                this.fileSize = fileSize;
                return this;
            }

            public InvoiceHash build() {
                return new InvoiceHash(this.hashSHA, this.fileSize);
            }

            public String toString() {
                return "SendInvoiceRequest.InvoiceHash.InvoiceHashBuilder(hashSHA=" + this.hashSHA + ", fileSize=" + this.fileSize + ")";
            }
        }
    }

    public static final class InvoicePayload {
        private final String type;
        private final String invoiceBody;

        InvoicePayload(String type, String invoiceBody) {
            this.type = type;
            this.invoiceBody = invoiceBody;
        }

        public static InvoicePayloadBuilder builder() {
            return new InvoicePayloadBuilder();
        }

        public String getType() {
            return this.type;
        }

        public String getInvoiceBody() {
            return this.invoiceBody;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoicePayload)) {
                return false;
            }
            InvoicePayload other = (InvoicePayload)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$invoiceBody = this.getInvoiceBody();
            String other$invoiceBody = other.getInvoiceBody();
            return !(this$invoiceBody == null ? other$invoiceBody != null : !this$invoiceBody.equals(other$invoiceBody));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $invoiceBody = this.getInvoiceBody();
            result = result * 59 + ($invoiceBody == null ? 43 : $invoiceBody.hashCode());
            return result;
        }

        public String toString() {
            return "SendInvoiceRequest.InvoicePayload(type=" + this.getType() + ", invoiceBody=" + this.getInvoiceBody() + ")";
        }

        public static class InvoicePayloadBuilder {
            private String type;
            private String invoiceBody;

            InvoicePayloadBuilder() {
            }

            public InvoicePayloadBuilder type(String type) {
                this.type = type;
                return this;
            }

            public InvoicePayloadBuilder invoiceBody(String invoiceBody) {
                this.invoiceBody = invoiceBody;
                return this;
            }

            public InvoicePayload build() {
                return new InvoicePayload(this.type, this.invoiceBody);
            }

            public String toString() {
                return "SendInvoiceRequest.InvoicePayload.InvoicePayloadBuilder(type=" + this.type + ", invoiceBody=" + this.invoiceBody + ")";
            }
        }
    }

    public static class SendInvoiceRequestBuilder {
        private InvoiceHash invoiceHash;
        private InvoicePayload invoicePayload;

        SendInvoiceRequestBuilder() {
        }

        public SendInvoiceRequestBuilder invoiceHash(InvoiceHash invoiceHash) {
            this.invoiceHash = invoiceHash;
            return this;
        }

        public SendInvoiceRequestBuilder invoicePayload(InvoicePayload invoicePayload) {
            this.invoicePayload = invoicePayload;
            return this;
        }

        public SendInvoiceRequest build() {
            return new SendInvoiceRequest(this.invoiceHash, this.invoicePayload);
        }

        public String toString() {
            return "SendInvoiceRequest.SendInvoiceRequestBuilder(invoiceHash=" + this.invoiceHash + ", invoicePayload=" + this.invoicePayload + ")";
        }
    }
}

