/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.client.api;

import io.alapierre.ksef.client.ApiClient;
import io.alapierre.ksef.client.ApiException;
import io.alapierre.ksef.client.model.rest.auth.AuthorisationChallengeRequest;
import io.alapierre.ksef.client.model.rest.auth.AuthorisationToken;
import io.alapierre.ksef.client.model.rest.auth.CredentialStatus;
import io.alapierre.ksef.client.model.rest.auth.GenerateTokenRequest;
import io.alapierre.ksef.client.model.rest.auth.RevokeTokenRequest;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfejsyInteraktywneUprawnieniaApi {
    private static final Logger log = LoggerFactory.getLogger(InterfejsyInteraktywneUprawnieniaApi.class);
    public static final String BAD_API_RESPONSE = "Nieprawid\u0142owa odpowied\u017a z API";
    private final ApiClient apiClient;

    public CredentialStatus credentialStatus(@NotNull String token, @NotNull String credentialsElementReferenceNumber) throws ApiException {
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneUprawnieniaApi.credentialStatus must not be null");
        }
        if (credentialsElementReferenceNumber == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneUprawnieniaApi.credentialStatus must not be null");
        }
        String endpoint = String.format("online/Credentials/Status/%s", credentialsElementReferenceNumber);
        Optional ret = this.apiClient.getJson(endpoint, CredentialStatus.class, token);
        return (CredentialStatus)ret.orElseThrow(() -> new ApiException(BAD_API_RESPONSE));
    }

    @NotNull
    public AuthorisationToken generateToken(@NotNull String token, @NotNull String tokenDescription, GenerateTokenRequest.RoleType ... roles) throws ApiException {
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneUprawnieniaApi.generateToken must not be null");
        }
        if (tokenDescription == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneUprawnieniaApi.generateToken must not be null");
        }
        Set<GenerateTokenRequest.TokenCredentialsRoleList> rolesConverted = Arrays.stream(roles).map(roleType -> GenerateTokenRequest.TokenCredentialsRoleList.builder().roleDescription(tokenDescription).roleType((GenerateTokenRequest.RoleType)((Object)roleType)).build()).collect(Collectors.toSet());
        AuthorisationToken authorisationToken = this.generateToken(tokenDescription, token, rolesConverted);
        if (authorisationToken == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneUprawnieniaApi.generateToken must not return null");
        }
        return authorisationToken;
    }

    @NotNull
    public AuthorisationToken generateToken(@NotNull String tokenDescription, @NotNull String token, @NotNull Set<GenerateTokenRequest.TokenCredentialsRoleList> roles) throws ApiException {
        if (tokenDescription == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneUprawnieniaApi.generateToken must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneUprawnieniaApi.generateToken must not be null");
        }
        if (roles == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/api/InterfejsyInteraktywneUprawnieniaApi.generateToken must not be null");
        }
        GenerateTokenRequest req = GenerateTokenRequest.builder().generateToken(GenerateTokenRequest.GenerateToken.builder().credentialsRoleList(roles).description(tokenDescription).build()).build();
        Optional ret = this.apiClient.postJson("online/Credentials/GenerateToken", (Object)req, AuthorisationToken.class, token);
        AuthorisationToken authorisationToken = (AuthorisationToken)ret.orElseThrow(() -> new ApiException(BAD_API_RESPONSE));
        if (authorisationToken == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneUprawnieniaApi.generateToken must not return null");
        }
        return authorisationToken;
    }

    @NotNull
    public AuthorisationToken revokeToken(@NotNull String tokenToRemove, @NotNull String identifier, @NotNull AuthorisationChallengeRequest.IdentifierType type, @NotNull String token) throws ApiException {
        if (tokenToRemove == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneUprawnieniaApi.revokeToken must not be null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneUprawnieniaApi.revokeToken must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/api/InterfejsyInteraktywneUprawnieniaApi.revokeToken must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 of io/alapierre/ksef/client/api/InterfejsyInteraktywneUprawnieniaApi.revokeToken must not be null");
        }
        RevokeTokenRequest revoke = RevokeTokenRequest.builder().revokeToken(RevokeTokenRequest.RevokeToken.builder().tokenNumber(tokenToRemove).sourceTokenIdentifier(RevokeTokenRequest.SourceTokenIdentifier.builder().identifier(identifier).type(type).build()).build()).build();
        Optional ret = this.apiClient.postJson("online/Credentials/RevokeToken", (Object)revoke, AuthorisationToken.class, token);
        AuthorisationToken authorisationToken = (AuthorisationToken)ret.orElseThrow(() -> new ApiException(BAD_API_RESPONSE));
        if (authorisationToken == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneUprawnieniaApi.revokeToken must not return null");
        }
        return authorisationToken;
    }

    public InterfejsyInteraktywneUprawnieniaApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }
}

