/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.client.api;

import io.alapierre.ksef.client.ApiClient;
import io.alapierre.ksef.client.ApiException;
import io.alapierre.ksef.client.model.rest.auth.AuthorisationChallengeRequest;
import io.alapierre.ksef.client.model.rest.auth.AuthorisationChallengeResponse;
import io.alapierre.ksef.client.model.rest.auth.AuthorisationToken;
import io.alapierre.ksef.client.model.rest.auth.ContextIdentifier;
import io.alapierre.ksef.client.model.rest.auth.CredentialStatus;
import io.alapierre.ksef.client.model.rest.auth.GenerateTokenRequest;
import io.alapierre.ksef.client.model.rest.auth.InitSignedResponse;
import io.alapierre.ksef.client.model.rest.auth.SessionStatus;
import io.alapierre.ksef.client.model.rest.auth.SessionTerminateResponse;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfejsyInteraktywneSesjaApi {
    private static final Logger log = LoggerFactory.getLogger(InterfejsyInteraktywneSesjaApi.class);
    public static final String BAD_API_RESPONSE = "Nieprawid\u0142owa odpowied\u017a z API";
    private final ApiClient apiClient;

    @NotNull
    public AuthorisationChallengeResponse authorisationChallengeCall(@NotNull String identifier, @NotNull AuthorisationChallengeRequest.IdentifierType identifierType) throws ApiException {
        if (identifier == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.authorisationChallengeCall must not be null");
        }
        if (identifierType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.authorisationChallengeCall must not be null");
        }
        Optional ret = this.apiClient.postJson("online/Session/AuthorisationChallenge", (Object)this.getAuthorisationChallengeRequest(identifier, identifierType), AuthorisationChallengeResponse.class);
        AuthorisationChallengeResponse authorisationChallengeResponse = (AuthorisationChallengeResponse)ret.orElseThrow(() -> new ApiException(BAD_API_RESPONSE));
        if (authorisationChallengeResponse == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.authorisationChallengeCall must not return null");
        }
        return authorisationChallengeResponse;
    }

    @NotNull
    public InitSignedResponse initSessionSignedCall(byte[] signedRequest) throws ApiException {
        Optional ret = this.apiClient.postXMLFromBytes("online/Session/InitSigned", signedRequest, InitSignedResponse.class);
        InitSignedResponse initSignedResponse = (InitSignedResponse)ret.orElseThrow(() -> new ApiException(BAD_API_RESPONSE));
        if (initSignedResponse == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.initSessionSignedCall must not return null");
        }
        return initSignedResponse;
    }

    @NotNull
    public InitSignedResponse initSessionTokenCall(byte[] tokenRequest) throws ApiException {
        Optional ret = this.apiClient.postXMLFromBytes("online/Session/InitToken", tokenRequest, InitSignedResponse.class);
        InitSignedResponse initSignedResponse = (InitSignedResponse)ret.orElseThrow(() -> new ApiException(BAD_API_RESPONSE));
        if (initSignedResponse == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.initSessionTokenCall must not return null");
        }
        return initSignedResponse;
    }

    @NotNull
    public SessionStatus sessionStatus(@NotNull String token, int pageSize, int pageOffset) throws ApiException {
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.sessionStatus must not be null");
        }
        String endpoint = String.format("online/Session/Status?PageSize=%d&PageOffset=%d", pageSize, pageOffset);
        Optional ret = this.apiClient.getJson(endpoint, SessionStatus.class, token);
        SessionStatus sessionStatus = (SessionStatus)ret.orElseThrow(() -> new ApiException(BAD_API_RESPONSE));
        if (sessionStatus == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.sessionStatus must not return null");
        }
        return sessionStatus;
    }

    @NotNull
    public SessionStatus sessionStatusByReference(@NotNull String token, @NotNull String reference, int pageSize, int pageOffset) throws ApiException {
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.sessionStatusByReference must not be null");
        }
        if (reference == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.sessionStatusByReference must not be null");
        }
        String endpoint = String.format("online/Session/Status/%s?PageSize=%d&PageOffset=%d", reference, pageSize, pageOffset);
        Optional ret = this.apiClient.getJson(endpoint, SessionStatus.class, token);
        SessionStatus sessionStatus = (SessionStatus)ret.orElseThrow(() -> new ApiException(BAD_API_RESPONSE));
        if (sessionStatus == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.sessionStatusByReference must not return null");
        }
        return sessionStatus;
    }

    @NotNull
    public SessionStatus sessionStatusByReference(@NotNull String token, @NotNull String reference, int pageSize, int pageOffset, boolean details) throws ApiException {
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.sessionStatusByReference must not be null");
        }
        if (reference == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.sessionStatusByReference must not be null");
        }
        String endpoint = String.format("online/Session/Status/%s?PageSize=%d&PageOffset=%d&IncludeDetails=%b", reference, pageSize, pageOffset, details);
        Optional ret = this.apiClient.getJson(endpoint, SessionStatus.class, token);
        SessionStatus sessionStatus = (SessionStatus)ret.orElseThrow(() -> new ApiException(BAD_API_RESPONSE));
        if (sessionStatus == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.sessionStatusByReference must not return null");
        }
        return sessionStatus;
    }

    @NotNull
    public SessionTerminateResponse terminateSession(@NotNull String token) throws ApiException {
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.terminateSession must not be null");
        }
        Optional ret = this.apiClient.getJson("online/Session/Terminate", SessionTerminateResponse.class, token);
        SessionTerminateResponse sessionTerminateResponse = (SessionTerminateResponse)ret.orElseThrow(() -> new ApiException(BAD_API_RESPONSE));
        if (sessionTerminateResponse == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.terminateSession must not return null");
        }
        return sessionTerminateResponse;
    }

    @Deprecated
    @NotNull
    public CredentialStatus credentialStatus(String credentialsElementReferenceNumber, String token) throws ApiException {
        String endpoint = String.format("online/Credentials/Status/%s", credentialsElementReferenceNumber);
        Optional ret = this.apiClient.getJson(endpoint, CredentialStatus.class, token);
        CredentialStatus credentialStatus = (CredentialStatus)ret.orElseThrow(() -> new ApiException(BAD_API_RESPONSE));
        if (credentialStatus == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.credentialStatus must not return null");
        }
        return credentialStatus;
    }

    @Deprecated
    @NotNull
    public AuthorisationToken generateToken(@NotNull String tokenDescription, @NotNull String token, GenerateTokenRequest.RoleType ... roles) throws ApiException {
        if (tokenDescription == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.generateToken must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.generateToken must not be null");
        }
        Set<GenerateTokenRequest.TokenCredentialsRoleList> rolesConverted = Arrays.stream(roles).map(roleType -> GenerateTokenRequest.TokenCredentialsRoleList.builder().roleDescription(tokenDescription).roleType((GenerateTokenRequest.RoleType)((Object)roleType)).build()).collect(Collectors.toSet());
        AuthorisationToken authorisationToken = this.generateToken(tokenDescription, token, rolesConverted);
        if (authorisationToken == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.generateToken must not return null");
        }
        return authorisationToken;
    }

    @Deprecated
    @NotNull
    public AuthorisationToken generateToken(@NotNull String tokenDescription, @NotNull String token, @NotNull Set<GenerateTokenRequest.TokenCredentialsRoleList> roles) throws ApiException {
        if (tokenDescription == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.generateToken must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.generateToken must not be null");
        }
        if (roles == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.generateToken must not be null");
        }
        GenerateTokenRequest req = GenerateTokenRequest.builder().generateToken(GenerateTokenRequest.GenerateToken.builder().credentialsRoleList(roles).description(tokenDescription).build()).build();
        Optional ret = this.apiClient.postJson("online/Credentials/GenerateToken", (Object)req, AuthorisationToken.class, token);
        AuthorisationToken authorisationToken = (AuthorisationToken)ret.orElseThrow(() -> new ApiException(BAD_API_RESPONSE));
        if (authorisationToken == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.generateToken must not return null");
        }
        return authorisationToken;
    }

    @NotNull
    protected AuthorisationChallengeRequest getAuthorisationChallengeRequest(String identifier, AuthorisationChallengeRequest.IdentifierType identifierType) {
        AuthorisationChallengeRequest authorisationChallengeRequest = AuthorisationChallengeRequest.builder().contextIdentifier(ContextIdentifier.builder().type(identifierType).identifier(identifier).build()).build();
        if (authorisationChallengeRequest == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneSesjaApi.getAuthorisationChallengeRequest must not return null");
        }
        return authorisationChallengeRequest;
    }

    public InterfejsyInteraktywneSesjaApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }
}

