/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.client.api;

import io.alapierre.ksef.client.ApiClient;
import io.alapierre.ksef.client.ApiException;
import io.alapierre.ksef.client.model.rest.payment.KsefReferencesNumbers;
import io.alapierre.ksef.client.model.rest.payment.PaymentIdRequest;
import io.alapierre.ksef.client.model.rest.payment.PaymentIdResponse;
import java.util.Optional;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class InterfejsyInteraktywnePlatnosciApi {
    private final ApiClient apiClient;

    @NotNull
    public PaymentIdResponse createPaymentIdentifier(@NonNull String token, @NonNull PaymentIdRequest paymentIdRequest) throws ApiException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (paymentIdRequest == null) {
            throw new NullPointerException("paymentIdRequest is marked non-null but is null");
        }
        String endpoint = "/online/Payment/Identifier/Request";
        Optional ret = this.apiClient.postJson("/online/Payment/Identifier/Request", (Object)paymentIdRequest, PaymentIdResponse.class, token);
        PaymentIdResponse paymentIdResponse = (PaymentIdResponse)ret.orElseThrow(() -> new ApiException("Nieprawid\u0142owa odpowied\u017a z API"));
        if (paymentIdResponse == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywnePlatnosciApi.createPaymentIdentifier must not return null");
        }
        return paymentIdResponse;
    }

    public KsefReferencesNumbers getReferenceNumbers(@NonNull String token, @NonNull String paymentIdentifier) throws ApiException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (paymentIdentifier == null) {
            throw new NullPointerException("paymentIdentifier is marked non-null but is null");
        }
        String endpoint = String.format("online/Payment/Identifier/GetReferenceNumbers/%s", paymentIdentifier);
        Optional ret = this.apiClient.getJson(endpoint, KsefReferencesNumbers.class, token);
        return (KsefReferencesNumbers)ret.orElseThrow(() -> new ApiException("Nieprawid\u0142owa odpowied\u017a z API"));
    }

    public InterfejsyInteraktywnePlatnosciApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }
}

