/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.client.api;

import io.alapierre.io.IOUtils;
import io.alapierre.ksef.client.ApiClient;
import io.alapierre.ksef.client.ApiException;
import io.alapierre.ksef.client.model.rest.common.InvoiceRequest;
import io.alapierre.ksef.client.model.rest.invoice.InvoiceStatusResponse;
import io.alapierre.ksef.client.model.rest.invoice.SendInvoiceRequest;
import io.alapierre.ksef.client.model.rest.invoice.SendInvoiceResponse;
import io.alapierre.ksef.client.model.rest.invoice.SessionStatusResponse;
import io.alapierre.ksef.client.model.rest.invoice.UpoDTO;
import io.alapierre.ksef.client.model.rest.invoice.UpoResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfejsyInteraktywneFakturaApi {
    private static final Logger log = LoggerFactory.getLogger(InterfejsyInteraktywneFakturaApi.class);
    private final ApiClient apiClient;

    @NotNull
    public SendInvoiceResponse invoiceSend(File file, @NotNull String token) throws IOException, ApiException {
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.invoiceSend must not be null");
        }
        InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
        SendInvoiceResponse sendInvoiceResponse = this.invoiceSend(in, token);
        SendInvoiceResponse sendInvoiceResponse2 = sendInvoiceResponse;
        if (sendInvoiceResponse2 == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.invoiceSend must not return null");
        }
        return sendInvoiceResponse2;
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @NotNull
    public SendInvoiceResponse invoiceSend(InputStream inputStream, @NotNull String token) throws IOException, ApiException {
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.invoiceSend must not be null");
        }
        SendInvoiceResponse sendInvoiceResponse = this.invoiceSend(IOUtils.toByteArray((InputStream)inputStream), token);
        if (sendInvoiceResponse == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.invoiceSend must not return null");
        }
        return sendInvoiceResponse;
    }

    @NotNull
    public SendInvoiceResponse invoiceSend(byte[] invoiceBytes, @NotNull String token) throws ApiException {
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.invoiceSend must not be null");
        }
        SendInvoiceRequest request = InterfejsyInteraktywneFakturaApi.prepareSendInvoiceRequest(invoiceBytes);
        Optional response = this.apiClient.putJson("online/Invoice/Send", (Object)request, SendInvoiceResponse.class, token);
        SendInvoiceResponse sendInvoiceResponse = (SendInvoiceResponse)response.orElseThrow(() -> new ApiException("Nieprawid\u0142owa odpowied\u017a z API"));
        if (sendInvoiceResponse == null) {
            throw new IllegalStateException("NotNull method io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.invoiceSend must not return null");
        }
        return sendInvoiceResponse;
    }

    public InvoiceStatusResponse invoiceStatus(@NotNull String token, @NotNull String referenceNumber) throws ApiException {
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.invoiceStatus must not be null");
        }
        if (referenceNumber == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.invoiceStatus must not be null");
        }
        Optional ret = this.apiClient.getJson("online/Invoice/Status/" + referenceNumber, InvoiceStatusResponse.class, token);
        return (InvoiceStatusResponse)ret.orElseThrow(() -> new ApiException("Nieprawid\u0142owa odpowied\u017a z API"));
    }

    public static SendInvoiceRequest prepareSendInvoiceRequest(byte[] invoiceBytes) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] digest = messageDigest.digest(invoiceBytes);
            String digestBase64 = Base64.getEncoder().encodeToString(digest);
            String contentBase64 = Base64.getEncoder().encodeToString(invoiceBytes);
            return SendInvoiceRequest.builder().invoiceHash(SendInvoiceRequest.InvoiceHash.builder().fileSize(invoiceBytes.length).hashSHA(SendInvoiceRequest.InvoiceHash.HashSHA.builder().algorithm("SHA-256").encoding("Base64").value(digestBase64).build()).build()).invoicePayload(SendInvoiceRequest.InvoicePayload.builder().type("plain").invoiceBody(contentBase64).build()).build();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Brak algorytmu liczenia sumy kontrolnej SHA-256", e);
        }
    }

    public void getInvoice(@NotNull String referenceNumber, @NotNull String token, @NotNull OutputStream os) throws ApiException {
        if (referenceNumber == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.getInvoice must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.getInvoice must not be null");
        }
        if (os == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.getInvoice must not be null");
        }
        String endpoint = String.format("online/Invoice/Get/%s", referenceNumber);
        this.apiClient.getStream(endpoint, token, os);
    }

    public void getInvoice(@NotNull InvoiceRequest invoiceRequest, @NotNull OutputStream os) throws ApiException {
        if (invoiceRequest == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.getInvoice must not be null");
        }
        if (os == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.getInvoice must not be null");
        }
        String endpoint = "common/Invoice/KSeF";
        this.apiClient.postStream("common/Invoice/KSeF", (Object)invoiceRequest, os);
    }

    public UpoDTO getUpo(@NotNull String referenceNumber) throws ApiException {
        if (referenceNumber == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.getUpo must not be null");
        }
        String endpoint = String.format("common/Status/%s", referenceNumber);
        Optional resp = this.apiClient.getJson(endpoint, UpoResponse.class);
        UpoResponse upo = (UpoResponse)resp.orElseThrow(() -> new ApiException("Nieprawid\u0142owa odpowied\u017a z API"));
        byte[] decodedUpo = upo.getUpo() != null && !upo.getUpo().isEmpty() ? Base64.getDecoder().decode(upo.getUpo()) : null;
        return UpoDTO.builder().processingCode(upo.getProcessingCode()).upo(decodedUpo).referenceNumber(upo.getReferenceNumber()).processingDescription(upo.getProcessingDescription()).build();
    }

    public SessionStatusResponse sessionStatusWithUpoURL(@NotNull String referenceNumber) throws ApiException {
        if (referenceNumber == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.sessionStatusWithUpoURL must not be null");
        }
        String endpoint = String.format("common/Status/%s", referenceNumber);
        Optional resp = this.apiClient.getJsonWithAcceptHeader(endpoint, SessionStatusResponse.class, "application/vnd.v3+json");
        return (SessionStatusResponse)resp.orElseThrow(() -> new ApiException("Nieprawid\u0142owa odpowied\u017a z API"));
    }

    public void loadUpoByUrl(String upoUrl, @NotNull OutputStream os) throws ApiException {
        if (os == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/ksef/client/api/InterfejsyInteraktywneFakturaApi.loadUpoByUrl must not be null");
        }
        this.apiClient.getStream(upoUrl, "", os);
    }

    public InterfejsyInteraktywneFakturaApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }
}

