/*
 * Decompiled with CFR 0.152.
 */
package pl.akmf.ksef.sdk.api.services;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.Map;
import javax.imageio.ImageIO;
import pl.akmf.ksef.sdk.client.interfaces.QrCodeService;
import pl.akmf.ksef.sdk.client.model.ApiException;

public class DefaultQrCodeService
implements QrCodeService {
    @Override
    public byte[] generateQrCode(String payloadUrl) throws ApiException {
        return this.generateQrCode(payloadUrl, 20, 300);
    }

    @Override
    public byte[] addLabelToQrCode(byte[] qrCodePng, String label) throws ApiException {
        return this.addLabelToQrCode(qrCodePng, label, 14, "Arial");
    }

    @Override
    public byte[] generateQrCode(String payloadUrl, int pixelsPerModule, int qrCodeWidthAndHeight) throws ApiException {
        BufferedImage qrImage = this.createQrImage(payloadUrl, pixelsPerModule);
        BufferedImage resized = this.resizePng(qrImage, qrCodeWidthAndHeight, qrCodeWidthAndHeight);
        return this.toByteArray(resized);
    }

    @Override
    public byte[] addLabelToQrCode(byte[] qrPng, String label, int fontSizePx, String fontName) throws ApiException {
        ByteArrayInputStream is = new ByteArrayInputStream(qrPng);
        BufferedImage qrImage = DefaultQrCodeService.getBufferedImage(is);
        Font font = new Font(fontName, 1, fontSizePx);
        int labelHeight = fontSizePx + 4;
        int width = qrImage.getWidth();
        int height = qrImage.getHeight() + labelHeight;
        BufferedImage labeledImage = new BufferedImage(width, height, 1);
        Graphics2D g = labeledImage.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.drawImage((Image)qrImage, 0, 0, null);
        g.setFont(font);
        g.setColor(Color.BLACK);
        FontMetrics metrics = g.getFontMetrics();
        int textWidth = metrics.stringWidth(label);
        int x = (width - textWidth) / 2;
        int y = qrImage.getHeight() + (labelHeight + metrics.getAscent()) / 2 - 2;
        g.drawString(label, x, y);
        g.dispose();
        return this.toByteArray(labeledImage);
    }

    private static BufferedImage getBufferedImage(InputStream is) throws ApiException {
        try {
            return ImageIO.read(is);
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage());
        }
    }

    private BufferedImage createQrImage(String payloadUrl, int scale) throws ApiException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        EnumMap<EncodeHintType, Object> hints = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        hints.put(EncodeHintType.MARGIN, (Object)1);
        BitMatrix bitMatrix = DefaultQrCodeService.createBitMatrix(payloadUrl, qrCodeWriter, hints);
        int width = bitMatrix.getWidth() * scale;
        int height = bitMatrix.getHeight() * scale;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, width, height);
        graphics.setColor(Color.BLACK);
        for (int y = 0; y < bitMatrix.getHeight(); ++y) {
            for (int x = 0; x < bitMatrix.getWidth(); ++x) {
                if (!bitMatrix.get(x, y)) continue;
                graphics.fillRect(x * scale, y * scale, scale, scale);
            }
        }
        graphics.dispose();
        return image;
    }

    private static BitMatrix createBitMatrix(String payloadUrl, QRCodeWriter qrCodeWriter, Map<EncodeHintType, Object> hints) throws ApiException {
        try {
            return qrCodeWriter.encode(payloadUrl, BarcodeFormat.QR_CODE, 0, 0, hints);
        }
        catch (WriterException e) {
            throw new ApiException(e.getMessage());
        }
    }

    private BufferedImage resizePng(BufferedImage original, int targetWidth, int targetHeight) {
        BufferedImage resized = new BufferedImage(targetWidth, targetHeight, 1);
        Graphics2D g = resized.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(original, 0, 0, targetWidth, targetHeight, null);
        g.dispose();
        return resized;
    }

    private byte[] toByteArray(BufferedImage image) throws ApiException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage());
        }
    }
}

