/*
 * Decompiled with CFR 0.152.
 */
package pl.akmf.ksef.sdk.api.builders.certificate;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class CertificateBuilders {
    X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE);

    public CertificateBuilders withOrganizationName(String organizationName) {
        if (StringUtils.isNotBlank((CharSequence)organizationName)) {
            this.nameBuilder.addRDN(BCStyle.O, organizationName);
        }
        return this;
    }

    public CertificateBuilders withOrganizationIdentifier(String organizationIdentifier) {
        if (StringUtils.isNotBlank((CharSequence)organizationIdentifier)) {
            this.nameBuilder.addRDN(BCStyle.ORGANIZATION_IDENTIFIER, organizationIdentifier);
        }
        return this;
    }

    public CertificateBuilders withCommonName(String commonName) {
        if (StringUtils.isNotBlank((CharSequence)commonName)) {
            this.nameBuilder.addRDN(BCStyle.CN, commonName);
        }
        return this;
    }

    public CertificateBuilders withSerialNumber(String serialNumber) {
        if (StringUtils.isNotBlank((CharSequence)serialNumber)) {
            this.nameBuilder.addRDN(BCStyle.SERIALNUMBER, serialNumber);
        }
        return this;
    }

    public CertificateBuilders withGivenName(String givenName) {
        if (StringUtils.isNotBlank((CharSequence)givenName)) {
            this.nameBuilder.addRDN(BCStyle.GIVENNAME, givenName);
        }
        return this;
    }

    public CertificateBuilders withGivenNames(List<String> givenNames) {
        if (Objects.nonNull(givenNames)) {
            givenNames.stream().filter(StringUtils::isNotBlank).forEach(z -> this.nameBuilder.addRDN(BCStyle.GIVENNAME, z));
        }
        return this;
    }

    public CertificateBuilders withSurname(String surname) {
        if (StringUtils.isNotBlank((CharSequence)surname)) {
            this.nameBuilder.addRDN(BCStyle.SURNAME, surname);
        }
        return this;
    }

    public CertificateBuilders withUniqueIdentifier(String uniqueIdentifier) {
        if (StringUtils.isNotBlank((CharSequence)uniqueIdentifier)) {
            this.nameBuilder.addRDN(BCStyle.UNIQUE_IDENTIFIER, uniqueIdentifier);
        }
        return this;
    }

    public CertificateBuilders withCountryCode(String countryCode) {
        if (StringUtils.isNotBlank((CharSequence)countryCode)) {
            this.nameBuilder.addRDN(BCStyle.C, countryCode);
        }
        return this;
    }

    public X500NameHolder build() {
        X500Name x500Name = this.nameBuilder.build();
        return new X500NameHolder(x500Name);
    }

    public X500NameHolder buildForOrganization(String organizationName, String organizationIdentifier, String commonName, String countryCode) {
        this.withOrganizationIdentifier(organizationIdentifier);
        this.withOrganizationName(organizationName);
        this.withCommonName(commonName);
        this.withCountryCode(countryCode);
        return this.build();
    }

    public X500NameHolder buildForPerson(String givenName, String surname, String serialNumber, String commonName, String countryCode) {
        this.withGivenName(givenName);
        this.withSurname(surname);
        this.withSerialNumber(serialNumber);
        this.withCommonName(commonName);
        this.withCountryCode(countryCode);
        return this.build();
    }

    public static class X500NameHolder {
        private final X500Name x500Name;

        public X500NameHolder(X500Name x500Name) {
            this.x500Name = x500Name;
        }

        public X500Name getX500Name() {
            return this.x500Name;
        }
    }
}

