/*
 * Decompiled with CFR 0.152.
 */
package pl.com.softproject.utils.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.util.JAXBSource;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pl.com.softproject.utils.xml.XMLParseException;
import pl.com.softproject.utils.xml.XMLValidator;

public class JAXBXMLValidator {
    private JAXBContext jc;
    private SchemaFactory sf;
    private Schema schema;
    public String schemaLoaction;

    public JAXBXMLValidator(String contextPath, String xsdFileName, String schemaLocation) {
        this.schemaLoaction = schemaLocation;
        try {
            this.jc = JAXBContext.newInstance((String)contextPath);
            this.sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = this.getClass().getClassLoader().getResource(xsdFileName);
            Objects.requireNonNull(url, "problem z odczytaniem z classpath pliku schemy XML " + xsdFileName);
            this.schema = this.sf.newSchema(url);
        }
        catch (JAXBException | SAXException ex) {
            throw new XMLParseException(ex.getMessage(), ex);
        }
    }

    public <T> boolean validate(T jaxbXmlObject, List<SAXParseException> exceptions) {
        try {
            JAXBSource source = new JAXBSource(this.jc, jaxbXmlObject);
            Validator validator = this.schema.newValidator();
            if (exceptions == null) {
                exceptions = new ArrayList<SAXParseException>();
            }
            validator.setErrorHandler(new XMLValidator.XMLErrorExtensionHandler(exceptions));
            validator.validate((Source)source);
            return exceptions.isEmpty();
        }
        catch (JAXBException | SAXException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new XMLParseException(ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

