/*
 * Decompiled with CFR 0.152.
 */
package pl.com.softproject.utils.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import pl.com.softproject.utils.xml.XMLParseException;

public class BaseXMLSerializer<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseXMLSerializer.class);
    private final JAXBContext jc;
    private final Schema schema;
    private final boolean noNameSpace;
    public String schemaLoaction;

    public BaseXMLSerializer(String contextPath, String xsdFileName, String schemaLocation) {
        this(contextPath, xsdFileName, schemaLocation, false);
    }

    public BaseXMLSerializer(String contextPath, String xsdFileName, String schemaLocation, boolean noNameSpace) {
        this.schemaLoaction = schemaLocation;
        this.noNameSpace = noNameSpace;
        try {
            this.jc = JAXBContext.newInstance((String)contextPath);
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = this.getClass().getClassLoader().getResource(xsdFileName);
            this.schema = sf.newSchema(url);
        }
        catch (JAXBException | SAXException ex) {
            throw new XMLParseException(ex.getMessage(), ex);
        }
    }

    public T fromFile(File file) {
        return this.fromFile(file, true);
    }

    public T fromFile(File file, boolean validate) {
        try {
            Unmarshaller unmarshaller = this.jc.createUnmarshaller();
            if (validate) {
                unmarshaller.setSchema(this.schema);
            }
            Object document = unmarshaller.unmarshal(file);
            return (T)document;
        }
        catch (JAXBException ex) {
            throw new XMLParseException(ex.getMessage(), ex);
        }
    }

    public T fromStream(InputStream stream) {
        return this.fromStream(stream, true);
    }

    public T fromStream(InputStream stream, boolean validate) {
        try {
            Unmarshaller unmarshaller = this.jc.createUnmarshaller();
            if (validate) {
                unmarshaller.setSchema(this.schema);
            }
            Object document = unmarshaller.unmarshal(stream);
            return (T)document;
        }
        catch (JAXBException ex) {
            throw new XMLParseException(ex.getMessage(), ex);
        }
    }

    public T fromReader(Reader reader) {
        return this.fromReader(reader, true);
    }

    public T fromReader(Reader reader, boolean validate) {
        try {
            Unmarshaller unmarshaller = this.jc.createUnmarshaller();
            if (validate) {
                unmarshaller.setSchema(this.schema);
            }
            Object document = unmarshaller.unmarshal(reader);
            return (T)document;
        }
        catch (JAXBException ex) {
            throw new XMLParseException(ex.getMessage(), ex);
        }
    }

    public T fromString(String xml) {
        return this.fromString(xml, true);
    }

    public T fromString(String xml, boolean validate) {
        try {
            Unmarshaller unmarshaller = this.jc.createUnmarshaller();
            if (validate) {
                unmarshaller.setSchema(this.schema);
            }
            Object wniosek = unmarshaller.unmarshal((Reader)new StringReader(xml));
            return (T)wniosek;
        }
        catch (JAXBException ex) {
            throw new XMLParseException(ex.getMessage(), ex);
        }
    }

    public void toStream(T order, OutputStream os) {
        this.toStream(order, os, false);
    }

    public void toStream(T order, OutputStream os, boolean validate) {
        try {
            Marshaller marshaller = this.jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            if (validate) {
                marshaller.setSchema(this.schema);
            }
            marshaller.marshal(order, os);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public void toFile(T dictionarys, String fileName) {
        this.toFile(dictionarys, fileName, true);
    }

    public void toFile(T document, String fileName, boolean validate) {
        try (FileOutputStream out = new FileOutputStream(fileName);){
            Marshaller marshaller = this.jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            if (this.noNameSpace) {
                marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)this.schemaLoaction);
            } else {
                marshaller.setProperty("jaxb.schemaLocation", (Object)this.schemaLoaction);
            }
            if (validate) {
                marshaller.setSchema(this.schema);
            }
            marshaller.marshal(document, (OutputStream)out);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new XMLParseException(ex.getMessage(), ex);
        }
    }

    public void toFile(T document, String fileName, String encoding) {
        this.toFile(document, fileName, encoding, true);
    }

    public void toFile(T document, String fileName, String encoding, boolean validate) {
        try (FileOutputStream out = new FileOutputStream(fileName);){
            Marshaller marshaller = this.jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)encoding);
            if (this.noNameSpace) {
                marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)this.schemaLoaction);
            } else {
                marshaller.setProperty("jaxb.schemaLocation", (Object)this.schemaLoaction);
            }
            if (validate) {
                marshaller.setSchema(this.schema);
            }
            marshaller.marshal(document, (OutputStream)out);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new XMLParseException(ex.getMessage(), ex);
        }
    }

    public String toString(T document) {
        return this.toString(document, true);
    }

    public String toString(T document, boolean validate) {
        try {
            Marshaller marshaller = this.jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            if (this.noNameSpace) {
                marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)this.schemaLoaction);
            } else {
                marshaller.setProperty("jaxb.schemaLocation", (Object)this.schemaLoaction);
            }
            if (validate) {
                marshaller.setSchema(this.schema);
            }
            StringWriter sw = new StringWriter();
            marshaller.marshal(document, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException ex) {
            throw new XMLParseException(ex.getMessage(), ex);
        }
    }

    public JAXBElement convertFromDomNode(Node domNode, Class jaxbType) {
        try {
            Unmarshaller unmarshaller = this.jc.createUnmarshaller();
            return unmarshaller.unmarshal(domNode, jaxbType);
        }
        catch (JAXBException ex) {
            throw new XMLParseException(ex.getMessage(), ex);
        }
    }

    private void quietlyClose(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException ex) {
                log.warn(ex.getMessage());
            }
        }
    }
}

