/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.common.util;

import java.util.Optional;
import java.util.function.Consumer;

public class ExtendedOptional<T> {
    private final Optional<T> optional;

    private ExtendedOptional(Optional<T> optional) {
        this.optional = optional;
    }

    public static <T> ExtendedOptional<T> of(Optional<T> optional) {
        return new ExtendedOptional<T>(optional);
    }

    public ExtendedOptional<T> ifPresent(Consumer<T> c) {
        this.optional.ifPresent(c);
        return this;
    }

    public ExtendedOptional<T> ifNotPresent(Runnable r) {
        if (!this.optional.isPresent()) {
            r.run();
        }
        return this;
    }

    public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        if (!this.optional.isPresent()) {
            emptyAction.run();
        } else {
            action.accept(this.optional.get());
        }
    }
}

