/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.io;

import io.alapierre.io.IOConsumer;
import io.alapierre.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleReader {
    private static final Logger log = LoggerFactory.getLogger(MultipleReader.class);
    protected final byte[] content;

    public MultipleReader(byte[] content) {
        this.content = content;
    }

    public MultipleReader(Reader in) throws IOException {
        try {
            this.content = IOUtils.toByteArray(in, StandardCharsets.UTF_8);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public MultipleReader(InputStream is) throws IOException {
        try {
            this.content = IOUtils.toByteArray(is);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public static MultipleReader fromOutputStream(IOConsumer<OutputStream> function) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            function.accept(outputStream);
            MultipleReader multipleReader = new MultipleReader(outputStream.toByteArray());
            return multipleReader;
        }
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content);
    }

    public Reader getReader() {
        return new StringReader(new String(this.content, StandardCharsets.UTF_8));
    }

    public byte[] asByteArrray() {
        return this.content;
    }

    public File asTemporaryFile(String prefix, String suffix) throws IOException {
        File tmp = File.createTempFile(prefix, suffix);
        tmp.deleteOnExit();
        Files.write(tmp.toPath(), this.content, new OpenOption[0]);
        return tmp;
    }
}

