/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import org.weakref.jmx.ObjectNameBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectNames {
    public static String generatedNameOf(Class<?> clazz) {
        return String.format("%s:name=%s", clazz.getPackage().getName(), clazz.getSimpleName());
    }

    public static String generatedNameOf(Class<?> clazz, Annotation annotation) {
        return String.format("%s:type=%s,name=%s", clazz.getPackage().getName(), clazz.getSimpleName(), annotation.annotationType().getSimpleName());
    }

    public static String generatedNameOf(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return String.format("%s:type=%s,name=%s", clazz.getPackage().getName(), clazz.getSimpleName(), annotationClass.getSimpleName());
    }

    public static String generatedNameOf(Class<?> clazz, Named named) {
        return ObjectNames.generatedNameOf(clazz, named.value());
    }

    public static String generatedNameOf(Class<?> clazz, String name) {
        return String.format("%s:type=%s,name=%s", clazz.getPackage().getName(), clazz.getSimpleName(), ObjectNames.quoteValueIfNecessary(name));
    }

    static String quoteValueIfNecessary(String name) {
        boolean needQuote = false;
        StringBuilder builder = new StringBuilder("\"");
        block6: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case ',': 
                case ':': 
                case '=': {
                    needQuote = true;
                    builder.append(c);
                    continue block6;
                }
                case '\"': 
                case '*': 
                case '?': {
                    needQuote = true;
                    builder.append('\\');
                    builder.append(c);
                    continue block6;
                }
                case '\n': {
                    needQuote = true;
                    builder.append("\\n");
                    continue block6;
                }
                case '\\': {
                    builder.append("\\\\");
                    continue block6;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        if (needQuote) {
            name = builder.append('\"').toString();
        }
        return name;
    }

    public static ObjectNameBuilder builder(Class<?> clazz) {
        return new ObjectNameBuilder(clazz.getPackage().getName()).withProperty("name", clazz.getSimpleName());
    }

    public static ObjectNameBuilder builder(Class<?> clazz, Annotation annotation) {
        return new ObjectNameBuilder(clazz.getPackage().getName()).withProperty("type", clazz.getSimpleName()).withProperty("name", annotation.annotationType().getSimpleName());
    }

    public static ObjectNameBuilder builder(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        return new ObjectNameBuilder(clazz.getPackage().getName()).withProperty("type", clazz.getSimpleName()).withProperty("name", annotationClass.getSimpleName());
    }

    public static ObjectNameBuilder builder(Class<?> clazz, Named named) {
        return new ObjectNameBuilder(clazz.getPackage().getName()).withProperty("type", clazz.getSimpleName()).withProperty("name", named.value());
    }
}

