/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.AnnouncementHttpServerInfo;
import io.airlift.event.client.EventBinder;
import io.airlift.http.server.HttpRequestEvent;
import io.airlift.http.server.HttpServer;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.HttpServerProvider;
import io.airlift.http.server.LocalAnnouncementHttpServerInfo;
import io.airlift.http.server.RequestStats;
import io.airlift.http.server.TheAdminServlet;
import io.airlift.http.server.TheServlet;
import javax.servlet.Filter;
import org.weakref.jmx.guice.ExportBinder;

public class HttpServerModule
implements Module {
    public static final String REALM_NAME = "Airlift";

    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(HttpServer.class).toProvider(HttpServerProvider.class).in(Scopes.SINGLETON);
        binder.bind(HttpServerInfo.class).in(Scopes.SINGLETON);
        binder.bind(RequestStats.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class);
        Multibinder.newSetBinder((Binder)binder, Filter.class, TheAdminServlet.class);
        Multibinder.newSetBinder((Binder)binder, HttpServerBinder.HttpResourceBinding.class, TheServlet.class);
        ExportBinder.newExporter((Binder)binder).export(RequestStats.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfig(HttpServerConfig.class);
        EventBinder.eventBinder((Binder)binder).bindEventClient(new Class[]{HttpRequestEvent.class});
        binder.bind(AnnouncementHttpServerInfo.class).to(LocalAnnouncementHttpServerInfo.class).in(Scopes.SINGLETON);
    }
}

