/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.discovery.client.HttpServiceSelector;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HttpServiceSelectorImpl
implements HttpServiceSelector {
    private final ServiceSelector serviceSelector;

    public HttpServiceSelectorImpl(ServiceSelector serviceSelector) {
        Preconditions.checkNotNull((Object)serviceSelector, (Object)"serviceSelector is null");
        this.serviceSelector = serviceSelector;
    }

    @Override
    public String getType() {
        return this.serviceSelector.getType();
    }

    @Override
    public String getPool() {
        return this.serviceSelector.getPool();
    }

    @Override
    public List<URI> selectHttpService() {
        ArrayList serviceDescriptors = Lists.newArrayList(this.serviceSelector.selectAllServices());
        if (serviceDescriptors.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList httpsUri = Lists.newArrayList();
        for (ServiceDescriptor serviceDescriptor : serviceDescriptors) {
            String https = serviceDescriptor.getProperties().get("https");
            if (https == null) continue;
            try {
                httpsUri.add(new URI(https));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        ArrayList httpUri = Lists.newArrayList();
        for (ServiceDescriptor serviceDescriptor : serviceDescriptors) {
            String http = serviceDescriptor.getProperties().get("http");
            if (http == null) continue;
            try {
                httpUri.add(new URI(http));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        Collections.shuffle(httpsUri);
        Collections.shuffle(httpUri);
        return ImmutableList.builder().addAll((Iterable)httpsUri).addAll((Iterable)httpUri).build();
    }
}

