/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal.gdp;

import android.app.ActivityManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.opengl.GLES20;
import android.os.BatteryManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.rtc2.internal.CommonUtility;
import io.agora.rtc2.internal.gdp.EglCore;
import io.agora.rtc2.internal.gdp.OffscreenSurface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class GDPAndroid {
    private static final String TAG = "GDPAndroid";
    private static final int OP_TIMEOUT_MS = 20;
    private static final int DEVICEINFO_UNKNOWN = -1;
    private static boolean mockGDPAndroid = false;
    private String mGpuVendor = "unkown";
    private String mGpuRenderer = "unkown";
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("cpu")) {
                for (int i = 3; i < path.length(); ++i) {
                    if (Character.isDigit(path.charAt(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };
    private static final List<String> CPU_TEMP_FILE_PATHS = Arrays.asList("/sys/devices/system/cpu/cpu0/cpufreq/cpu_temp", "/sys/devices/system/cpu/cpu0/cpufreq/FakeShmoo_cpu_temp", "/sys/class/thermal/thermal_zone0/temp", "/sys/class/i2c-adapter/i2c-4/4-004c/temperature", "/sys/devices/platform/tegra-i2c.3/i2c-4/4-004c/temperature", "/sys/devices/platform/omap/omap_temp_sensor.0/temperature", "/sys/devices/platform/tegra_tmon/temp1_input", "/sys/kernel/debug/tegra_thermal/temp_tj", "/sys/devices/platform/s5p-tmu/temperature", "/sys/class/thermal/thermal_zone1/temp", "/sys/class/hwmon/hwmon0/device/temp1_input", "/sys/devices/virtual/thermal/thermal_zone1/temp", "/sys/devices/virtual/thermal/thermal_zone0/temp", "/sys/class/thermal/thermal_zone3/temp", "/sys/class/thermal/thermal_zone4/temp", "/sys/class/hwmon/hwmonX/temp1_input", "/sys/devices/platform/s5p-tmu/curr_temp");

    @CalledByNative
    public GDPAndroid() {
        if (this.isEGL14SupportedHere() && !CommonUtility.isSimulator()) {
            this.gatherGlInfo();
        }
    }

    @CalledByNative
    public int getCpuCores() {
        NumberOfCpuCores noc = new NumberOfCpuCores();
        return noc.getNumberOfCpuCoresSafe();
    }

    @CalledByNative
    public int getCpuClock() {
        CPUMaxFreqKHz cmf = new CPUMaxFreqKHz();
        return cmf.getCPUMaxFreqKHzSafe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public String getCpuVendor() {
        FileReader fr = null;
        String text = "";
        String cpuName = "";
        try {
            fr = new FileReader("/proc/cpuinfo");
            BufferedReader br = new BufferedReader(fr);
            while ((text = br.readLine()) != null) {
                if (!text.contains("Hardware")) continue;
                String[] array = text.split(":\\s+", 2);
                cpuName = array[1];
                break;
            }
            fr.close();
        }
        catch (FileNotFoundException e) {
            Logging.e(TAG, "getCpuName failed, no /proc/cpuinfo found in system", e);
        }
        catch (IOException e) {
            Logging.e(TAG, "getCpuName failed,", e);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    Logging.e(TAG, "failed to close proc file", e);
                }
            }
        }
        return cpuName + ", " + Build.HARDWARE;
    }

    @CalledByNative
    public int getRam() {
        TotalMemory tm = new TotalMemory();
        return tm.getTotalMemorySafe();
    }

    @CalledByNative
    public String getGpuVendor() {
        return this.mGpuVendor;
    }

    @CalledByNative
    public String getGpuRenderer() {
        return this.mGpuRenderer;
    }

    @CalledByNative
    public int getOsVersion() {
        return Build.VERSION.SDK_INT;
    }

    @CalledByNative
    public int getBattery() {
        BatteryLevel bl = new BatteryLevel();
        return bl.getBatteryLevelSafe();
    }

    private boolean isEGL14SupportedHere() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private void gatherGlInfo() {
        try {
            HandlerThread handlerThread = new HandlerThread("Get_GL_info_thread");
            handlerThread.start();
            Handler handler = new Handler(handlerThread.getLooper());
            ThreadUtils.invokeAtFrontUninterruptibly(handler, new Runnable(){

                @Override
                public void run() {
                    EglCore eglCore = new EglCore(null, 2);
                    OffscreenSurface surface = new OffscreenSurface(eglCore, 1, 1);
                    surface.makeCurrent();
                    GDPAndroid.this.mGpuVendor = GLES20.glGetString((int)7936);
                    GDPAndroid.this.mGpuRenderer = GLES20.glGetString((int)7937);
                    surface.release();
                    eglCore.release();
                }
            });
            handlerThread.quit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int getBatteryLevel() {
        if (ContextUtils.getApplicationContext() != null) {
            if (Build.VERSION.SDK_INT >= 21 && !mockGDPAndroid) {
                BatteryManager batteryManager = (BatteryManager)ContextUtils.getApplicationContext().getSystemService("batterymanager");
                if (batteryManager != null) {
                    return batteryManager.getIntProperty(4);
                }
            } else {
                Intent intent = new ContextWrapper(ContextUtils.getApplicationContext()).registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
                if (intent != null) {
                    return intent.getIntExtra("level", -1) * 100 / intent.getIntExtra("scale", -1);
                }
            }
        }
        return 0;
    }

    @CalledByNative
    public boolean checkBackground() {
        BackGround bg = new BackGround();
        return bg.checkBackgroundSafe();
    }

    private static int getNumberOfCPUCores() {
        AtomicInteger cores = new AtomicInteger();
        try {
            cores.set(GDPAndroid.getCoresFromFileInfo("/sys/devices/system/cpu/possible"));
            if (cores.get() == -1 || mockGDPAndroid) {
                cores.set(GDPAndroid.getCoresFromFileInfo("/sys/devices/system/cpu/present"));
            }
            if (cores.get() == -1 || mockGDPAndroid) {
                cores.set(GDPAndroid.getCoresFromCPUFileList());
            }
        }
        catch (SecurityException e) {
            cores.set(-1);
        }
        catch (NullPointerException e) {
            cores.set(-1);
        }
        Logging.d(TAG, "cores:" + cores);
        return cores.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCoresFromFileInfo(String fileLocation) {
        FileInputStream is = null;
        BufferedReader buf = null;
        try {
            is = new FileInputStream(fileLocation);
            buf = new BufferedReader(new InputStreamReader(is));
            String fileContents = buf.readLine();
            int n = GDPAndroid.getCoresFromFileString(fileContents);
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
                if (buf != null) {
                    buf.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static int getCoresFromFileString(String str) {
        if (str == null || !str.matches("0-[\\d]+$")) {
            return -1;
        }
        return Integer.valueOf(str.substring(2)) + 1;
    }

    private static int getCoresFromCPUFileList() {
        return new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getMaxFreq(int i, int maxFreq) throws IOException {
        String filename = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_max_freq";
        File cpuInfoMaxFreqFile = new File(filename);
        if (cpuInfoMaxFreqFile.exists() && cpuInfoMaxFreqFile.canRead()) {
            byte[] buffer = new byte[128];
            try {
                FileInputStream stream = new FileInputStream(cpuInfoMaxFreqFile);
                try {
                    int endIndex;
                    int read = stream.read(buffer);
                    for (endIndex = 0; Character.isDigit(buffer[endIndex]) && endIndex < read; ++endIndex) {
                    }
                    String str = new String(buffer, 0, endIndex);
                    int freqBound = Integer.parseInt(str);
                    if (freqBound > maxFreq) {
                        maxFreq = freqBound;
                    }
                }
                finally {
                    stream.close();
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return maxFreq;
    }

    private static int getCPUMaxFreqKHz() {
        int maxFreq = -1;
        try {
            for (int i = 0; i < GDPAndroid.getNumberOfCPUCores(); ++i) {
                maxFreq = GDPAndroid.getMaxFreq(i, maxFreq);
            }
            if (maxFreq == -1 || mockGDPAndroid) {
                maxFreq = GDPAndroid.getUnknowCPUMax(maxFreq);
            }
        }
        catch (IOException e) {
            maxFreq = -1;
        }
        Logging.d(TAG, "max freq:" + maxFreq);
        return maxFreq;
    }

    public static int getUnknowCPUMax(int maxFreq) throws IOException {
        try {
            FileInputStream stream = new FileInputStream("/proc/cpuinfo");
            int freqBound = GDPAndroid.parseFileForValue("cpu MHz", stream);
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if ((freqBound *= 1000) > maxFreq) {
                return freqBound;
            }
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return -1;
    }

    private static long getTotalMemory(Context c) {
        if (c == null) {
            return 0L;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            ActivityManager am = (ActivityManager)c.getSystemService("activity");
            if (am != null) {
                am.getMemoryInfo(memInfo);
            }
            Logging.d(TAG, "total mem:" + memInfo.totalMem);
            return memInfo.totalMem;
        }
        return 0L;
    }

    private static int match(int i, String textToMatch, int length, byte[] buffer) {
        int textIndex;
        for (int j = i; j < length && buffer[j] == textToMatch.charAt(textIndex = j - i); ++j) {
            if (textIndex != textToMatch.length() - 1) continue;
            return GDPAndroid.extractValue(buffer, j);
        }
        return -1;
    }

    private static int parseFileForValue(String textToMatch, FileInputStream stream) {
        byte[] buffer = new byte[1024];
        try {
            int length = stream.read(buffer);
            for (int i = 0; i < length; ++i) {
                int result;
                if (buffer[i] != 10 && i != 0) continue;
                if (buffer[i] == 10) {
                    ++i;
                }
                if ((result = GDPAndroid.match(i, textToMatch, length, buffer)) <= 0) continue;
                return result;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return -1;
    }

    private static int extractValue(byte[] buffer, int index) {
        while (index < buffer.length && buffer[index] != 10) {
            if (Character.isDigit(buffer[index])) {
                int start = index++;
                while (index < buffer.length && Character.isDigit(buffer[index])) {
                    ++index;
                }
                String str = new String(buffer, 0, start, index - start);
                return Integer.parseInt(str);
            }
            ++index;
        }
        return -1;
    }

    public int getCpuTemperature() {
        CPUTemperature ct = new CPUTemperature();
        return ct.getCpuTemperatureSafe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double readOneLine(File file) {
        String s = "";
        if (!file.exists() || !file.canRead()) {
            return -100000.0;
        }
        double result = -100000.0;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            s = bufferedReader.readLine();
            result = Double.parseDouble(s);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static boolean isTemperatureValid(double temp) {
        return temp >= -30.0 && temp <= 250.0;
    }

    public static void setMockGDPAndroid(boolean mock) {
        mockGDPAndroid = mock;
    }

    static class BatteryLevel
    implements Runnable {
        static int batt = 0;
        final CountDownLatch runDone = new CountDownLatch(1);

        BatteryLevel() {
        }

        @Override
        public void run() {
            batt = GDPAndroid.getBatteryLevel();
            this.runDone.countDown();
        }

        public int getBatteryLevelSafe() {
            new Thread(this).start();
            if (!ThreadUtils.awaitUninterruptibly(this.runDone, 20L)) {
                Logging.e(GDPAndroid.TAG, "getBatteryLevelSafe timeout");
            }
            return batt;
        }
    }

    static class TotalMemory
    implements Runnable {
        static int mem = 0;
        final CountDownLatch runDone = new CountDownLatch(1);

        TotalMemory() {
        }

        @Override
        public void run() {
            mem = (int)(GDPAndroid.getTotalMemory(ContextUtils.getApplicationContext()) / 1024L);
            this.runDone.countDown();
        }

        public int getTotalMemorySafe() {
            new Thread(this).start();
            if (!ThreadUtils.awaitUninterruptibly(this.runDone, 20L)) {
                Logging.e(GDPAndroid.TAG, "getTotalMemorySafe timeout");
            }
            return mem;
        }
    }

    static class CPUMaxFreqKHz
    implements Runnable {
        static int freq = -1;
        final CountDownLatch runDone = new CountDownLatch(1);

        CPUMaxFreqKHz() {
        }

        @Override
        public void run() {
            freq = GDPAndroid.getCPUMaxFreqKHz();
            this.runDone.countDown();
        }

        public int getCPUMaxFreqKHzSafe() {
            new Thread(this).start();
            if (!ThreadUtils.awaitUninterruptibly(this.runDone, 20L)) {
                Logging.e(GDPAndroid.TAG, "getCPUMaxFreqKHzSafe timeout");
            }
            return freq;
        }
    }

    static class NumberOfCpuCores
    implements Runnable {
        static int cores = -1;
        final CountDownLatch runDone = new CountDownLatch(1);

        NumberOfCpuCores() {
        }

        @Override
        public void run() {
            cores = GDPAndroid.getNumberOfCPUCores();
            this.runDone.countDown();
        }

        public int getNumberOfCpuCoresSafe() {
            new Thread(this).start();
            if (!ThreadUtils.awaitUninterruptibly(this.runDone, 20L)) {
                Logging.e(GDPAndroid.TAG, "getNumberOfCpuCoresSafe timeout");
            }
            return cores;
        }
    }

    static class BackGround
    implements Runnable {
        static boolean bg = false;
        final CountDownLatch runDone = new CountDownLatch(1);

        BackGround() {
        }

        @Override
        public void run() {
            ActivityManager.RunningAppProcessInfo appProcessInfo = new ActivityManager.RunningAppProcessInfo();
            ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)appProcessInfo);
            bg = appProcessInfo.importance != 100 && appProcessInfo.importance != 200;
            this.runDone.countDown();
        }

        public boolean checkBackgroundSafe() {
            new Thread(this).start();
            if (!ThreadUtils.awaitUninterruptibly(this.runDone, 20L)) {
                Logging.e(GDPAndroid.TAG, "checkBackgroundSafe timeout");
            }
            return bg;
        }
    }

    static class CPUTemperature
    implements Runnable {
        static double currentTemp = 0.0;
        final CountDownLatch runDone = new CountDownLatch(1);

        CPUTemperature() {
        }

        @Override
        public void run() {
            for (int i = 0; i < CPU_TEMP_FILE_PATHS.size(); ++i) {
                String path = (String)CPU_TEMP_FILE_PATHS.get(i);
                double temp = GDPAndroid.readOneLine(new File(path));
                if (GDPAndroid.isTemperatureValid(temp) || mockGDPAndroid) {
                    currentTemp = temp;
                    Logging.d(GDPAndroid.TAG, "getCpuTemperature valid path:" + path);
                    break;
                }
                if (!GDPAndroid.isTemperatureValid(temp / 1000.0)) continue;
                currentTemp = temp / 1000.0;
                Logging.d(GDPAndroid.TAG, "getCpuTemperature valid path:" + path);
                break;
            }
            this.runDone.countDown();
        }

        public int getCpuTemperatureSafe() {
            new Thread(this).start();
            if (!ThreadUtils.awaitUninterruptibly(this.runDone, 20L)) {
                Logging.e(GDPAndroid.TAG, "getCpuTemperatureSafe timeout");
            }
            return (int)(currentTemp * 1000.0);
        }
    }
}

