/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import io.agora.base.internal.ContextUtils;
import io.agora.rtc2.internal.HardwareEarMonitorListener;
import io.agora.rtc2.internal.IHardwareEarMonitor;
import io.agora.rtc2.internal.Logging;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class HuaweiHardwareEarMonitor
implements IHardwareEarMonitor {
    private static final String TAG = HuaweiHardwareEarMonitor.class.getSimpleName();
    private AudioKitCallbackImpl mAudioKitCallbackImpl = new AudioKitCallbackImpl();
    private HardwareEarMonitorListener mListener;
    private Context mContext;
    private Object mHwAudioKit = null;
    private Object mHwAudioKaraokeFeatureKit = null;
    private Class<?> mHwAudioKaraokeFeatureKitClass;
    private Class<?> mHwAudioKitClass;
    private Class<?> mParamNameClass;
    private volatile boolean mInitialized = false;
    private volatile boolean mEarMonitorEnabled = false;

    public HuaweiHardwareEarMonitor(HardwareEarMonitorListener listener) {
        Logging.i(TAG, ">>ctor");
        this.mListener = listener;
        this.mContext = ContextUtils.getApplicationContext();
    }

    @VisibleForTesting
    void setHwAudioKaraokeFeatureKit(Object hwAudioKaraokeFeatureKit) {
        this.mHwAudioKaraokeFeatureKit = hwAudioKaraokeFeatureKit;
    }

    @VisibleForTesting
    InvocationHandler getInvocationHandler() {
        return this.mAudioKitCallbackImpl;
    }

    @Override
    public void initialize() {
        Logging.i(TAG, ">>initialize");
        if (this.mContext == null) {
            Logging.e(TAG, "mContext is null!");
            return;
        }
        if (this.mInitialized) {
            Logging.w(TAG, "already initialized, ignore");
            return;
        }
        try {
            this.mHwAudioKaraokeFeatureKitClass = Class.forName("com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit");
            this.mHwAudioKitClass = Class.forName("com.huawei.multimedia.audiokit.interfaces.HwAudioKit");
            Class<?> iAudioKitCallbackClass = Class.forName("com.huawei.multimedia.audiokit.interfaces.IAudioKitCallback");
            Class<?> featureTypeClass = Class.forName("com.huawei.multimedia.audiokit.interfaces.HwAudioKit$FeatureType");
            this.mParamNameClass = Class.forName("com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit$ParameName");
            Object audioKitCallback = Proxy.newProxyInstance(iAudioKitCallbackClass.getClassLoader(), new Class[]{iAudioKitCallbackClass}, (InvocationHandler)this.mAudioKitCallbackImpl);
            Class[] types = new Class[]{Context.class, iAudioKitCallbackClass};
            Constructor<?> hwAudioKitCon = this.mHwAudioKitClass.getConstructor(types);
            this.mHwAudioKit = hwAudioKitCon.newInstance(this.mContext, audioKitCallback);
            Method initializeMethod = this.mHwAudioKitClass.getDeclaredMethod("initialize", new Class[0]);
            initializeMethod.invoke(this.mHwAudioKit, new Object[0]);
            Method createFeatureMethod = this.mHwAudioKitClass.getDeclaredMethod("createFeature", featureTypeClass);
            this.mHwAudioKaraokeFeatureKit = createFeatureMethod.invoke(this.mHwAudioKit, featureTypeClass.getEnumConstants()[0]);
            Logging.i(TAG, "initialize success ");
        }
        catch (Exception e) {
            Logging.e(TAG, "initialize failed ");
        }
    }

    @Override
    public boolean isHardwareEarMonitorSupported() {
        Logging.i(TAG, ">>isHardwareEarMonitorSupported");
        if (!this.mInitialized) {
            return false;
        }
        try {
            Method isKaraokeFeatureSupportMethod = this.mHwAudioKaraokeFeatureKitClass.getDeclaredMethod("isKaraokeFeatureSupport", new Class[0]);
            boolean isSupported = (Boolean)isKaraokeFeatureSupportMethod.invoke(this.mHwAudioKaraokeFeatureKit, new Object[0]);
            Logging.i(TAG, "isSupported " + isSupported);
            return isSupported;
        }
        catch (Exception e) {
            Logging.e(TAG, "isHardwareEarMonitorSupported false ", e);
            return false;
        }
    }

    @Override
    public int setHardwareEarMonitorVolume(int vol) {
        if (!this.mInitialized || !this.mEarMonitorEnabled) {
            return -7;
        }
        Logging.i(TAG, ">>setHardwareEarMonitorVolume " + vol);
        if (vol < 0) {
            vol = 0;
        } else if (vol > 100) {
            vol = 100;
        }
        try {
            Method setParameterMethod = this.mHwAudioKaraokeFeatureKitClass.getDeclaredMethod("setParameter", this.mParamNameClass, Integer.TYPE);
            int ret = (Integer)setParameterMethod.invoke(this.mHwAudioKaraokeFeatureKit, this.mParamNameClass.getEnumConstants()[1], vol);
            Logging.i(TAG, "setParameter ret " + ret);
            if (ret != 0) {
                return -1;
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "setHardwareEarMonitorVolume failed ", e);
            return -1;
        }
        return 0;
    }

    @Override
    public int enableHardwareEarMonitor(boolean enable) {
        Logging.i(TAG, ">>enableHardwareEarMonitor " + enable);
        if (!this.mInitialized) {
            return -7;
        }
        if (!this.isHardwareEarMonitorSupported()) {
            Logging.e(TAG, "karaoke not supported");
            return -1;
        }
        try {
            Method enableKaraokeFeatureMethod = this.mHwAudioKaraokeFeatureKitClass.getDeclaredMethod("enableKaraokeFeature", Boolean.TYPE);
            int ret = (Integer)enableKaraokeFeatureMethod.invoke(this.mHwAudioKaraokeFeatureKit, enable);
            if (ret != 0) {
                Logging.e(TAG, "enableKaraokeFeature failed ret " + ret);
                return -1;
            }
            this.mEarMonitorEnabled = enable;
            if (this.mEarMonitorEnabled) {
                Method getKaraokeLatencyMethod = this.mHwAudioKaraokeFeatureKitClass.getDeclaredMethod("getKaraokeLatency", new Class[0]);
                int latency = (Integer)getKaraokeLatencyMethod.invoke(this.mHwAudioKaraokeFeatureKit, new Object[0]);
                Logging.i(TAG, "latency: " + latency);
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "enableHardwareEarMonitor failed ", e);
            return -1;
        }
        return 0;
    }

    @Override
    public void destroy() {
        Logging.i(TAG, ">>destroy");
        this.mListener = null;
        if (!this.mInitialized) {
            return;
        }
        this.mInitialized = false;
        try {
            Method hwAudioKaraokeFeatureKitDestroyMethod = this.mHwAudioKaraokeFeatureKitClass.getDeclaredMethod("destroy", new Class[0]);
            hwAudioKaraokeFeatureKitDestroyMethod.invoke(this.mHwAudioKaraokeFeatureKit, new Object[0]);
            Method hwAudioKitDestroyMethod = this.mHwAudioKitClass.getDeclaredMethod("destroy", new Class[0]);
            hwAudioKitDestroyMethod.invoke(this.mHwAudioKit, new Object[0]);
            Logging.i(TAG, ">>destroy success");
        }
        catch (Exception e) {
            Logging.e(TAG, "destroy failed ", e);
        }
    }

    private class AudioKitCallbackImpl
    implements InvocationHandler {
        private AudioKitCallbackImpl() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            try {
                Logging.i(TAG, "invoke, method: " + method.getName());
                if ("onResult".equals(method.getName())) {
                    int result = (Integer)args[0];
                    switch (result) {
                        case 0: {
                            Logging.i(TAG, "IAudioKitCallback: HwAudioKit init success");
                            break;
                        }
                        case 1000: {
                            HuaweiHardwareEarMonitor.this.mInitialized = true;
                            if (HuaweiHardwareEarMonitor.this.mListener != null) {
                                HuaweiHardwareEarMonitor.this.mListener.onInitSuccess();
                            }
                            Logging.i(TAG, "IAudioKitCallback: HwAudioKaraokeFeatureKit init success ");
                            break;
                        }
                        case 2: {
                            Logging.i(TAG, "IAudioKitCallback: audio kit not installed");
                            break;
                        }
                        default: {
                            Logging.e(TAG, "IAudioKitCallback: onResult error number " + result);
                        }
                    }
                }
            }
            catch (Exception e) {
                Logging.e(TAG, "AudioKitCallbackImpl invoke failed ", e);
            }
            return proxy;
        }
    }
}

