/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.media.MediaCodecInfo;
import android.os.Build;
import androidx.annotation.Nullable;
import io.agora.base.internal.Logging;
import io.agora.base.internal.video.BaseBitrateAdjuster;
import io.agora.base.internal.video.BitrateAdjuster;
import io.agora.base.internal.video.DynamicBitrateAdjuster;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.FactorBitrateAdjuster;
import io.agora.base.internal.video.FramerateBitrateAdjuster;
import io.agora.base.internal.video.H264Utils;
import io.agora.base.internal.video.HardwareVideoEncoder;
import io.agora.base.internal.video.MediaCodecUtils;
import io.agora.base.internal.video.MediaCodecWrapperFactoryImpl;
import io.agora.base.internal.video.VideoCodecInfo;
import io.agora.base.internal.video.VideoCodecType;
import io.agora.base.internal.video.VideoEncoder;
import io.agora.base.internal.video.VideoEncoderFactory;
import io.agora.base.internal.video.VideoEncoderUtils;
import java.util.ArrayList;

public class HardwareVideoEncoderFactory
implements VideoEncoderFactory {
    private static final String TAG = "HardwareVideoEncoderFactory";
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000;
    @Nullable
    private final EglBase.Context sharedContext;
    private final boolean enableIntelVp8Encoder;
    private final boolean enableH264HighProfile;

    public HardwareVideoEncoderFactory(EglBase.Context sharedContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile) {
        this.sharedContext = sharedContext;
        this.enableIntelVp8Encoder = enableIntelVp8Encoder;
        this.enableH264HighProfile = enableH264HighProfile;
    }

    @Deprecated
    public HardwareVideoEncoderFactory(boolean enableIntelVp8Encoder, boolean enableH264HighProfile) {
        this(null, enableIntelVp8Encoder, enableH264HighProfile);
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info, boolean useTexture, boolean preferHWEncoder) {
        return this.createEncoder(info, useTexture);
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo input, boolean useTexture) {
        if (!VideoCodecType.contains(input.name)) {
            return null;
        }
        VideoCodecType type = VideoCodecType.valueOf(input.name);
        MediaCodecInfo info = VideoEncoderUtils.findCodecForType(type, useTexture);
        if (info == null) {
            return null;
        }
        String codecName = info.getName();
        String mime = type.mimeType();
        Integer surfaceColorFormat = 0;
        Integer yuvColorFormat = 0;
        try {
            surfaceColorFormat = MediaCodecUtils.selectColorFormat(MediaCodecUtils.TEXTURE_COLOR_FORMATS, info.getCapabilitiesForType(mime));
            yuvColorFormat = MediaCodecUtils.selectColorFormat(MediaCodecUtils.encoderColorFormats(info.getName()), info.getCapabilitiesForType(mime));
        }
        catch (IllegalArgumentException e) {
            Logging.e(TAG, "getCapabilitiesForType:", e);
        }
        boolean isH264HighProfileSupported = false;
        if (type == VideoCodecType.H264) {
            boolean isHighProfile = H264Utils.isSameH264Profile(input.params, MediaCodecUtils.getCodecProperties(type, true));
            boolean isBaselineProfile = H264Utils.isSameH264Profile(input.params, MediaCodecUtils.getCodecProperties(type, false));
            isH264HighProfileSupported = this.isH264HighProfileSupported(info);
            input.params.put("is-highprofile-supported", String.valueOf(isH264HighProfileSupported));
        }
        return new HardwareVideoEncoder(new MediaCodecWrapperFactoryImpl(), codecName, type, surfaceColorFormat, yuvColorFormat, input.params, this.getKeyFrameIntervalSec(type), this.getForcedKeyFrameIntervalMs(type, codecName), this.createBitrateAdjuster(type, codecName), this.sharedContext);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs(boolean useTexture) {
        ArrayList<VideoCodecInfo> supportedCodecInfos = new ArrayList<VideoCodecInfo>();
        for (VideoCodecType type : new VideoCodecType[]{VideoCodecType.VP8, VideoCodecType.VP9, VideoCodecType.H264, VideoCodecType.H265}) {
            MediaCodecInfo codec = VideoEncoderUtils.findCodecForType(type, useTexture);
            if (codec == null) continue;
            String name = type.name();
            if (type == VideoCodecType.H264 && this.isH264HighProfileSupported(codec)) {
                supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, true)));
            }
            supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, false)));
        }
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }

    private int getKeyFrameIntervalSec(VideoCodecType type) {
        switch (type) {
            case VP8: 
            case VP9: {
                return 100;
            }
            case H264: 
            case H265: {
                return 20;
            }
            case UNKNOWN: {
                Logging.e(TAG, "UNKNOWN is not excepted but h264");
                return 20;
            }
        }
        throw new IllegalArgumentException("Unsupported VideoCodecType " + (Object)((Object)type));
    }

    private int getForcedKeyFrameIntervalMs(VideoCodecType type, String codecName) {
        if (type == VideoCodecType.VP8 && codecName.startsWith("OMX.qcom.")) {
            if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
                return 15000;
            }
            if (Build.VERSION.SDK_INT == 23) {
                return 20000;
            }
            if (Build.VERSION.SDK_INT > 23) {
                return 15000;
            }
        }
        return 0;
    }

    private BitrateAdjuster createBitrateAdjuster(VideoCodecType type, String codecName) {
        if (codecName.startsWith("OMX.Exynos.")) {
            if (type == VideoCodecType.VP8) {
                return new DynamicBitrateAdjuster();
            }
            if (type == VideoCodecType.H264 || type == VideoCodecType.H265) {
                return new FactorBitrateAdjuster(950);
            }
            return new FramerateBitrateAdjuster();
        }
        if ((type == VideoCodecType.H264 || type == VideoCodecType.H265) && (codecName.startsWith("OMX.qcom.") || codecName.startsWith("OMX.MTK.") || codecName.startsWith("OMX.hisi."))) {
            return new FactorBitrateAdjuster(950);
        }
        return new BaseBitrateAdjuster();
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo info) {
        boolean big_four = false;
        boolean others = false;
        if (info.getName().startsWith("OMX.qcom.") || info.getName().startsWith("OMX.hisi.") || info.getName().startsWith("OMX.Exynos.") || info.getName().startsWith("OMX.MTK.")) {
            if (Build.VERSION.SDK_INT >= 21) {
                big_four = true;
            }
        } else if (Build.VERSION.SDK_INT >= 23) {
            others = true;
        }
        if (this.enableH264HighProfile && (big_four || others)) {
            MediaCodecInfo.CodecCapabilities h264CodecCapabilities = null;
            try {
                h264CodecCapabilities = info.getCapabilitiesForType(VideoCodecType.H264.mimeType());
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "getCapabilitiesForType:", e);
            }
            if (h264CodecCapabilities == null) {
                return false;
            }
            for (MediaCodecInfo.CodecProfileLevel cpf : h264CodecCapabilities.profileLevels) {
                if (cpf.profile != 8) continue;
                return true;
            }
        }
        return false;
    }
}

