/*
 * Decompiled with CFR 0.152.
 */
package io.agora.util;

import android.content.Context;
import android.os.Environment;
import java.io.File;

public class PathUtil {
    public static String pathPrefix;
    public static final String historyPathName = "/chat/";
    public static final String imagePathName = "/image/";
    public static final String voicePathName = "/voice/";
    public static final String filePathName = "/file/";
    public static final String videoPathName = "/video/";
    public static final String netdiskDownloadPathName = "/netdisk/";
    public static final String meetingPathName = "/meeting/";
    private static File storageDir;
    private static PathUtil instance;
    private File voicePath = null;
    private File imagePath = null;
    private File historyPath = null;
    private File videoPath = null;
    private File filePath;

    private PathUtil() {
    }

    public static PathUtil getInstance() {
        if (instance == null) {
            instance = new PathUtil();
        }
        return instance;
    }

    public void initDirs(String appKey, String userName, Context applicationContext) {
        String string = applicationContext.getPackageName();
        pathPrefix = "/Android/data/" + string + "/";
        this.voicePath = PathUtil.generateVoicePath(appKey, userName, applicationContext);
        if (!this.voicePath.exists()) {
            this.voicePath.mkdirs();
        }
        this.imagePath = PathUtil.generateImagePath(appKey, userName, applicationContext);
        if (!this.imagePath.exists()) {
            this.imagePath.mkdirs();
        }
        this.historyPath = PathUtil.generateHistoryPath(appKey, userName, applicationContext);
        if (!this.historyPath.exists()) {
            this.historyPath.mkdirs();
        }
        this.videoPath = PathUtil.generateVideoPath(appKey, userName, applicationContext);
        if (!this.videoPath.exists()) {
            this.videoPath.mkdirs();
        }
        this.filePath = PathUtil.generateFiePath(appKey, userName, applicationContext);
        if (!this.filePath.exists()) {
            this.filePath.mkdirs();
        }
    }

    public File getImagePath() {
        return this.imagePath;
    }

    public File getVoicePath() {
        return this.voicePath;
    }

    public File getFilePath() {
        return this.filePath;
    }

    public File getVideoPath() {
        return this.videoPath;
    }

    public File getHistoryPath() {
        return this.historyPath;
    }

    private static File getStorageDir(Context applicationContext) {
        if (storageDir == null) {
            File file = Environment.getExternalStorageDirectory();
            if (file.exists()) {
                return file;
            }
            storageDir = applicationContext.getFilesDir();
        }
        return storageDir;
    }

    private static File generateImagePath(String appKey, String userName, Context applicationContext) {
        String string = null;
        string = appKey == null ? pathPrefix + userName + imagePathName : pathPrefix + appKey + "/" + userName + imagePathName;
        return new File(PathUtil.getStorageDir(applicationContext), string);
    }

    private static File generateVoicePath(String appKey, String userName, Context applicationContext) {
        String string = null;
        string = appKey == null ? pathPrefix + userName + voicePathName : pathPrefix + appKey + "/" + userName + voicePathName;
        return new File(PathUtil.getStorageDir(applicationContext), string);
    }

    private static File generateFiePath(String appKey, String userName, Context applicationContext) {
        String string = null;
        string = appKey == null ? pathPrefix + userName + filePathName : pathPrefix + appKey + "/" + userName + filePathName;
        return new File(PathUtil.getStorageDir(applicationContext), string);
    }

    private static File generateVideoPath(String appKey, String userName, Context applicationContext) {
        String string = null;
        string = appKey == null ? pathPrefix + userName + videoPathName : pathPrefix + appKey + "/" + userName + videoPathName;
        return new File(PathUtil.getStorageDir(applicationContext), string);
    }

    private static File generateHistoryPath(String appKey, String userName, Context applicationContext) {
        String string = null;
        string = appKey == null ? pathPrefix + userName + historyPathName : pathPrefix + appKey + "/" + userName + historyPathName;
        return new File(PathUtil.getStorageDir(applicationContext), string);
    }

    public static File getTempPath(File file) {
        return new File(file.getAbsoluteFile() + ".tmp");
    }

    static {
        storageDir = null;
        instance = null;
    }
}

