/*
 * Decompiled with CFR 0.152.
 */
package io.agora.util;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FileUtils {
    public static String[] fileTypes = new String[]{"apk", "avi", "bmp", "chm", "dll", "doc", "docx", "dos", "gif", "html", "jpeg", "jpg", "movie", "mp3", "dat", "mp4", "mpe", "mpeg", "mpg", "pdf", "png", "ppt", "pptx", "rar", "txt", "wav", "wma", "wmv", "xls", "xlsx", "xml", "zip"};
    private static final String TAG = "FileUtils";

    public static File[] loadFiles(File directory) {
        File[] fileArray = directory.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File file : fileArray) {
            if (file.isDirectory()) {
                arrayList.add(file);
                continue;
            }
            if (!file.isFile()) continue;
            arrayList2.add(file);
        }
        MyComparator myComparator = new MyComparator();
        Collections.sort(arrayList, myComparator);
        Collections.sort(arrayList2, myComparator);
        File[] fileArray2 = new File[arrayList.size() + arrayList2.size()];
        System.arraycopy(arrayList.toArray(new File[arrayList.size()]), 0, fileArray2, 0, arrayList.size());
        System.arraycopy(arrayList2.toArray(new File[arrayList2.size()]), 0, fileArray2, arrayList.size(), arrayList2.size());
        return fileArray2;
    }

    public static String getMIMEType(File f) {
        String string = "";
        String string2 = f.getName();
        String string3 = string2.substring(string2.lastIndexOf(".") + 1, string2.length()).toLowerCase();
        string = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string3);
        return string;
    }

    public static String getMIMEType(String fileName) {
        String string = "";
        String string2 = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()).toLowerCase();
        string = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string2);
        return string;
    }

    public static Uri getUriForFile(Context context, File file) {
        if (Build.VERSION.SDK_INT >= 24) {
            return FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".fileProvider"), (File)file);
        }
        return Uri.fromFile((File)file);
    }

    public static class MyComparator
    implements Comparator<File> {
        @Override
        public int compare(File lhs, File rhs) {
            return lhs.getName().compareTo(rhs.getName());
        }
    }
}

