/*
 * Decompiled with CFR 0.152.
 */
package io.agora.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;

public class EMNotificationBuilder {
    private Context appContext;
    private boolean sound;
    private boolean vibrate;
    private String channelId;
    private String channelName;
    private int channelLevel;
    private boolean autoCancel = true;
    private String title;
    private String content;
    private SoftReference<Bitmap> iconBitmapRef;
    private EMNotificationDefaultStyle style = new EMNotificationDefaultStyle();
    private PendingIntent pendingIntent;
    private int smallIcon = 17301651;
    private String ticker;
    private PendingIntent fullScreenIntent;
    private int badgeNum;

    public EMNotificationBuilder(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot is null");
        }
        this.appContext = context.getApplicationContext();
    }

    public EMNotificationBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public EMNotificationBuilder setContent(String content) {
        this.content = content;
        return this;
    }

    public EMNotificationBuilder setIcon(@IdRes int res) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.appContext.getResources(), (int)res);
        if (bitmap != null) {
            this.iconBitmapRef = new SoftReference<Bitmap>(bitmap);
        }
        return this;
    }

    public EMNotificationBuilder setIcon(Bitmap iconBitmap) {
        if (iconBitmap != null) {
            this.iconBitmapRef = new SoftReference<Bitmap>(iconBitmap);
        }
        return this;
    }

    public EMNotificationBuilder setSmallIcon(@IdRes int smallIcon) {
        this.smallIcon = smallIcon;
        return this;
    }

    public EMNotificationBuilder setStyle(EMNotificationDefaultStyle style) {
        this.style = style;
        return this;
    }

    public EMNotificationBuilder setPendingIntent(PendingIntent pendingIntent) {
        this.pendingIntent = pendingIntent;
        return this;
    }

    public EMNotificationBuilder setFullScreenIntent(PendingIntent fullScreenIntent) {
        this.fullScreenIntent = fullScreenIntent;
        return this;
    }

    public EMNotificationBuilder setSound(boolean enable) {
        this.sound = enable;
        return this;
    }

    public EMNotificationBuilder setVibrate(boolean enable) {
        this.vibrate = enable;
        return this;
    }

    public EMNotificationBuilder setLevel(int level) {
        this.channelLevel = level;
        return this;
    }

    public EMNotificationBuilder setTicker(String ticker) {
        this.ticker = ticker;
        return this;
    }

    public EMNotificationBuilder setChannelId(String channelId) {
        if (!TextUtils.isEmpty((CharSequence)channelId)) {
            this.channelId = channelId;
        }
        return this;
    }

    public EMNotificationBuilder setChannelName(String channelName) {
        if (!TextUtils.isEmpty((CharSequence)channelName)) {
            this.channelName = channelName;
        }
        return this;
    }

    public EMNotificationBuilder setAutoCancel(boolean autoCancel) {
        this.autoCancel = autoCancel;
        return this;
    }

    public EMNotificationBuilder setBadgeNum(int badgeNum) {
        this.badgeNum = badgeNum;
        return this;
    }

    public Notification build() {
        Object object;
        if (this.channelId == null) {
            this.channelId = "chat";
        }
        if (this.channelName == null) {
            this.channelName = "\u6d88\u606f";
        }
        this.createNotificationChannel(this.appContext, this.vibrate, this.channelId, this.channelName, this.channelLevel);
        int n = 0;
        if (this.sound) {
            n = 1;
        }
        if (this.vibrate) {
            n = 2;
        }
        if (this.sound && this.vibrate) {
            n = -1;
        }
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.appContext);
        try {
            object = NotificationCompat.Builder.class.getDeclaredMethod("setChannelId", String.class);
            ((Method)object).setAccessible(true);
            ((Method)object).invoke((Object)builder, this.channelId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        builder.setSmallIcon(this.smallIcon);
        if (!this.sound) {
            builder.setSound(null);
        }
        if (n != 0) {
            builder.setDefaults(n);
        }
        if (this.iconBitmapRef != null && this.iconBitmapRef.get() != null) {
            builder.setLargeIcon(this.iconBitmapRef.get());
        }
        if (this.badgeNum > 0) {
            builder.setNumber(this.badgeNum);
        }
        builder.setTicker((CharSequence)this.ticker).setPriority(this.channelLevel - 3).setVisibility(1).setAutoCancel(this.autoCancel).setContentTitle((CharSequence)this.title).setContentText((CharSequence)this.content).setContentIntent(this.pendingIntent).setWhen(System.currentTimeMillis());
        if (this.style instanceof EMNotificationBigTextStyle) {
            object = ((EMNotificationBigTextStyle)this.style).getBigTxt();
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)object));
        } else if (this.style instanceof EMNotificationBigPicStyle) {
            object = ((EMNotificationBigPicStyle)this.style).getBigPic();
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture((Bitmap)object));
        }
        if (this.fullScreenIntent != null) {
            builder.setFullScreenIntent(this.fullScreenIntent, true);
        }
        if (this.vibrate) {
            object = new long[]{100L, 200L, 300L, 400L, 500L};
            builder.setVibrate((long[])object);
        } else {
            builder.setVibrate(null);
        }
        object = builder.build();
        builder.setPublicVersion((Notification)object);
        return object;
    }

    private void createNotificationChannel(Context context, boolean vibrate, String channelId, String channelName, int channelLevel) {
        if (Build.VERSION.SDK_INT >= 26) {
            int n = 3;
            if (channelLevel >= 0 && channelLevel <= 5) {
                n = channelLevel;
            }
            NotificationChannel notificationChannel = new NotificationChannel(channelId, (CharSequence)channelName, n);
            if (!this.sound) {
                notificationChannel.setSound(null, null);
            }
            if (vibrate) {
                notificationChannel.enableVibration(true);
                notificationChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L});
            } else {
                notificationChannel.enableVibration(false);
            }
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.createNotificationChannel(notificationChannel);
        }
    }

    public static class EMNotificationBigPicStyle
    extends EMNotificationDefaultStyle {
        private SoftReference<Bitmap> bitmapRef;

        public Bitmap getBigPic() {
            if (this.bitmapRef != null && this.bitmapRef.get() != null) {
                return this.bitmapRef.get();
            }
            return null;
        }

        public EMNotificationBigPicStyle setBigPic(Bitmap bigPic) {
            if (bigPic != null) {
                this.bitmapRef = new SoftReference<Bitmap>(bigPic);
            }
            return this;
        }
    }

    public static class EMNotificationBigTextStyle
    extends EMNotificationDefaultStyle {
        private String bigTxt;

        public String getBigTxt() {
            return this.bigTxt;
        }

        public EMNotificationBigTextStyle setBigTxt(String bigTxt) {
            this.bigTxt = bigTxt;
            return this;
        }
    }

    public static class EMNotificationDefaultStyle {
    }
}

