/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import android.net.Uri;
import io.agora.chat.MessageBody;
import io.agora.chat.adapter.message.EMAFileMessageBody;
import io.agora.chat.adapter.message.EMAImageMessageBody;
import io.agora.chat.adapter.message.EMAVideoMessageBody;
import io.agora.chat.adapter.message.EMAVoiceMessageBody;
import io.agora.util.FileHelper;
import java.io.File;

public abstract class FileMessageBody
extends MessageBody {
    public FileMessageBody(String localPath) {
        this(FileHelper.getInstance().formatInUri(localPath));
    }

    public FileMessageBody(Uri localPath) {
        this(localPath, 5);
    }

    FileMessageBody(String localPath, int type) {
        this(Uri.fromFile((File)new File(localPath)), type);
    }

    FileMessageBody(Uri localPath, int type) {
        switch (type) {
            case 5: {
                this.emaObject = new EMAFileMessageBody(localPath, type);
                this.setFileLength(FileHelper.getInstance().getFileLength(localPath));
                break;
            }
            case 1: {
                this.emaObject = new EMAImageMessageBody(localPath, null);
                this.setFileLength(FileHelper.getInstance().getFileLength(localPath));
                break;
            }
            case 2: {
                this.emaObject = new EMAVideoMessageBody(localPath, null);
                this.setFileLength(FileHelper.getInstance().getFileLength(localPath));
                break;
            }
            case 4: {
                this.emaObject = new EMAVoiceMessageBody(localPath, 0);
                this.setFileLength(FileHelper.getInstance().getFileLength(localPath));
                break;
            }
        }
    }

    public FileMessageBody(EMAFileMessageBody body) {
        this.emaObject = body;
    }

    public String getFileName() {
        return ((EMAFileMessageBody)this.emaObject).displayName();
    }

    public void setFileName(String fileName) {
        ((EMAFileMessageBody)this.emaObject).setDisplayName(fileName);
    }

    public String getLocalUrl() {
        return FileHelper.getInstance().formatOutLocalUrl(((EMAFileMessageBody)this.emaObject).getLocalUrl());
    }

    public void setLocalUrl(String localUrl) {
        ((EMAFileMessageBody)this.emaObject).setLocalPath(FileHelper.getInstance().formatInUriToString(localUrl));
    }

    public Uri getLocalUri() {
        return FileHelper.getInstance().formatOutUri(((EMAFileMessageBody)this.emaObject).getLocalUrl());
    }

    public void setLocalUrl(Uri localUrl) {
        ((EMAFileMessageBody)this.emaObject).setLocalPath(FileHelper.getInstance().formatInUriToString(localUrl));
    }

    public String getRemoteUrl() {
        return ((EMAFileMessageBody)this.emaObject).getRemoteUrl();
    }

    public void setRemoteUrl(String remoteUrl) {
        ((EMAFileMessageBody)this.emaObject).setRemotePath(remoteUrl);
    }

    public void setSecret(String secret) {
        ((EMAFileMessageBody)this.emaObject).setSecretKey(secret);
    }

    public String getSecret() {
        return ((EMAFileMessageBody)this.emaObject).getSecret();
    }

    public String displayName() {
        return ((EMAFileMessageBody)this.emaObject).displayName();
    }

    public void setFileLength(long length) {
        ((EMAFileMessageBody)this.emaObject).setFileLength(length);
    }

    public EMDownloadStatus downloadStatus() {
        EMAFileMessageBody.EMADownloadStatus eMADownloadStatus = ((EMAFileMessageBody)this.emaObject).downloadStatus();
        switch (eMADownloadStatus) {
            case DOWNLOADING: {
                return EMDownloadStatus.DOWNLOADING;
            }
            case SUCCESSED: {
                return EMDownloadStatus.SUCCESSED;
            }
            case FAILED: {
                return EMDownloadStatus.FAILED;
            }
            case PENDING: {
                return EMDownloadStatus.PENDING;
            }
        }
        return EMDownloadStatus.SUCCESSED;
    }

    public void setDownloadStatus(EMDownloadStatus status) {
        ((EMAFileMessageBody)this.emaObject).setDownloadStatus(EMAFileMessageBody.EMADownloadStatus.valueOf(status.name()));
    }

    public static enum EMDownloadStatus {
        DOWNLOADING,
        SUCCESSED,
        FAILED,
        PENDING;

    }
}

