/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import android.text.TextUtils;
import io.agora.CallBack;
import io.agora.chat.ChatClient;
import io.agora.chat.ChatMessage;
import io.agora.chat.EMBase;
import io.agora.chat.adapter.EMAConversation;
import io.agora.chat.adapter.message.EMAMessage;
import io.agora.util.EMLog;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Conversation
extends EMBase<EMAConversation> {
    private static final String TAG = "conversation";
    private static final int LIST_SIZE = 512;

    Conversation(EMAConversation conversation) {
        this.emaObject = conversation;
    }

    public String conversationId() {
        return ((EMAConversation)this.emaObject).conversationId();
    }

    public ConversationType getType() {
        EMAConversation.EMAConversationType eMAConversationType = ((EMAConversation)this.emaObject)._getType();
        if (eMAConversationType == EMAConversation.EMAConversationType.CHAT) {
            return ConversationType.Chat;
        }
        if (eMAConversationType == EMAConversation.EMAConversationType.GROUPCHAT) {
            return ConversationType.GroupChat;
        }
        if (eMAConversationType == EMAConversation.EMAConversationType.CHATROOM) {
            return ConversationType.ChatRoom;
        }
        if (eMAConversationType == EMAConversation.EMAConversationType.DISCUSSIONGROUP) {
            return ConversationType.DiscussionGroup;
        }
        if (eMAConversationType == EMAConversation.EMAConversationType.HELPDESK) {
            return ConversationType.HelpDesk;
        }
        return ConversationType.Chat;
    }

    public int getUnreadMsgCount() {
        return ((EMAConversation)this.emaObject).unreadMessagesCount();
    }

    public void markAllMessagesAsRead() {
        ((EMAConversation)this.emaObject).markAllMessagesAsRead(true);
    }

    public int getAllMsgCount() {
        return ((EMAConversation)this.emaObject).messagesCount();
    }

    public boolean isChatThread() {
        return ((EMAConversation)this.emaObject).isChatThread();
    }

    public List<ChatMessage> loadMoreMsgFromDB(String startMsgId, int pageSize) {
        return this.loadMoreMsgFromDB(startMsgId, pageSize, SearchDirection.UP);
    }

    public List<ChatMessage> loadMoreMsgFromDB(String startMsgId, int pageSize, SearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == SearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).loadMoreMessages(startMsgId, pageSize, eMASearchDirection);
        ArrayList<ChatMessage> arrayList = new ArrayList<ChatMessage>();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            arrayList.add(new ChatMessage(eMAMessage));
        }
        this.getCache().addMessages(arrayList);
        return arrayList;
    }

    public List<ChatMessage> searchMsgFromDB(long timeStamp, int maxCount, SearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == SearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(timeStamp, maxCount, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((ChatMessage)new ChatMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<ChatMessage> searchMsgFromDB(ChatMessage.Type type, long timeStamp, int maxCount, String from, SearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == SearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(type.ordinal(), timeStamp, maxCount, from, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((ChatMessage)new ChatMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<ChatMessage> searchMsgFromDB(String keywords, long timeStamp, int maxCount, String from, SearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == SearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(keywords, timeStamp, maxCount, from, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((ChatMessage)new ChatMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<ChatMessage> searchMsgFromDB(long startTimeStamp, long endTimeStamp, int maxCount) {
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(startTimeStamp, endTimeStamp, maxCount);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((ChatMessage)new ChatMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<ChatMessage> searchCustomMsgFromDB(String keywords, long timeStamp, int maxCount, String from, SearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == SearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchCustomMessages(keywords, timeStamp, maxCount, from, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((ChatMessage)new ChatMessage(eMAMessage));
        }
        return abstractList;
    }

    public ChatMessage getMessage(String messageId, boolean markAsRead) {
        EMLog.d(TAG, "getMessage messageId: " + messageId + " markAsRead: " + markAsRead);
        ChatMessage chatMessage = this.getCache().getMessage(messageId);
        if (chatMessage == null) {
            EMAMessage eMAMessage = ((EMAConversation)this.emaObject).loadMessage(messageId);
            if (eMAMessage == null) {
                return null;
            }
            chatMessage = new ChatMessage(eMAMessage);
        }
        ((EMAConversation)this.emaObject).markMessageAsRead(messageId, markAsRead);
        return chatMessage;
    }

    public void markMessageAsRead(String messageId) {
        ((EMAConversation)this.emaObject).markMessageAsRead(messageId, true);
    }

    public List<ChatMessage> getAllMessages() {
        if (this.getCache().isEmpty()) {
            EMAMessage eMAMessage = ((EMAConversation)this.emaObject).latestMessage();
            ArrayList<ChatMessage> arrayList = new ArrayList<ChatMessage>();
            if (eMAMessage != null) {
                arrayList.add(new ChatMessage(eMAMessage));
            }
            this.getCache().addMessages(arrayList);
        }
        return this.getCache().getAllMessages();
    }

    public void removeMessage(String messageId) {
        EMLog.d(TAG, "remove msg from conversation: " + messageId);
        ((EMAConversation)this.emaObject)._removeMessage(messageId);
        this.getCache().removeMessage(messageId);
    }

    public ChatMessage getLastMessage() {
        if (this.getCache().isEmpty()) {
            EMAMessage eMAMessage = ((EMAConversation)this.emaObject).latestMessage();
            ChatMessage chatMessage = eMAMessage == null ? null : new ChatMessage(eMAMessage);
            this.getCache().addMessage(chatMessage);
            return chatMessage;
        }
        return this.getCache().getLastMessage();
    }

    public ChatMessage getLatestMessageFromOthers() {
        EMAMessage eMAMessage = ((EMAConversation)this.emaObject).latestMessageFromOthers();
        ChatMessage chatMessage = eMAMessage == null ? null : new ChatMessage(eMAMessage);
        this.getCache().addMessage(chatMessage);
        return chatMessage;
    }

    public void clear() {
        this.getCache().clear();
    }

    public void clearAllMessages() {
        ((EMAConversation)this.emaObject).clearAllMessages();
        this.getCache().clear();
    }

    public void setExtField(String ext) {
        if (!this.isChatThread()) {
            ((EMAConversation)this.emaObject)._setExtField(ext);
        }
    }

    public String getExtField() {
        return ((EMAConversation)this.emaObject).extField();
    }

    public boolean isPinned() {
        return ((EMAConversation)this.emaObject).isPinned();
    }

    public long getPinnedTime() {
        return ((EMAConversation)this.emaObject).getPinnedTime();
    }

    public static ConversationType msgType2ConversationType(String id, ChatMessage.ChatType type) {
        switch (type) {
            case GroupChat: {
                return ConversationType.GroupChat;
            }
            case ChatRoom: {
                return ConversationType.ChatRoom;
            }
        }
        return ConversationType.Chat;
    }

    public boolean isGroup() {
        ConversationType conversationType = this.getType();
        return !this.isChatThread() && (conversationType == ConversationType.GroupChat || conversationType == ConversationType.ChatRoom);
    }

    public boolean insertMessage(ChatMessage msg) {
        EMLog.d(TAG, "insertMessage msg: {msgId:" + msg.getMsgId() + " conversation:" + msg.conversationId() + " unread:" + msg.isUnread() + "}");
        boolean bl = ((EMAConversation)this.emaObject).insertMessage((EMAMessage)msg.emaObject);
        if (bl) {
            this.getCache().addMessage(msg);
        }
        return bl;
    }

    public boolean appendMessage(ChatMessage msg) {
        EMLog.d(TAG, "appendMessage msg: {msgId:" + msg.getMsgId() + " conversation:" + msg.conversationId() + " unread:" + msg.isUnread() + "}");
        boolean bl = ((EMAConversation)this.emaObject).appendMessage((EMAMessage)msg.emaObject);
        if (bl) {
            this.getCache().addMessage(msg);
        }
        return bl;
    }

    public boolean updateMessage(ChatMessage msg) {
        EMLog.d(TAG, "updateMessage msg{ msgId:" + msg.getMsgId() + " conversation:" + msg.conversationId() + " unread:" + msg.isUnread() + "}");
        boolean bl = ((EMAConversation)this.emaObject).updateMessage((EMAMessage)msg.emaObject);
        if (bl) {
            this.getCache().addMessage(msg);
        }
        return bl;
    }

    public String getMessageAttachmentPath() {
        String string = ChatClient.getInstance().getChatConfigPrivate().E();
        return string + "/" + ChatClient.getInstance().getCurrentUser() + "/" + this.conversationId();
    }

    public void removeMessagesFromServer(List<String> msgIdList, CallBack callBack) {
        ChatClient.getInstance().chatManager().removeMessagesFromServer(this.conversationId(), this.getType(), msgIdList, callBack);
    }

    public void removeMessagesFromServer(long beforeTimeStamp, CallBack callBack) {
        ChatClient.getInstance().chatManager().removeMessagesFromServer(this.conversationId(), this.getType(), beforeTimeStamp, callBack);
    }

    public boolean removeMessages(long startTime, long endTime) {
        EMLog.d(TAG, "remove msgs from conversation by startTime: " + startTime + " ,endTime: " + endTime);
        boolean bl = ((EMAConversation)this.emaObject)._removeMessage(startTime, endTime);
        if (bl) {
            this.getCache().removeMessages(startTime, endTime);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageCache getCache() {
        MessageCache messageCache;
        Map<String, MessageCache> map = ChatClient.getInstance().chatManager().caches;
        synchronized (map) {
            messageCache = ChatClient.getInstance().chatManager().caches.get(((EMAConversation)this.emaObject).conversationId());
            if (messageCache == null) {
                messageCache = new MessageCache();
            }
            ChatClient.getInstance().chatManager().caches.put(((EMAConversation)this.emaObject).conversationId(), messageCache);
        }
        return messageCache;
    }

    static class MessageCache {
        TreeMap<Long, Object> sortedMessages = new TreeMap(new MessageComparator());
        Map<String, ChatMessage> messages = new HashMap<String, ChatMessage>();
        Map<String, Long> idTimeMap = new HashMap<String, Long>();
        boolean hasDuplicateTime = false;
        final boolean sortByServerTime = ChatClient.getInstance().getChatConfigPrivate().b().isSortMessageByServerTime();

        MessageCache() {
        }

        public synchronized ChatMessage getMessage(String msgId) {
            if (msgId == null || msgId.isEmpty()) {
                return null;
            }
            return this.messages.get(msgId);
        }

        public synchronized void addMessages(List<ChatMessage> msgs) {
            for (ChatMessage chatMessage : msgs) {
                this.addMessage(chatMessage);
            }
        }

        public synchronized void addMessage(ChatMessage msg) {
            long l;
            if (msg == null || msg.emaObject == null || msg.getMsgTime() == 0L || msg.getMsgTime() == -1L || msg.getMsgId() == null || msg.getMsgId().isEmpty() || msg.getType() == ChatMessage.Type.CMD) {
                return;
            }
            String string = msg.getMsgId();
            if (this.messages.containsKey(string)) {
                Long l2 = this.idTimeMap.get(string);
                if (l2 != null) {
                    this.removeMessageByTime(string, l2);
                }
                this.messages.remove(string);
                this.idTimeMap.remove(string);
            }
            long l3 = l = this.sortByServerTime ? msg.getMsgTime() : msg.localTime();
            if (this.sortedMessages.containsKey(l)) {
                this.hasDuplicateTime = true;
                Object object = this.sortedMessages.get(l);
                if (object != null) {
                    if (object instanceof ChatMessage) {
                        if (TextUtils.equals((CharSequence)((ChatMessage)object).getMsgId(), (CharSequence)msg.getMsgId())) {
                            return;
                        }
                        LinkedList<ChatMessage> linkedList = new LinkedList<ChatMessage>();
                        linkedList.add((ChatMessage)object);
                        linkedList.add(msg);
                        this.sortedMessages.put(l, linkedList);
                    } else if (object instanceof List) {
                        List list = (List)object;
                        list.add(msg);
                    }
                }
            } else {
                this.sortedMessages.put(l, msg);
            }
            this.messages.put(string, msg);
            this.idTimeMap.put(string, l);
        }

        public synchronized void removeMessage(String msgId) {
            if (msgId == null || msgId.isEmpty()) {
                return;
            }
            ChatMessage chatMessage = this.messages.get(msgId);
            if (chatMessage != null) {
                Long l = this.idTimeMap.get(msgId);
                if (l != null) {
                    this.removeMessageByTime(msgId, l);
                    this.idTimeMap.remove(msgId);
                }
                this.messages.remove(msgId);
            }
        }

        public synchronized void removeMessages(long startTime, long endTime) {
            if (startTime > endTime) {
                EMLog.e(Conversation.TAG, " removeMessages error: startTime > endTime");
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Long l : this.sortedMessages.keySet()) {
                if (l < startTime || l > endTime) continue;
                Object object = this.sortedMessages.get(l);
                if (object != null && object instanceof List) {
                    List list = (List)object;
                    for (ChatMessage chatMessage : list) {
                        if (chatMessage == null || chatMessage.getMsgId() == null) continue;
                        arrayList.add(chatMessage.getMsgId());
                    }
                    continue;
                }
                if (object == null || !(object instanceof ChatMessage)) continue;
                arrayList.add(((ChatMessage)object).getMsgId());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                this.removeMessage((String)arrayList.get(i));
            }
        }

        synchronized void replaceMsgId(String oldMsgId, String newMsgId) {
            if (TextUtils.isEmpty((CharSequence)oldMsgId) || TextUtils.isEmpty((CharSequence)newMsgId)) {
                return;
            }
            ChatMessage chatMessage = this.messages.get(oldMsgId);
            if (chatMessage != null) {
                Long l = this.idTimeMap.get(oldMsgId);
                if (l != null) {
                    Object object = this.sortedMessages.get(l);
                    this.sortedMessages.remove(l);
                    this.idTimeMap.remove(oldMsgId);
                    long l2 = this.sortByServerTime ? chatMessage.getMsgTime() : chatMessage.localTime();
                    this.sortedMessages.put(l2, object);
                    this.idTimeMap.put(newMsgId, l2);
                }
                this.messages.remove(oldMsgId);
                this.messages.put(newMsgId, chatMessage);
            }
        }

        private synchronized void removeMessageByTime(String msgId, long time) {
            if (msgId == null || msgId.isEmpty()) {
                return;
            }
            if (this.hasDuplicateTime && this.sortedMessages.containsKey(time)) {
                Object object = this.sortedMessages.get(time);
                if (object != null && object instanceof List) {
                    List list = (List)object;
                    for (ChatMessage chatMessage : list) {
                        if (chatMessage == null || chatMessage.getMsgId() == null || !chatMessage.getMsgId().equals(msgId)) continue;
                        list.remove(chatMessage);
                        break;
                    }
                } else {
                    this.sortedMessages.remove(time);
                }
            } else {
                this.sortedMessages.remove(time);
            }
        }

        public synchronized List<ChatMessage> getAllMessages() {
            ArrayList<ChatMessage> arrayList = new ArrayList<ChatMessage>();
            if (!this.hasDuplicateTime) {
                for (Object object : this.sortedMessages.values()) {
                    arrayList.add((ChatMessage)object);
                }
            } else {
                for (Object object : this.sortedMessages.values()) {
                    if (object == null) continue;
                    if (object instanceof List) {
                        arrayList.addAll((List)object);
                        continue;
                    }
                    arrayList.add((ChatMessage)object);
                }
            }
            return arrayList;
        }

        public synchronized ChatMessage getLastMessage() {
            if (this.sortedMessages.isEmpty()) {
                return null;
            }
            Object object = this.sortedMessages.lastEntry().getValue();
            if (object == null) {
                return null;
            }
            if (object instanceof ChatMessage) {
                return (ChatMessage)object;
            }
            if (object instanceof List) {
                List list = (List)object;
                if (list.size() > 0) {
                    return (ChatMessage)list.get(list.size() - 1);
                }
                return null;
            }
            return null;
        }

        public synchronized void clear() {
            this.sortedMessages.clear();
            this.messages.clear();
            this.idTimeMap.clear();
        }

        public synchronized boolean isEmpty() {
            return this.sortedMessages.isEmpty();
        }

        class MessageComparator
        implements Comparator<Long> {
            MessageComparator() {
            }

            @Override
            public int compare(Long time0, Long time1) {
                long l = time0 - time1;
                if (l > 0L) {
                    return 1;
                }
                if (l == 0L) {
                    return 0;
                }
                return -1;
            }
        }
    }

    public static enum SearchDirection {
        UP,
        DOWN;

    }

    public static enum ConversationType {
        Chat,
        GroupChat,
        ChatRoom,
        DiscussionGroup,
        HelpDesk;

    }
}

