/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import io.agora.CallBack;
import io.agora.chat.ChatClient;
import io.agora.chat.ChatThread;
import io.agora.chat.CmdMessageBody;
import io.agora.chat.CombineMessageBody;
import io.agora.chat.CustomMessageBody;
import io.agora.chat.EMBase;
import io.agora.chat.EMSessionManager;
import io.agora.chat.ImageMessageBody;
import io.agora.chat.LocationMessageBody;
import io.agora.chat.MessageBody;
import io.agora.chat.MessageReaction;
import io.agora.chat.NormalFileMessageBody;
import io.agora.chat.TextMessageBody;
import io.agora.chat.VideoMessageBody;
import io.agora.chat.VoiceMessageBody;
import io.agora.chat.adapter.EMACallback;
import io.agora.chat.adapter.EMAMessageReaction;
import io.agora.chat.adapter.EMAThreadInfo;
import io.agora.chat.adapter.message.EMACmdMessageBody;
import io.agora.chat.adapter.message.EMACombineMessageBody;
import io.agora.chat.adapter.message.EMACustomMessageBody;
import io.agora.chat.adapter.message.EMAFileMessageBody;
import io.agora.chat.adapter.message.EMAImageMessageBody;
import io.agora.chat.adapter.message.EMALocationMessageBody;
import io.agora.chat.adapter.message.EMAMessage;
import io.agora.chat.adapter.message.EMAMessageBody;
import io.agora.chat.adapter.message.EMATextMessageBody;
import io.agora.chat.adapter.message.EMAVideoMessageBody;
import io.agora.chat.adapter.message.EMAVoiceMessageBody;
import io.agora.exceptions.ChatException;
import io.agora.util.EMLog;
import io.agora.util.FileHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatMessage
extends EMBase<EMAMessage>
implements Parcelable,
Cloneable {
    static final String ATTR_ENCRYPTED = "isencrypted";
    private static final String TAG = "msg";
    MessageBody body;
    EMCallbackHolder messageStatusCallBack;
    public static final Parcelable.Creator<ChatMessage> CREATOR = new Parcelable.Creator<ChatMessage>(){

        public ChatMessage createFromParcel(Parcel in) {
            ChatMessage chatMessage = null;
            try {
                chatMessage = new ChatMessage(in);
            }
            catch (ChatException chatException) {
                chatException.printStackTrace();
            }
            return chatMessage;
        }

        public ChatMessage[] newArray(int size) {
            return new ChatMessage[size];
        }
    };

    public Status status() {
        EMAMessage.EMAMessageStatus eMAMessageStatus = ((EMAMessage)this.emaObject)._status();
        Status status = Status.CREATE;
        switch (eMAMessageStatus) {
            case NEW: {
                status = Status.CREATE;
                break;
            }
            case SUCCESS: {
                status = Status.SUCCESS;
                break;
            }
            case FAIL: {
                status = Status.FAIL;
                break;
            }
            case DELIVERING: {
                status = Status.INPROGRESS;
            }
        }
        return status;
    }

    public ChatMessage(EMAMessage message) {
        this.emaObject = message;
    }

    public void setStatus(Status status) {
        EMAMessage.EMAMessageStatus eMAMessageStatus = EMAMessage.EMAMessageStatus.SUCCESS;
        switch (status) {
            case CREATE: {
                eMAMessageStatus = EMAMessage.EMAMessageStatus.NEW;
                break;
            }
            case SUCCESS: {
                eMAMessageStatus = EMAMessage.EMAMessageStatus.SUCCESS;
                break;
            }
            case FAIL: {
                eMAMessageStatus = EMAMessage.EMAMessageStatus.FAIL;
                break;
            }
            case INPROGRESS: {
                eMAMessageStatus = EMAMessage.EMAMessageStatus.DELIVERING;
            }
        }
        ((EMAMessage)this.emaObject).setStatus(eMAMessageStatus.ordinal());
    }

    public Type getType() {
        List<EMAMessageBody> list = ((EMAMessage)this.emaObject).bodies();
        if (list.size() > 0) {
            int n = list.get(0).type();
            if (n == Type.TXT.ordinal()) {
                return Type.TXT;
            }
            if (n == Type.IMAGE.ordinal()) {
                return Type.IMAGE;
            }
            if (n == Type.CMD.ordinal()) {
                return Type.CMD;
            }
            if (n == Type.FILE.ordinal()) {
                return Type.FILE;
            }
            if (n == Type.VIDEO.ordinal()) {
                return Type.VIDEO;
            }
            if (n == Type.VOICE.ordinal()) {
                return Type.VOICE;
            }
            if (n == Type.LOCATION.ordinal()) {
                return Type.LOCATION;
            }
            if (n == Type.CUSTOM.ordinal()) {
                return Type.CUSTOM;
            }
            if (n == Type.COMBINE.ordinal()) {
                return Type.COMBINE;
            }
        }
        return Type.TXT;
    }

    public MessageBody getBody() {
        if (this.body != null) {
            return this.body;
        }
        List<EMAMessageBody> list = ((EMAMessage)this.emaObject).bodies();
        if (list.size() > 0) {
            EMAMessageBody eMAMessageBody = list.get(0);
            if (eMAMessageBody instanceof EMATextMessageBody) {
                this.body = new TextMessageBody((EMATextMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMACmdMessageBody) {
                this.body = new CmdMessageBody((EMACmdMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMAVideoMessageBody) {
                this.body = new VideoMessageBody((EMAVideoMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMAVoiceMessageBody) {
                this.body = new VoiceMessageBody((EMAVoiceMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMAImageMessageBody) {
                this.body = new ImageMessageBody((EMAImageMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMACombineMessageBody) {
                this.body = new CombineMessageBody((EMACombineMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMALocationMessageBody) {
                this.body = new LocationMessageBody((EMALocationMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMAFileMessageBody) {
                this.body = new NormalFileMessageBody((EMAFileMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMACustomMessageBody) {
                this.body = new CustomMessageBody((EMACustomMessageBody)eMAMessageBody);
            }
            return this.body;
        }
        return null;
    }

    public long getMsgTime() {
        return ((EMAMessage)this.emaObject).timeStamp();
    }

    public void setMsgTime(long msgTime) {
        ((EMAMessage)this.emaObject).setTimeStamp(msgTime);
    }

    public long localTime() {
        return ((EMAMessage)this.emaObject).getLocalTime();
    }

    public void setLocalTime(long serverTime) {
        ((EMAMessage)this.emaObject).setLocalTime(serverTime);
    }

    public boolean isNeedGroupAck() {
        return ((EMAMessage)this.emaObject).isNeedGroupAck();
    }

    public void setIsNeedGroupAck(boolean need) {
        ((EMAMessage)this.emaObject).setIsNeedGroupAck(need);
    }

    public int groupAckCount() {
        return ((EMAMessage)this.emaObject).groupAckCount();
    }

    public void setGroupAckCount(int count) {
        ((EMAMessage)this.emaObject).setGroupAckCount(count);
    }

    public void setIsChatThreadMessage(boolean isChatThreadMessage) {
        ((EMAMessage)this.emaObject).setIsChatThreadMessage(isChatThreadMessage);
    }

    public boolean isChatThreadMessage() {
        return ((EMAMessage)this.emaObject).isChatThreadMessage();
    }

    public ChatThread getChatThread() {
        EMAThreadInfo eMAThreadInfo = ((EMAMessage)this.emaObject).getChatThread();
        if (eMAThreadInfo == null) {
            return null;
        }
        return new ChatThread(eMAThreadInfo);
    }

    public static ChatMessage createSendMessage(Type type) {
        EMAMessage eMAMessage = EMAMessage.createSendMessage(ChatMessage.self(), "", null, ChatType.Chat.ordinal());
        ChatMessage chatMessage = new ChatMessage(eMAMessage);
        return chatMessage;
    }

    public static ChatMessage createReceiveMessage(Type type) {
        EMAMessage eMAMessage = EMAMessage.createReceiveMessage("", ChatMessage.self(), null, ChatType.Chat.ordinal());
        ChatMessage chatMessage = new ChatMessage(eMAMessage);
        chatMessage.setTo(EMSessionManager.getInstance().currentUser.getUsername());
        return chatMessage;
    }

    @Deprecated
    public static ChatMessage createTxtSendMessage(String content, String username) {
        if (content.length() > 0) {
            ChatMessage chatMessage = ChatMessage.createSendMessage(Type.TXT);
            TextMessageBody textMessageBody = new TextMessageBody(content);
            chatMessage.addBody(textMessageBody);
            chatMessage.setTo(username);
            return chatMessage;
        }
        EMLog.e(TAG, "text content size must be greater than 0");
        return null;
    }

    public static ChatMessage createTextSendMessage(String content, String username) {
        if (content.length() > 0) {
            ChatMessage chatMessage = ChatMessage.createSendMessage(Type.TXT);
            TextMessageBody textMessageBody = new TextMessageBody(content);
            chatMessage.addBody(textMessageBody);
            chatMessage.setTo(username);
            return chatMessage;
        }
        EMLog.e(TAG, "text content size must be greater than 0");
        return null;
    }

    public static ChatMessage createVoiceSendMessage(String filePath, int timeLength, String username) {
        return ChatMessage.createVoiceSendMessage(FileHelper.getInstance().formatInUri(filePath), timeLength, username);
    }

    public static ChatMessage createVoiceSendMessage(Uri filePath, int timeLength, String username) {
        if (!FileHelper.getInstance().isFileExist(filePath)) {
            EMLog.e(TAG, "voice file does not exsit");
            return null;
        }
        ChatMessage chatMessage = ChatMessage.createSendMessage(Type.VOICE);
        VoiceMessageBody voiceMessageBody = new VoiceMessageBody(filePath, timeLength);
        chatMessage.addBody(voiceMessageBody);
        chatMessage.setTo(username);
        return chatMessage;
    }

    public static ChatMessage createImageSendMessage(String filePath, boolean sendOriginalImage, String username) {
        return ChatMessage.createImageSendMessage(FileHelper.getInstance().formatInUri(filePath), sendOriginalImage, username);
    }

    public static ChatMessage createImageSendMessage(Uri imgUri, boolean sendOriginalImage, String username) {
        if (!FileHelper.getInstance().isFileExist(imgUri)) {
            EMLog.e(TAG, "image file does not exsit");
            return null;
        }
        ChatMessage chatMessage = ChatMessage.createSendMessage(Type.IMAGE);
        chatMessage.setTo(username);
        ImageMessageBody imageMessageBody = new ImageMessageBody(imgUri);
        imageMessageBody.setSendOriginalImage(sendOriginalImage);
        chatMessage.addBody(imageMessageBody);
        return chatMessage;
    }

    public static ChatMessage createVideoSendMessage(String videofilePath, String imageThumbPath, int timeLength, String username) {
        return ChatMessage.createVideoSendMessage(FileHelper.getInstance().formatInUri(videofilePath), FileHelper.getInstance().formatInUri(imageThumbPath), timeLength, username);
    }

    public static ChatMessage createVideoSendMessage(Uri videofilePath, String imageThumbPath, int timeLength, String username) {
        return ChatMessage.createVideoSendMessage(videofilePath, FileHelper.getInstance().formatInUri(imageThumbPath), timeLength, username);
    }

    public static ChatMessage createVideoSendMessage(Uri videofilePath, Uri imageThumbPath, int timeLength, String username) {
        if (!FileHelper.getInstance().isFileExist(videofilePath)) {
            EMLog.e(TAG, "video file does not exist");
            return null;
        }
        ChatMessage chatMessage = ChatMessage.createSendMessage(Type.VIDEO);
        chatMessage.setTo(username);
        VideoMessageBody videoMessageBody = new VideoMessageBody(videofilePath, imageThumbPath, timeLength, FileHelper.getInstance().getFileLength(videofilePath));
        chatMessage.addBody(videoMessageBody);
        return chatMessage;
    }

    public static ChatMessage createLocationSendMessage(double latitude, double longitude, String locationAddress, String buildingName, String username) {
        ChatMessage chatMessage = ChatMessage.createSendMessage(Type.LOCATION);
        LocationMessageBody locationMessageBody = new LocationMessageBody(locationAddress, latitude, longitude, buildingName);
        chatMessage.addBody(locationMessageBody);
        chatMessage.setTo(username);
        return chatMessage;
    }

    public static ChatMessage createLocationSendMessage(double latitude, double longitude, String locationAddress, String username) {
        ChatMessage chatMessage = ChatMessage.createSendMessage(Type.LOCATION);
        LocationMessageBody locationMessageBody = new LocationMessageBody(locationAddress, latitude, longitude);
        chatMessage.addBody(locationMessageBody);
        chatMessage.setTo(username);
        return chatMessage;
    }

    public static ChatMessage createFileSendMessage(String filePath, String username) {
        return ChatMessage.createFileSendMessage(FileHelper.getInstance().formatInUri(filePath), username);
    }

    public static ChatMessage createFileSendMessage(Uri filePath, String username) {
        if (!FileHelper.getInstance().isFileExist(filePath)) {
            EMLog.e(TAG, "file does not exist");
            return null;
        }
        ChatMessage chatMessage = ChatMessage.createSendMessage(Type.FILE);
        chatMessage.setTo(username);
        NormalFileMessageBody normalFileMessageBody = new NormalFileMessageBody(filePath);
        chatMessage.addBody(normalFileMessageBody);
        return chatMessage;
    }

    public static ChatMessage createCombinedSendMessage(String title, String summary, String compatibleText, List<String> messageIdList, String userId) {
        ChatMessage chatMessage = ChatMessage.createSendMessage(Type.COMBINE);
        chatMessage.setTo(userId);
        CombineMessageBody combineMessageBody = new CombineMessageBody(title, summary, compatibleText, messageIdList);
        chatMessage.addBody(combineMessageBody);
        return chatMessage;
    }

    public void setBody(MessageBody body) {
        if (this.body != body) {
            this.body = body;
            ((EMAMessage)this.emaObject).clearBodies();
            ((EMAMessage)this.emaObject).addBody((EMAMessageBody)body.emaObject);
        }
    }

    public void addBody(MessageBody body) {
        this.body = body;
        ((EMAMessage)this.emaObject).addBody((EMAMessageBody)body.emaObject);
    }

    public String getFrom() {
        return ((EMAMessage)this.emaObject).from();
    }

    public void setFrom(String from) {
        ((EMAMessage)this.emaObject).setFrom(from);
        if (!ChatMessage.self().equals(from) && this.getTo() != null && this.getTo() != "" && this.getTo().equals(ChatMessage.self())) {
            ((EMAMessage)this.emaObject).setConversationId(from);
        }
    }

    public String getRecaller() {
        return ((EMAMessage)this.emaObject).getRecaller();
    }

    public void setTo(String to) {
        ((EMAMessage)this.emaObject).setTo(to);
        ((EMAMessage)this.emaObject).setConversationId(to);
    }

    public String getTo() {
        return ((EMAMessage)this.emaObject).to();
    }

    public String getMsgId() {
        return ((EMAMessage)this.emaObject).msgId();
    }

    public void setMsgId(String msgId) {
        ((EMAMessage)this.emaObject).setMsgId(msgId);
    }

    synchronized void setInnerCallback(CallBack callback) {
        EMCallbackHolder eMCallbackHolder = this.messageStatusCallBack;
        if (eMCallbackHolder != null) {
            eMCallbackHolder.innerCallback = callback;
        } else {
            this.messageStatusCallBack = new EMCallbackHolder(null);
            this.messageStatusCallBack.innerCallback = callback;
        }
        this.setCallback(this.messageStatusCallBack);
    }

    public synchronized void setMessageStatusCallback(CallBack callback) {
        EMCallbackHolder eMCallbackHolder = this.messageStatusCallBack;
        if (eMCallbackHolder != null) {
            eMCallbackHolder.update(callback);
        } else {
            this.messageStatusCallBack = new EMCallbackHolder(callback);
        }
        this.setCallback(this.messageStatusCallBack);
    }

    void setCallback(final EMCallbackHolder holder) {
        ((EMAMessage)this.emaObject).setCallback(new EMACallback(new CallBack(){

            @Override
            public void onSuccess() {
                if (holder != null) {
                    holder.onSuccess();
                }
            }

            @Override
            public void onProgress(int progress, String status) {
                if (holder != null) {
                    holder.onProgress(progress, status);
                }
            }

            @Override
            public void onError(int code, String error) {
                if (holder != null) {
                    holder.onError(code, error);
                }
            }
        }));
    }

    void makeCallbackStrong() {
        EMCallbackHolder eMCallbackHolder = this.messageStatusCallBack;
        if (eMCallbackHolder != null) {
            eMCallbackHolder.makeItStrong();
        }
    }

    public String toString() {
        String string = "msg{from:" + this.getFrom() + ", to:" + this.getTo() + " body:" + this.getBody();
        return string;
    }

    public void setAttribute(String attribute, boolean value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setAttribute(attribute, value);
    }

    public void setAttribute(String attribute, int value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setAttribute(attribute, value);
    }

    public void setAttribute(String attribute, long value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setAttribute(attribute, value);
    }

    public void setAttribute(String attribute, float value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setAttribute(attribute, value);
    }

    public void setAttribute(String attribute, double value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setAttribute(attribute, value);
    }

    public void setAttribute(String attribute, JSONObject value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setJsonAttribute(attribute, value.toString());
    }

    public void setAttribute(String attribute, JSONArray value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setJsonAttribute(attribute, value.toString());
    }

    public void setAttribute(String attribute, String value) {
        if (attribute == null || attribute.equals("")) {
            return;
        }
        ((EMAMessage)this.emaObject).setAttribute(attribute, value);
    }

    public boolean getBooleanAttribute(String attribute) throws ChatException {
        if (attribute == null || attribute.equals("")) {
            throw new ChatException(1, "attribute " + attribute + " can not be null or empty");
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        boolean bl = ((EMAMessage)this.emaObject).getBooleanAttribute(attribute, false, atomicBoolean);
        if (!bl) {
            throw new ChatException(1, "attribute " + attribute + " not found");
        }
        return atomicBoolean.get();
    }

    public boolean getBooleanAttribute(String attribute, boolean defaultValue) {
        if (attribute == null || attribute.equals("")) {
            return defaultValue;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        boolean bl = ((EMAMessage)this.emaObject).getBooleanAttribute(attribute, false, atomicBoolean);
        if (!bl) {
            return defaultValue;
        }
        return atomicBoolean.get();
    }

    public int getIntAttribute(String attribute, int defaultValue) {
        if (attribute == null || attribute.equals("")) {
            return defaultValue;
        }
        AtomicInteger atomicInteger = new AtomicInteger();
        boolean bl = ((EMAMessage)this.emaObject).getIntAttribute(attribute, -1, atomicInteger);
        if (!bl) {
            return defaultValue;
        }
        return atomicInteger.intValue();
    }

    public long getLongAttribute(String attribute, long defaultValue) {
        if (attribute == null || attribute.equals("")) {
            return defaultValue;
        }
        AtomicLong atomicLong = new AtomicLong();
        boolean bl = ((EMAMessage)this.emaObject).getLongAttribute(attribute, -1L, atomicLong);
        if (!bl) {
            return defaultValue;
        }
        return atomicLong.longValue();
    }

    public float getFloatAttribute(String attribute, float defaultValue) {
        if (attribute == null || attribute.equals("")) {
            return defaultValue;
        }
        AtomicReference atomicReference = new AtomicReference();
        boolean bl = ((EMAMessage)this.emaObject).getFloatAttribute(attribute, defaultValue, atomicReference);
        if (!bl) {
            return defaultValue;
        }
        return ((Float)atomicReference.get()).floatValue();
    }

    public double getDoubleAttribute(String attribute, double defaultValue) {
        if (attribute == null || attribute.equals("")) {
            return defaultValue;
        }
        AtomicReference atomicReference = new AtomicReference();
        boolean bl = ((EMAMessage)this.emaObject).getDoubleAttribute(attribute, defaultValue, atomicReference);
        if (!bl) {
            return defaultValue;
        }
        return (Double)atomicReference.get();
    }

    public int getIntAttribute(String attribute) throws ChatException {
        if (attribute == null || attribute.equals("")) {
            throw new ChatException(1, "attribute " + attribute + " can not be null or empty");
        }
        AtomicInteger atomicInteger = new AtomicInteger();
        boolean bl = ((EMAMessage)this.emaObject).getIntAttribute(attribute, -1, atomicInteger);
        if (!bl) {
            throw new ChatException(1, "attribute " + attribute + " not found");
        }
        return atomicInteger.intValue();
    }

    public long getLongAttribute(String attribute) throws ChatException {
        if (attribute == null || attribute.equals("")) {
            throw new ChatException(1, "attribute " + attribute + " can not be null or empty");
        }
        AtomicLong atomicLong = new AtomicLong();
        boolean bl = ((EMAMessage)this.emaObject).getLongAttribute(attribute, -1L, atomicLong);
        if (!bl) {
            throw new ChatException(1, "attribute " + attribute + " not found");
        }
        return atomicLong.longValue();
    }

    public float getFloatAttribute(String attribute) throws ChatException {
        if (attribute == null || attribute.equals("")) {
            throw new ChatException(1, "attribute " + attribute + " can not be null or empty");
        }
        AtomicReference atomicReference = new AtomicReference();
        boolean bl = ((EMAMessage)this.emaObject).getFloatAttribute(attribute, -1.0f, atomicReference);
        if (!bl) {
            throw new ChatException(1, "attribute " + attribute + " not found");
        }
        return ((Float)atomicReference.get()).floatValue();
    }

    public double getDoubleAttribute(String attribute) throws ChatException {
        if (attribute == null || attribute.equals("")) {
            throw new ChatException(1, "attribute " + attribute + " can not be null or empty");
        }
        AtomicReference atomicReference = new AtomicReference();
        boolean bl = ((EMAMessage)this.emaObject).getDoubleAttribute(attribute, -1.0, atomicReference);
        if (!bl) {
            throw new ChatException(1, "attribute " + attribute + " not found");
        }
        return (Double)atomicReference.get();
    }

    public String getStringAttribute(String attribute) throws ChatException {
        if (attribute == null || attribute.equals("")) {
            throw new ChatException(1, "attribute " + attribute + " can not be null or empty");
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = ((EMAMessage)this.emaObject).getStringAttribute(attribute, "", stringBuilder);
        if (!bl) {
            throw new ChatException(1, "attribute " + attribute + " not found");
        }
        return stringBuilder.toString();
    }

    public String getStringAttribute(String attribute, String defaultValue) {
        if (attribute == null || attribute.equals("")) {
            return defaultValue;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = ((EMAMessage)this.emaObject).getStringAttribute(attribute, "", stringBuilder);
        if (!bl) {
            return defaultValue;
        }
        return stringBuilder.toString();
    }

    public JSONObject getJSONObjectAttribute(String attribute) throws ChatException {
        if (attribute == null || attribute.equals("")) {
            throw new ChatException(1, "attribute " + attribute + " can not be null or empty");
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = ((EMAMessage)this.emaObject).getJsonAttribute(attribute, "{}", stringBuilder);
        if (bl) {
            try {
                JSONObject jSONObject = new JSONObject(stringBuilder.toString());
                return jSONObject;
            }
            catch (JSONException jSONException) {
                throw new ChatException(1, jSONException.getMessage());
            }
        }
        throw new ChatException(1, "attribute " + attribute + " not found");
    }

    public JSONArray getJSONArrayAttribute(String attribute) throws ChatException {
        if (attribute == null || attribute.equals("")) {
            throw new ChatException(1, "attribute " + attribute + " can not be null or empty");
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = ((EMAMessage)this.emaObject).getJsonAttribute(attribute, "[]", stringBuilder);
        if (bl) {
            try {
                JSONArray jSONArray = new JSONArray(stringBuilder.toString());
                return jSONArray;
            }
            catch (JSONException jSONException) {
                throw new ChatException(1, jSONException.getMessage());
            }
        }
        throw new ChatException(1, "attribute " + attribute + " not found");
    }

    public ChatType getChatType() {
        EMAMessage.EMAChatType eMAChatType = ((EMAMessage)this.emaObject).chatType();
        ChatType chatType = ChatType.Chat;
        chatType = eMAChatType == EMAMessage.EMAChatType.SINGLE ? ChatType.Chat : (eMAChatType == EMAMessage.EMAChatType.GROUP ? ChatType.GroupChat : ChatType.ChatRoom);
        return chatType;
    }

    public void setChatType(ChatType chatType) {
        EMAMessage.EMAChatType eMAChatType = EMAMessage.EMAChatType.SINGLE;
        eMAChatType = chatType == ChatType.Chat ? EMAMessage.EMAChatType.SINGLE : (chatType == ChatType.GroupChat ? EMAMessage.EMAChatType.GROUP : EMAMessage.EMAChatType.CHATROOM);
        ((EMAMessage)this.emaObject).setChatType(eMAChatType);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.getMsgId());
        out.writeLong(((EMAMessage)this.emaObject).getNativeHandler());
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean isAcked() {
        return ((EMAMessage)this.emaObject).isAcked();
    }

    public void setAcked(boolean isAcked) {
        ((EMAMessage)this.emaObject).setIsAcked(isAcked);
    }

    public boolean isDelivered() {
        return ((EMAMessage)this.emaObject).isDeliverAcked();
    }

    public void setDelivered(boolean isDelivered) {
        ((EMAMessage)this.emaObject).setIsDeliverAcked(isDelivered);
    }

    public boolean isUnread() {
        return !((EMAMessage)this.emaObject).isRead();
    }

    public void setUnread(boolean unread) {
        EMLog.d(TAG, "setUnread unread: " + unread + " msgId: " + this.getMsgId());
        ((EMAMessage)this.emaObject).setIsRead(!unread);
    }

    public boolean isListened() {
        return ((EMAMessage)this.emaObject).isListened();
    }

    public void setListened(boolean isListened) {
        ((EMAMessage)this.emaObject).setListened(isListened);
    }

    public String getUserName() {
        String string = "";
        string = this.getFrom() != null && this.getFrom().equals(ChatClient.getInstance().getCurrentUser()) ? this.getTo() : this.getFrom();
        return string;
    }

    public void setDeliverAcked(boolean isDeliverAcked) {
        ((EMAMessage)this.emaObject).setIsDeliverAcked(isDeliverAcked);
    }

    public int progress() {
        return ((EMAMessage)this.emaObject).progress();
    }

    public void setProgress(int progress) {
        ((EMAMessage)this.emaObject).setProgress(progress);
    }

    public Direct direct() {
        if (((EMAMessage)this.emaObject).direction() == EMAMessage.EMADirection.SEND) {
            return Direct.SEND;
        }
        return Direct.RECEIVE;
    }

    public void setDirection(Direct dir) {
        ((EMAMessage)this.emaObject).setDirection(dir.ordinal());
    }

    public String conversationId() {
        return ((EMAMessage)this.emaObject).conversationId();
    }

    static String self() {
        String string = ChatClient.getInstance().getCurrentUser();
        if (string == null) {
            string = EMSessionManager.getInstance().getLastLoginUser();
        }
        return string;
    }

    private ChatMessage(Parcel in) throws ChatException {
        String string = in.readString();
        long l = in.readLong();
        ChatMessage chatMessage = ChatClient.getInstance().chatManager().getMessage(l);
        if (chatMessage == null && (chatMessage = ChatClient.getInstance().chatManager().getMessage(string)) == null) {
            throw new ChatException("ChatMessage constructed from parcel failed");
        }
        this.emaObject = chatMessage.emaObject;
    }

    public Map<String, Object> ext() {
        return ((EMAMessage)this.emaObject).ext();
    }

    public Map<String, Object> getAttributes() {
        return ((EMAMessage)this.emaObject).getAttributes();
    }

    public List<MessageReaction> getMessageReaction() {
        List<EMAMessageReaction> list = ((EMAMessage)this.emaObject).reactionList();
        if (list.size() > 0) {
            ArrayList<MessageReaction> arrayList = new ArrayList<MessageReaction>(list.size());
            for (EMAMessageReaction eMAMessageReaction : list) {
                MessageReaction messageReaction = new MessageReaction(eMAMessageReaction);
                arrayList.add(messageReaction);
            }
            return arrayList;
        }
        return null;
    }

    public boolean isOnlineState() {
        return ((EMAMessage)this.emaObject).isOnlineState();
    }

    public void setPriority(ChatRoomMessagePriority priority) {
        ((EMAMessage)this.emaObject).setPriority(priority);
    }

    public boolean isDeliverOnlineOnly() {
        return ((EMAMessage)this.emaObject).isDeliverOnlineOnly();
    }

    public void deliverOnlineOnly(boolean onlineOnly) {
        ((EMAMessage)this.emaObject).deliverOnlineOnly(onlineOnly);
    }

    public void setReceiverList(List<String> receiverList) {
        ((EMAMessage)this.emaObject).setReceiverList(receiverList);
    }

    public List<String> receiverList() {
        return ((EMAMessage)this.emaObject).receiverList();
    }

    public static enum ChatRoomMessagePriority {
        PriorityHigh,
        PriorityNormal,
        PriorityLow;

    }

    static class EMCallbackHolder
    implements CallBack {
        private CallBack strong;
        private WeakReference<CallBack> weak;
        CallBack innerCallback = null;

        EMCallbackHolder(CallBack callback) {
            this.weak = new WeakReference<CallBack>(callback);
        }

        synchronized void update(CallBack callback) {
            if (this.strong != null) {
                this.strong = callback;
                return;
            }
            this.weak = new WeakReference<CallBack>(callback);
        }

        synchronized void makeItStrong() {
            if (this.strong != null) {
                return;
            }
            if (this.weak != null && this.weak.get() != null) {
                this.strong = (CallBack)this.weak.get();
            }
        }

        synchronized void release() {
            if (this.strong == null) {
                return;
            }
            this.weak = new WeakReference<CallBack>(this.strong);
            this.strong = null;
        }

        synchronized CallBack getRef() {
            if (this.strong != null) {
                return this.strong;
            }
            if (this.weak != null) {
                CallBack callBack = (CallBack)this.weak.get();
                if (callBack == null) {
                    EMLog.d(ChatMessage.TAG, "getRef weak:" + callBack);
                }
                return callBack;
            }
            return null;
        }

        @Override
        public void onSuccess() {
            CallBack callBack;
            if (this.innerCallback != null) {
                this.innerCallback.onSuccess();
            }
            if ((callBack = this.getRef()) != null) {
                callBack.onSuccess();
                this.release();
            } else {
                EMLog.d(ChatMessage.TAG, "CallbackHolder getRef: null");
            }
        }

        @Override
        public void onError(int code, String error) {
            CallBack callBack;
            if (this.innerCallback != null) {
                this.innerCallback.onError(code, error);
            }
            if ((callBack = this.getRef()) != null) {
                callBack.onError(code, error);
                this.release();
            } else {
                EMLog.d(ChatMessage.TAG, "CallbackHolder getRef: null");
            }
        }

        @Override
        public void onProgress(int progress, String status) {
            CallBack callBack;
            if (this.innerCallback != null) {
                this.innerCallback.onProgress(progress, status);
            }
            if ((callBack = this.getRef()) != null) {
                callBack.onProgress(progress, status);
            }
        }
    }

    public static enum ChatType {
        Chat,
        GroupChat,
        ChatRoom;

    }

    public static enum Status {
        SUCCESS,
        FAIL,
        INPROGRESS,
        CREATE;

    }

    public static enum Direct {
        SEND,
        RECEIVE;

    }

    public static enum Type {
        TXT,
        IMAGE,
        VIDEO,
        LOCATION,
        VOICE,
        FILE,
        CMD,
        CUSTOM,
        COMBINE;

    }
}

