/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import io.agora.CallBack;
import io.agora.ConversationListener;
import io.agora.MessageListener;
import io.agora.ValueCallBack;
import io.agora.chat.ChatClient;
import io.agora.chat.ChatMessage;
import io.agora.chat.ChatOptions;
import io.agora.chat.Conversation;
import io.agora.chat.CursorResult;
import io.agora.chat.FetchMessageOption;
import io.agora.chat.FileMessageBody;
import io.agora.chat.GroupReadAck;
import io.agora.chat.ImageMessageBody;
import io.agora.chat.Language;
import io.agora.chat.MessageBody;
import io.agora.chat.MessageReaction;
import io.agora.chat.MessageReactionChange;
import io.agora.chat.VideoMessageBody;
import io.agora.chat.adapter.EMAChatManager;
import io.agora.chat.adapter.EMAChatManagerListener;
import io.agora.chat.adapter.EMAConversation;
import io.agora.chat.adapter.EMAError;
import io.agora.chat.adapter.EMAFetchMessageOption;
import io.agora.chat.adapter.EMAGroupReadAck;
import io.agora.chat.adapter.EMAMessageReaction;
import io.agora.chat.adapter.EMAMessageReactionChange;
import io.agora.chat.adapter.EMAReactionManager;
import io.agora.chat.adapter.EMAReactionManagerListener;
import io.agora.chat.adapter.message.EMAFileMessageBody;
import io.agora.chat.adapter.message.EMAImageMessageBody;
import io.agora.chat.adapter.message.EMAMessage;
import io.agora.chat.adapter.message.EMAMessageBody;
import io.agora.exceptions.ChatException;
import io.agora.notification.core.b;
import io.agora.util.EMLog;
import io.agora.util.FileHelper;
import io.agora.util.ImageUtils;
import io.agora.util.PathUtil;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class ChatManager {
    EMAChatManager emaObject;
    EMAReactionManager emaReactionObject;
    private static final String TAG = "ChatManager";
    private static final String INTERNAL_ACTION_PREFIX = "em_";
    ChatClient mClient;
    Map<String, Conversation.MessageCache> caches = new Hashtable<String, Conversation.MessageCache>();
    private List<MessageListener> messageListeners = new CopyOnWriteArrayList<MessageListener>();
    private List<ConversationListener> conversationListeners = Collections.synchronizedList(new ArrayList());
    EMAChatManagerListener chatManagerListenerImpl = new EMAChatManagerListener(){

        @Override
        public void onReceiveMessages(final List<EMAMessage> messages) {
            ChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<ChatMessage> arrayList = new ArrayList<ChatMessage>();
                    for (Iterator iterator : messages) {
                        arrayList.add(new ChatMessage((EMAMessage)((Object)iterator)));
                    }
                    ArrayList arrayList2 = new ArrayList();
                    for (ChatMessage object : arrayList) {
                        Conversation conversation = ChatManager.this.getConversation(object.conversationId(), Conversation.msgType2ConversationType(object.getFrom(), object.getChatType()), false);
                        if (conversation == null) {
                            EMLog.d(ChatManager.TAG, "no conversation");
                            continue;
                        }
                        if (object.getType() != ChatMessage.Type.CMD) {
                            conversation.getCache().addMessage(object);
                        }
                        arrayList2.add(object);
                    }
                    if (arrayList2.size() <= 0) {
                        EMLog.d(ChatManager.TAG, "no remainingMsgs");
                        return;
                    }
                    for (MessageListener messageListener : ChatManager.this.messageListeners) {
                        try {
                            EMLog.d(ChatManager.TAG, "onMessageReceived\uff1a " + messageListener);
                            messageListener.onMessageReceived(arrayList2);
                        }
                        catch (Exception exception) {
                            EMLog.d(ChatManager.TAG, "onMessageReceived has problem: " + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onReceiveCmdMessages(final List<EMAMessage> messages) {
            ChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<ChatMessage> arrayList = new ArrayList<ChatMessage>();
                    for (Object object : messages) {
                        arrayList.add(new ChatMessage((EMAMessage)object));
                    }
                    try {
                        for (Object object : ChatManager.this.messageListeners) {
                            object.onCmdMessageReceived(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onMessageStatusChanged(final EMAMessage message, EMAError error) {
            ChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    try {
                        ChatMessage chatMessage = new ChatMessage(message);
                        for (MessageListener messageListener : ChatManager.this.messageListeners) {
                            messageListener.onMessageChanged(chatMessage, null);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onMessageAttachmentsStatusChanged(EMAMessage message, EMAError error) {
            try {
                ChatMessage chatMessage = new ChatMessage(message);
                for (MessageListener messageListener : ChatManager.this.messageListeners) {
                    messageListener.onMessageChanged(chatMessage, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void onReceiveRecallMessages(final List<EMAMessage> messages) {
            ChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<ChatMessage> arrayList = new ArrayList<ChatMessage>();
                    for (Object object : messages) {
                        arrayList.add(new ChatMessage((EMAMessage)object));
                        ChatManager.this.getConversation(((EMAMessage)object).conversationId()).getCache().removeMessage(((EMAMessage)object).msgId());
                    }
                    try {
                        for (Object object : ChatManager.this.messageListeners) {
                            object.onMessageRecalled(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onReceiveHasReadAcks(final List<EMAMessage> messages) {
            ChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<ChatMessage> arrayList = new ArrayList<ChatMessage>();
                    for (Object object : messages) {
                        arrayList.add(new ChatMessage((EMAMessage)object));
                    }
                    try {
                        for (Object object : ChatManager.this.messageListeners) {
                            object.onMessageRead(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onReceiveHasDeliveredAcks(final List<EMAMessage> messages) {
            ChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ArrayList<ChatMessage> arrayList = new ArrayList<ChatMessage>();
                    for (Object object : messages) {
                        arrayList.add(new ChatMessage((EMAMessage)object));
                    }
                    try {
                        for (Object object : ChatManager.this.messageListeners) {
                            object.onMessageDelivered(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onReceiveReadAckForConversation(final String fromUsername, final String toUsername) {
            ChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EMLog.d(ChatManager.TAG, "onReceiveConversationHasReadAcks");
                    List list = ChatManager.this.conversationListeners;
                    synchronized (list) {
                        Object object;
                        if (!TextUtils.equals((CharSequence)fromUsername, (CharSequence)ChatClient.getInstance().getCurrentUser()) && (object = ChatClient.getInstance().chatManager().getConversation(fromUsername)) != null) {
                            ((Conversation)object).loadMoreMsgFromDB(null, ((Conversation)object).getAllMessages().size());
                        }
                        try {
                            for (ConversationListener conversationListener : ChatManager.this.conversationListeners) {
                                conversationListener.onConversationRead(fromUsername, toUsername);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onUpdateConversationList(List<EMAConversation> conversations) {
            ChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EMLog.d(ChatManager.TAG, "onUpdateConversationList");
                    List list = ChatManager.this.conversationListeners;
                    synchronized (list) {
                        try {
                            for (ConversationListener conversationListener : ChatManager.this.conversationListeners) {
                                conversationListener.onConversationUpdate();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onReceivePrivateMessages(final List<EMAMessage> messages) {
            ChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    EMLog.d(ChatManager.TAG, "onPrivateMessages");
                    for (EMAMessage eMAMessage : messages) {
                        ChatMessage chatMessage = new ChatMessage(eMAMessage);
                        b.a().a(chatMessage);
                    }
                }
            });
        }

        @Override
        public void onReceiveReadAcksForGroupMessage(final List<EMAGroupReadAck> acks) {
            ChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    EMLog.d(ChatManager.TAG, "onReceiveReadAcksForGroupMessage");
                    ArrayList<GroupReadAck> arrayList = new ArrayList<GroupReadAck>();
                    for (Object object : acks) {
                        arrayList.add(new GroupReadAck((EMAGroupReadAck)object));
                    }
                    try {
                        for (Object object : ChatManager.this.messageListeners) {
                            object.onGroupMessageRead(arrayList);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onUpdateGroupAcks() {
            ChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    EMLog.d(ChatManager.TAG, "onUpdateGroupAcks");
                    try {
                        for (MessageListener messageListener : ChatManager.this.messageListeners) {
                            messageListener.onReadAckForGroupMessageUpdated();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }

        @Override
        public void onMessageIdChanged(String convId, String oldId, String newId) {
            Conversation conversation;
            EMAMessage eMAMessage = ChatManager.this.emaObject.getMessage(newId);
            if (eMAMessage != null) {
                ChatManager.this.deleteImageScaledPath(eMAMessage);
            }
            if ((conversation = ChatManager.this.getConversation(convId)) != null) {
                conversation.getCache().replaceMsgId(oldId, newId);
            }
        }

        @Override
        public void onMessageContentChanged(final EMAMessage message, final String operatorId, final long operationTime) {
            ChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    ChatMessage chatMessage = new ChatMessage(message);
                    Conversation conversation = ChatManager.this.getConversation(chatMessage.conversationId(), Conversation.msgType2ConversationType(chatMessage.getFrom(), chatMessage.getChatType()), false);
                    if (conversation != null) {
                        if (chatMessage.getType() != ChatMessage.Type.CMD) {
                            conversation.getCache().removeMessage(chatMessage.getMsgId());
                            conversation.getCache().addMessage(chatMessage);
                        }
                    } else {
                        EMLog.d(ChatManager.TAG, "onMessageContentChanged:no conversation");
                    }
                    for (MessageListener messageListener : ChatManager.this.messageListeners) {
                        try {
                            EMLog.d(ChatManager.TAG, "onMessageContentChanged\uff1a " + messageListener);
                            messageListener.onMessageContentChanged(chatMessage, operatorId, operationTime);
                        }
                        catch (Exception exception) {
                            EMLog.d(ChatManager.TAG, "onMessageContentChanged has problem: " + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    };
    EMAReactionManagerListener mReactionManagerListenerImpl = new EMAReactionManagerListener(){

        @Override
        public void onMessageReactionDidChange(final List<EMAMessageReactionChange> reactionChangeList) {
            ChatManager.this.mClient.executeOnMainQueue(new Runnable(){

                @Override
                public void run() {
                    EMLog.d(ChatManager.TAG, "onMessageReactionDidChange");
                    ArrayList<MessageReactionChange> arrayList = new ArrayList<MessageReactionChange>(reactionChangeList.size());
                    for (Object object : reactionChangeList) {
                        MessageReactionChange messageReactionChange = new MessageReactionChange((EMAMessageReactionChange)object);
                        arrayList.add(messageReactionChange);
                    }
                    for (Object object : ChatManager.this.messageListeners) {
                        try {
                            object.onReactionChanged(arrayList);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    };
    private static final int LIST_SIZE = 512;

    protected ChatManager() {
    }

    protected ChatManager(ChatClient client, EMAChatManager manager, EMAReactionManager reactionManager) {
        this.mClient = client;
        this.emaObject = manager;
        this.emaObject.addListener(this.chatManagerListenerImpl);
        this.emaReactionObject = reactionManager;
        this.emaReactionObject.addListener(this.mReactionManagerListenerImpl);
    }

    public void sendMessage(final ChatMessage msg) {
        msg.makeCallbackStrong();
        boolean bl = msg.getType() != ChatMessage.Type.CMD;
        final Conversation conversation = this.getConversation(msg.conversationId(), Conversation.msgType2ConversationType(msg.getTo(), msg.getChatType()), bl, msg.isChatThreadMessage());
        if (conversation != null) {
            boolean bl2;
            boolean bl3 = bl2 = conversation.getCache().getMessage(msg.getMsgId()) != null;
            if (!bl2) {
                long l = System.currentTimeMillis();
                ChatMessage chatMessage = conversation.getLastMessage();
                if (chatMessage != null) {
                    l = l < chatMessage.getMsgTime() ? chatMessage.getMsgTime() : l;
                }
                msg.setMsgTime(l + 1L);
                conversation.getCache().addMessage(msg);
            }
        }
        this.mClient.executeOnSendQueue(new Runnable(){

            @Override
            public void run() {
                class HandleError {
                    final /* synthetic */ ChatMessage val$msg;

                    HandleError(int code, String desc) {
                        this.val$msg = chatMessage;
                        ChatMessage.EMCallbackHolder eMCallbackHolder = this.val$msg.messageStatusCallBack;
                        if (eMCallbackHolder != null) {
                            eMCallbackHolder.onError(code, desc);
                        }
                    }
                }
                try {
                    Object object;
                    if (ChatManager.this.mClient.getOptions().getAutoTransferMessageAttachments()) {
                        if (msg.getType() == ChatMessage.Type.IMAGE) {
                            Object object2;
                            msg.setStatus(ChatMessage.Status.INPROGRESS);
                            object = (ImageMessageBody)msg.getBody();
                            if (object == null) {
                                new HandleError(ChatManager.this, 1, "Message body can not be null", msg);
                                return;
                            }
                            String string = ((FileMessageBody)object).getLocalUrl();
                            String string2 = ((FileMessageBody)object).getRemoteUrl();
                            if (TextUtils.isEmpty((CharSequence)string2) && !FileHelper.getInstance().isFileExist(string)) {
                                new HandleError(ChatManager.this, 401, "File not exists or can not be read", msg);
                                return;
                            }
                            if (!((ImageMessageBody)object).isSendOriginalImage() && FileHelper.getInstance().isFileExist(string)) {
                                object2 = ImageUtils.getScaledImageByUri(ChatManager.this.mClient.getContext(), string);
                                if (!TextUtils.equals((CharSequence)object2, (CharSequence)string)) {
                                    ((ImageMessageBody)object).setOriginalLocalPath(string);
                                    long l = FileHelper.getInstance().getFileLength(string);
                                    long l2 = FileHelper.getInstance().getFileLength((String)object2);
                                    if (l == 0L) {
                                        EMLog.d(ChatManager.TAG, "original image size:" + l);
                                        new HandleError(ChatManager.this, 401, "original image size is 0", msg);
                                        return;
                                    }
                                    EMLog.d(ChatManager.TAG, "original image size:" + l + " scaled image size:" + l2 + " ratio:" + (int)(l2 / l) + "%");
                                    string = object2;
                                    ((FileMessageBody)object).setLocalUrl(FileHelper.getInstance().formatInUri(string));
                                    ((FileMessageBody)object).setFileLength(l2);
                                }
                                ((FileMessageBody)object).setFileName(FileHelper.getInstance().getFilename(string));
                            }
                            if ((object2 = ImageUtils.getBitmapOptions(ChatManager.this.mClient.getContext(), string)) != null) {
                                int n = object2.outWidth;
                                int n2 = object2.outHeight;
                                ((ImageMessageBody)object).setSize(n, n2);
                            }
                        } else if (msg.getType() == ChatMessage.Type.VIDEO) {
                            msg.setStatus(ChatMessage.Status.INPROGRESS);
                            object = (VideoMessageBody)msg.getBody();
                            if (object == null) {
                                new HandleError(ChatManager.this, 1, "Message body can not be null", msg);
                                return;
                            }
                            Uri uri = ((FileMessageBody)object).getLocalUri();
                            String string = ((FileMessageBody)object).getRemoteUrl();
                            if (TextUtils.isEmpty((CharSequence)string) && !FileHelper.getInstance().isFileExist(uri)) {
                                new HandleError(ChatManager.this, 401, "File not exists or can not be read", msg);
                                return;
                            }
                            String string3 = FileHelper.getInstance().getFilePath(((VideoMessageBody)object).getLocalThumbUri());
                            if (!TextUtils.isEmpty((CharSequence)string3)) {
                                BitmapFactory.Options options = ImageUtils.getBitmapOptions(string3);
                                int n = options.outWidth;
                                int n3 = options.outHeight;
                                ((VideoMessageBody)object).setThumbnailSize(n, n3);
                            }
                        }
                    }
                    object = msg.getMsgId();
                    ChatManager.this.setMessageSendCallback(msg, conversation, (String)object);
                    ChatManager.this.emaObject.sendMessage((EMAMessage)msg.emaObject);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new HandleError(ChatManager.this, 1, "send message failed", msg);
                }
            }
        });
    }

    private void setMessageSendCallback(final ChatMessage msg, final Conversation conv, final String oldId) {
        if (msg == null) {
            return;
        }
        msg.setInnerCallback(new CallBack(){

            @Override
            public void onSuccess() {
                ChatManager.this.deleteImageScaledPath((EMAMessage)msg.emaObject);
                if (conv != null) {
                    conv.getCache().replaceMsgId(oldId, msg.getMsgId());
                }
            }

            @Override
            public void onError(int code, String error) {
            }
        });
    }

    private void deleteImageScaledPath(EMAMessage msg) {
        if (msg == null) {
            return;
        }
        List<EMAMessageBody> list = msg.bodies();
        if (list.size() <= 0) {
            return;
        }
        EMAMessageBody eMAMessageBody = msg.bodies().get(0);
        if (eMAMessageBody instanceof EMAImageMessageBody) {
            String string = ((EMAImageMessageBody)eMAMessageBody).getOriginalLocalPath();
            if (!FileHelper.getInstance().isFileExist(string)) {
                return;
            }
            String string2 = ((EMAImageMessageBody)eMAMessageBody).getLocalUrl();
            EMLog.d(TAG, "origin: + " + string + ", scale:" + string2);
            if (string2 != null && !string2.equals(string)) {
                boolean bl = FileHelper.getInstance().deletePrivateFile(string2);
                EMLog.d(TAG, "Deleted the scale image file: " + bl + " the scale image file path: " + string2);
            }
            ((EMAImageMessageBody)eMAMessageBody).setLocalPath(string);
            Conversation conversation = this.getConversation(msg.conversationId());
            if (conversation != null) {
                ((EMAConversation)conversation.emaObject).updateMessage(msg);
            }
        }
    }

    public void ackConversationRead(String conversationId) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.sendReadAckForConversation(conversationId, eMAError);
        this.handleError(eMAError);
    }

    public void ackMessageRead(String to, String messageId) throws ChatException {
        ChatOptions chatOptions = ChatClient.getInstance().getChatConfigPrivate().b();
        if (!chatOptions.getRequireAck()) {
            EMLog.d(TAG, "As the chat option SetRequireAck is set to false, the read receipt is not sent.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)to)) {
            EMLog.e(TAG, "The to parameter cannot be null.");
            return;
        }
        EMAMessage eMAMessage = this.emaObject.getMessage(messageId);
        if (eMAMessage != null) {
            this.emaObject.sendReadAckForMessage(eMAMessage);
        } else {
            EMAMessage eMAMessage2 = EMAMessage.createReceiveMessage("", ChatMessage.self(), null, ChatMessage.ChatType.Chat.ordinal());
            eMAMessage2.setMsgId(messageId);
            eMAMessage2.setFrom(to);
            eMAMessage2.setConversationId(to);
            this.emaObject.sendReadAckForMessage(eMAMessage2);
        }
    }

    public void ackGroupMessageRead(String to, String messageId, String ext) throws ChatException {
        ChatOptions chatOptions = ChatClient.getInstance().getChatConfigPrivate().b();
        if (!chatOptions.getRequireAck()) {
            EMLog.d(TAG, "chat option reqire ack set to false. skip send out ask msg read");
            return;
        }
        EMAMessage eMAMessage = this.emaObject.getMessage(messageId);
        if (eMAMessage != null) {
            if (eMAMessage.isNeedGroupAck()) {
                this.emaObject.sendReadAckForGroupMessage(eMAMessage, ext);
            } else {
                EMLog.d(TAG, "normal group message, do not ack it");
            }
        }
    }

    public void recallMessage(ChatMessage message) throws ChatException {
        EMAError eMAError = new EMAError();
        if (message == null) {
            throw new ChatException(500, "The message was not found");
        }
        this.emaObject.recallMessage((EMAMessage)message.emaObject, eMAError);
        this.handleError(eMAError);
        Conversation conversation = this.getConversation(message.getTo(), Conversation.msgType2ConversationType(message.getMsgId(), message.getChatType()), true, message.isChatThreadMessage());
        if (conversation != null) {
            conversation.getCache().removeMessage(message.getMsgId());
        }
    }

    public void asyncRecallMessage(final ChatMessage message, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatManager.this.recallMessage(message);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatMessage getMessage(String messageId) {
        Object object = this.caches;
        synchronized (object) {
            for (Conversation.MessageCache messageCache : this.caches.values()) {
                ChatMessage chatMessage = messageCache.getMessage(messageId);
                if (chatMessage == null) continue;
                return chatMessage;
            }
        }
        object = this.emaObject.getMessage(messageId);
        if (object == null) {
            return null;
        }
        ChatMessage chatMessage = new ChatMessage((EMAMessage)object);
        return chatMessage;
    }

    ChatMessage getMessage(long nativeHandler) {
        EMAMessage eMAMessage = this.emaObject.getMessage(nativeHandler);
        if (eMAMessage == null) {
            return null;
        }
        return new ChatMessage(eMAMessage);
    }

    public Conversation getConversation(String id) {
        EMAConversation eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.CHAT, false, false);
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.GROUPCHAT, false, false);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.GROUPCHAT, false, true);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.CHATROOM, false, false);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.CHATROOM, false, true);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.DISCUSSIONGROUP, false, false);
        }
        if (eMAConversation == null) {
            eMAConversation = this.emaObject.conversationWithType(id, EMAConversation.EMAConversationType.HELPDESK, false, false);
        }
        return eMAConversation == null ? null : new Conversation(eMAConversation);
    }

    public Conversation getConversation(String id, Conversation.ConversationType type) {
        Conversation conversation = this.getConversation(id, type, false);
        if (conversation == null) {
            return this.getConversation(id, type, false, true);
        }
        return conversation;
    }

    public Conversation getConversation(String username, Conversation.ConversationType type, boolean createIfNotExists) {
        Conversation conversation = this.getConversation(username, type, createIfNotExists, false);
        if (conversation == null) {
            return this.getConversation(username, type, createIfNotExists, true);
        }
        return conversation;
    }

    public Conversation getConversation(String username, Conversation.ConversationType type, boolean createIfNotExists, boolean isChatThread) {
        EMAConversation.EMAConversationType eMAConversationType = EMAConversation.EMAConversationType.CHAT;
        switch (type) {
            case Chat: {
                eMAConversationType = EMAConversation.EMAConversationType.CHAT;
                break;
            }
            case GroupChat: {
                eMAConversationType = EMAConversation.EMAConversationType.GROUPCHAT;
                break;
            }
            case ChatRoom: {
                eMAConversationType = EMAConversation.EMAConversationType.CHATROOM;
                break;
            }
            case DiscussionGroup: {
                eMAConversationType = EMAConversation.EMAConversationType.DISCUSSIONGROUP;
                break;
            }
            case HelpDesk: {
                eMAConversationType = EMAConversation.EMAConversationType.HELPDESK;
            }
        }
        EMAConversation eMAConversation = this.emaObject.conversationWithType(username, eMAConversationType, createIfNotExists, isChatThread);
        if (eMAConversation == null) {
            return null;
        }
        Log.d((String)TAG, (String)("convID:" + eMAConversation.conversationId()));
        return new Conversation(eMAConversation);
    }

    public void markAllConversationsAsRead() {
        List<EMAConversation> list = this.emaObject.loadAllConversationsFromDB();
        for (EMAConversation eMAConversation : list) {
            eMAConversation.markAllMessagesAsRead(true);
        }
    }

    public int getUnreadMessageCount() {
        List<EMAConversation> list = this.emaObject.getConversations();
        int n = 0;
        for (EMAConversation eMAConversation : list) {
            if (eMAConversation._getType() == EMAConversation.EMAConversationType.CHATROOM) continue;
            n += eMAConversation.unreadMessagesCount();
        }
        return n;
    }

    public void saveMessage(ChatMessage message) {
        ChatMessage.ChatType chatType = message.getChatType();
        Conversation.ConversationType conversationType = Conversation.ConversationType.Chat;
        switch (chatType) {
            case Chat: {
                conversationType = Conversation.ConversationType.Chat;
                break;
            }
            case GroupChat: {
                conversationType = Conversation.ConversationType.GroupChat;
                break;
            }
            case ChatRoom: {
                conversationType = Conversation.ConversationType.ChatRoom;
            }
        }
        String string = message.getTo();
        if (conversationType == Conversation.ConversationType.Chat && message.direct() == ChatMessage.Direct.RECEIVE) {
            string = message.getFrom();
        }
        if (message.getType() == ChatMessage.Type.CMD) {
            return;
        }
        Conversation conversation = this.getConversation(string, conversationType, true, message.isChatThreadMessage());
        if (conversation == null) {
            EMLog.e(TAG, "Failed to save message because conversation is null, convId: " + string);
            return;
        }
        conversation.insertMessage(message);
    }

    public boolean updateMessage(ChatMessage message) {
        String string;
        String string2 = string = message.direct() == ChatMessage.Direct.RECEIVE ? message.getFrom() : message.getTo();
        if (message.getType() == ChatMessage.Type.CMD) {
            return false;
        }
        Conversation conversation = this.getConversation(message.conversationId(), Conversation.msgType2ConversationType(string, message.getChatType()), true, message.isChatThreadMessage());
        return conversation.updateMessage(message);
    }

    public void asyncModifyMessage(final String messageId, final MessageBody messageBodyModified, final ValueCallBack<ChatMessage> callBack) {
        if (TextUtils.isEmpty((CharSequence)messageId) || messageBodyModified == null) {
            callBack.onError(1, "messageId or messageBody is empty");
            return;
        }
        this.mClient.executeOnSendQueue(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAMessage eMAMessage = ChatManager.this.emaObject.modifyMessage(messageId, (EMAMessageBody)messageBodyModified.emaObject, eMAError);
                    ChatManager.this.handleError(eMAError);
                    if (eMAMessage != null) {
                        callBack.onSuccess(new ChatMessage(eMAMessage));
                    } else {
                        callBack.onError(1, "emaMessage is empty");
                    }
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void downloadAttachment(ChatMessage msg) {
        if (msg == null) {
            return;
        }
        msg.makeCallbackStrong();
        this.checkContentAttachmentExist(msg);
        this.emaObject.downloadMessageAttachments((EMAMessage)msg.emaObject);
    }

    private void checkContentAttachmentExist(ChatMessage msg) {
        List<EMAMessageBody> list = ((EMAMessage)msg.emaObject).bodies();
        if (list != null && !list.isEmpty()) {
            for (EMAMessageBody eMAMessageBody : list) {
                switch (eMAMessageBody.type()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        EMAFileMessageBody eMAFileMessageBody = (EMAFileMessageBody)eMAMessageBody;
                        String string = eMAFileMessageBody.getLocalUrl();
                        EMLog.d(TAG, "download before check path = " + string);
                        if (!TextUtils.isEmpty((CharSequence)string) && string.contains("/Android/data/" + this.mClient.getContext().getPackageName() + "/")) break;
                        String string2 = eMAFileMessageBody.displayName();
                        String string3 = null;
                        switch (eMAMessageBody.type()) {
                            case 1: {
                                string3 = PathUtil.getInstance().getImagePath() + File.separator + string2;
                                break;
                            }
                            case 2: {
                                string3 = PathUtil.getInstance().getVideoPath() + File.separator + string2;
                                break;
                            }
                            case 4: {
                                string3 = PathUtil.getInstance().getVoicePath() + File.separator + string2;
                                break;
                            }
                            case 5: {
                                string3 = PathUtil.getInstance().getFilePath() + File.separator + string2;
                            }
                        }
                        if (TextUtils.isEmpty(string3)) break;
                        eMAFileMessageBody.setLocalPath(string3);
                        this.updateMessage(msg);
                        EMLog.d(TAG, "download:create new path , path is " + string3);
                    }
                }
            }
        }
    }

    public void downloadThumbnail(ChatMessage msg) {
        msg.makeCallbackStrong();
        this.emaObject.downloadMessageThumbnail((EMAMessage)msg.emaObject);
    }

    public void downloadAndParseCombineMessage(ChatMessage message, ValueCallBack<List<ChatMessage>> callback) {
        ChatClient.getInstance().execute(() -> {
            if (message == null) {
                callback.onError(110, "Message cannot be null.");
                return;
            }
            if (message.getType() != ChatMessage.Type.COMBINE) {
                callback.onError(110, "Only combine message are supported.");
                return;
            }
            EMAError eMAError = new EMAError();
            List<EMAMessage> list = this.emaObject.downloadCombineMessages((EMAMessage)message.emaObject, eMAError);
            try {
                this.handleError(eMAError);
            }
            catch (ChatException chatException) {
                callback.onError(chatException.getErrorCode(), chatException.getDescription());
                return;
            }
            ArrayList<ChatMessage> arrayList = new ArrayList<ChatMessage>();
            for (EMAMessage eMAMessage : list) {
                arrayList.add(new ChatMessage(eMAMessage));
            }
            callback.onSuccess(arrayList);
        });
    }

    public synchronized void importMessages(List<ChatMessage> msgs) {
        ArrayList<EMAMessage> arrayList = new ArrayList<EMAMessage>();
        for (ChatMessage chatMessage : msgs) {
            arrayList.add((EMAMessage)chatMessage.emaObject);
        }
        ChatClient.getInstance().getChatConfigPrivate().c(arrayList);
    }

    public List<Conversation> getConversationsByType(Conversation.ConversationType type) {
        List<EMAConversation> list = this.emaObject.getConversations();
        ArrayList<Conversation> arrayList = new ArrayList<Conversation>();
        for (EMAConversation eMAConversation : list) {
            if (type.ordinal() != eMAConversation._getType().ordinal()) continue;
            arrayList.add(new Conversation(eMAConversation));
        }
        return arrayList;
    }

    public Map<String, Conversation> getAllConversations() {
        List<EMAConversation> list = this.emaObject.getConversations();
        Hashtable<String, Conversation> hashtable = new Hashtable<String, Conversation>();
        for (EMAConversation eMAConversation : list) {
            hashtable.put(eMAConversation.conversationId(), new Conversation(eMAConversation));
        }
        return hashtable;
    }

    public List<Conversation> getAllConversationsBySort() {
        List<EMAConversation> list = this.emaObject.getAllConversationsBySort();
        ArrayList<Conversation> arrayList = new ArrayList<Conversation>();
        for (EMAConversation eMAConversation : list) {
            arrayList.add(new Conversation(eMAConversation));
        }
        return arrayList;
    }

    @Deprecated
    public Map<String, Conversation> fetchConversationsFromServer() throws ChatException {
        EMAError eMAError = new EMAError();
        List<EMAConversation> list = this.emaObject.fetchConversationsFromServer(eMAError);
        this.handleError(eMAError);
        Hashtable<String, Conversation> hashtable = new Hashtable<String, Conversation>();
        for (EMAConversation eMAConversation : list) {
            hashtable.put(eMAConversation.conversationId(), new Conversation(eMAConversation));
        }
        return hashtable;
    }

    @Deprecated
    public void asyncFetchConversationsFromServer(final ValueCallBack<Map<String, Conversation>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatManager.this.fetchConversationsFromServer());
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    Map<String, Conversation> fetchConversationsFromServer(int pageNum, int pageSize) throws ChatException {
        EMAError eMAError = new EMAError();
        List<EMAConversation> list = this.emaObject.fetchConversationsFromServerWithPage(eMAError, pageNum, pageSize);
        this.handleError(eMAError);
        Hashtable<String, Conversation> hashtable = new Hashtable<String, Conversation>();
        for (EMAConversation eMAConversation : list) {
            hashtable.put(eMAConversation.conversationId(), new Conversation(eMAConversation));
        }
        return hashtable;
    }

    @Deprecated
    public void asyncFetchConversationsFromServer(final int pageNum, final int pageSize, final ValueCallBack<Map<String, Conversation>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatManager.this.fetchConversationsFromServer(pageNum, pageSize));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void asyncFetchPinnedConversationsFromServer(int limit, String cursor, ValueCallBack<CursorResult<Conversation>> callback) {
        this.mClient.execute(() -> {
            EMAError eMAError = new EMAError();
            CursorResult<EMAConversation> cursorResult = this.emaObject.fetchPinnedConversationsFromServer(limit, cursor, eMAError);
            try {
                this.handleError(eMAError);
            }
            catch (ChatException chatException) {
                callback.onError(chatException.getErrorCode(), chatException.getDescription());
                return;
            }
            CursorResult cursorResult2 = new CursorResult();
            cursorResult2.setCursor(cursorResult.getCursor());
            ArrayList<Conversation> arrayList = new ArrayList<Conversation>();
            for (EMAConversation eMAConversation : (List)cursorResult.getData()) {
                arrayList.add(new Conversation(eMAConversation));
            }
            cursorResult2.setData(arrayList);
            callback.onSuccess(cursorResult2);
        });
    }

    public void asyncFetchConversationsFromServer(int limit, String cursor, ValueCallBack<CursorResult<Conversation>> callback) {
        this.mClient.execute(() -> {
            EMAError eMAError = new EMAError();
            CursorResult<EMAConversation> cursorResult = this.emaObject.fetchConversationsFromServerWithCursor(limit, cursor, eMAError);
            try {
                this.handleError(eMAError);
            }
            catch (ChatException chatException) {
                callback.onError(chatException.getErrorCode(), chatException.getDescription());
                return;
            }
            CursorResult cursorResult2 = new CursorResult();
            cursorResult2.setCursor(cursorResult.getCursor());
            ArrayList<Conversation> arrayList = new ArrayList<Conversation>();
            for (EMAConversation eMAConversation : (List)cursorResult.getData()) {
                arrayList.add(new Conversation(eMAConversation));
            }
            cursorResult2.setData(arrayList);
            callback.onSuccess(cursorResult2);
        });
    }

    public void asyncPinConversation(String conversationId, boolean isPinned, CallBack callback) {
        this.mClient.execute(() -> {
            EMAError eMAError = new EMAError();
            this.emaObject.pinConversation(conversationId, isPinned, eMAError);
            try {
                this.handleError(eMAError);
                callback.onSuccess();
            }
            catch (ChatException chatException) {
                callback.onError(chatException.getErrorCode(), chatException.getDescription());
            }
        });
    }

    public void loadAllConversations() {
        this.emaObject.loadAllConversationsFromDB();
    }

    public boolean deleteConversation(String username, boolean deleteMessages) {
        Conversation conversation = this.getConversation(username);
        if (conversation == null) {
            return false;
        }
        if (!deleteMessages) {
            conversation.clear();
        } else {
            conversation.clearAllMessages();
        }
        this.emaObject.removeConversation(username, deleteMessages, conversation.isChatThread());
        return true;
    }

    public void deleteConversationFromServer(final String username, final Conversation.ConversationType type, final boolean isDeleteServerMessages, final CallBack deleteCallBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAConversation.EMAConversationType eMAConversationType = EMAConversation.EMAConversationType.CHAT;
                switch (type) {
                    case Chat: {
                        eMAConversationType = EMAConversation.EMAConversationType.CHAT;
                        break;
                    }
                    case GroupChat: {
                        eMAConversationType = EMAConversation.EMAConversationType.GROUPCHAT;
                        break;
                    }
                    case ChatRoom: {
                        eMAConversationType = EMAConversation.EMAConversationType.CHATROOM;
                        break;
                    }
                    case DiscussionGroup: {
                        eMAConversationType = EMAConversation.EMAConversationType.DISCUSSIONGROUP;
                        break;
                    }
                    case HelpDesk: {
                        eMAConversationType = EMAConversation.EMAConversationType.HELPDESK;
                    }
                }
                EMAError eMAError = ChatManager.this.emaObject.deleteConversationFromServer(username, eMAConversationType, isDeleteServerMessages);
                if (eMAError.errCode() == 0) {
                    deleteCallBack.onSuccess();
                } else {
                    deleteCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void addMessageListener(MessageListener listener) {
        if (listener == null) {
            EMLog.d(TAG, "addMessageListener: listener is null");
            return;
        }
        if (!this.messageListeners.contains(listener)) {
            EMLog.d(TAG, "add message listener: " + listener);
            this.messageListeners.add(listener);
        }
    }

    public void removeMessageListener(MessageListener listener) {
        if (listener == null) {
            return;
        }
        this.messageListeners.remove(listener);
    }

    public void addConversationListener(ConversationListener listener) {
        if (!this.conversationListeners.contains(listener)) {
            this.conversationListeners.add(listener);
        }
    }

    public void removeConversationListener(ConversationListener listener) {
        if (listener == null) {
            return;
        }
        this.conversationListeners.remove(listener);
    }

    public void setVoiceMessageListened(ChatMessage message) {
        message.setListened(true);
        this.updateMessage(message);
    }

    void onLogout() {
        this.caches.clear();
    }

    synchronized void loadAllConversationsFromDB() {
        this.emaObject.loadAllConversationsFromDB();
    }

    public boolean updateParticipant(String from, String changeTo) {
        return this.emaObject.updateParticipant(from, changeTo);
    }

    public CursorResult<GroupReadAck> fetchGroupReadAcks(String msgId, int pageSize, String startAckId) throws ChatException {
        EMAError eMAError = new EMAError();
        CursorResult<GroupReadAck> cursorResult = new CursorResult<GroupReadAck>();
        ChatMessage chatMessage = this.getMessage(msgId);
        String string = null;
        if (chatMessage.getChatType() != ChatMessage.ChatType.GroupChat || !chatMessage.isNeedGroupAck()) {
            EMLog.e(TAG, "not group msg or don't need ack");
            return cursorResult;
        }
        string = chatMessage.conversationId();
        CursorResult<EMAGroupReadAck> cursorResult2 = this.emaObject.fetchGroupReadAcks(msgId, string, eMAError, pageSize, startAckId);
        this.handleError(eMAError);
        cursorResult.setCursor(cursorResult2.getCursor());
        ArrayList<GroupReadAck> arrayList = new ArrayList<GroupReadAck>();
        for (EMAGroupReadAck eMAGroupReadAck : (List)cursorResult2.getData()) {
            arrayList.add(new GroupReadAck(eMAGroupReadAck));
        }
        cursorResult.setData(arrayList);
        return cursorResult;
    }

    public void asyncFetchGroupReadAcks(final String msgId, final int pageSize, final String startAckId, final ValueCallBack<CursorResult<GroupReadAck>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatManager.this.fetchGroupReadAcks(msgId, pageSize, startAckId));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public CursorResult<ChatMessage> fetchHistoryMessages(String conversationId, Conversation.ConversationType type, int pageSize, String startMsgId) throws ChatException {
        return this.fetchHistoryMessages(conversationId, type, pageSize, startMsgId, Conversation.SearchDirection.UP);
    }

    public CursorResult<ChatMessage> fetchHistoryMessages(String conversationId, Conversation.ConversationType type, int pageSize, String startMsgId, Conversation.SearchDirection direction) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAConversation.EMASearchDirection eMASearchDirection = direction == Conversation.SearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        CursorResult<EMAMessage> cursorResult = this.emaObject.fetchHistoryMessages(conversationId, type.ordinal(), pageSize, startMsgId, eMASearchDirection, eMAError);
        this.handleError(eMAError);
        CursorResult<ChatMessage> cursorResult2 = new CursorResult<ChatMessage>();
        cursorResult2.setCursor(cursorResult.getCursor());
        ArrayList<ChatMessage> arrayList = new ArrayList<ChatMessage>();
        for (EMAMessage eMAMessage : (List)cursorResult.getData()) {
            arrayList.add(new ChatMessage(eMAMessage));
        }
        cursorResult2.setData(arrayList);
        return cursorResult2;
    }

    public void asyncFetchHistoryMessage(final String conversationId, final Conversation.ConversationType type, final int pageSize, final String startMsgId, final ValueCallBack<CursorResult<ChatMessage>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatManager.this.fetchHistoryMessages(conversationId, type, pageSize, startMsgId));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void asyncFetchHistoryMessage(final String conversationId, final Conversation.ConversationType type, final int pageSize, final String startMsgId, final Conversation.SearchDirection direction, final ValueCallBack<CursorResult<ChatMessage>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatManager.this.fetchHistoryMessages(conversationId, type, pageSize, startMsgId, direction));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    private CursorResult<ChatMessage> fetchHistoryMessages(String conversationId, Conversation.ConversationType type, int pageSize, String cursor, FetchMessageOption option) throws ChatException {
        EMAError eMAError = new EMAError();
        CursorResult<EMAMessage> cursorResult = this.emaObject.fetchHistoryMessages(conversationId, type.ordinal(), pageSize, cursor, option == null ? new EMAFetchMessageOption() : (EMAFetchMessageOption)option.emaObject, eMAError);
        this.handleError(eMAError);
        CursorResult<ChatMessage> cursorResult2 = new CursorResult<ChatMessage>();
        cursorResult2.setCursor(cursorResult.getCursor());
        ArrayList<ChatMessage> arrayList = new ArrayList<ChatMessage>();
        for (EMAMessage eMAMessage : (List)cursorResult.getData()) {
            arrayList.add(new ChatMessage(eMAMessage));
        }
        cursorResult2.setData(arrayList);
        return cursorResult2;
    }

    public void asyncFetchHistoryMessages(final String conversationId, final Conversation.ConversationType type, final int pageSize, final String cursor, final FetchMessageOption option, final ValueCallBack<CursorResult<ChatMessage>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatManager.this.fetchHistoryMessages(conversationId, type, pageSize, cursor, option));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    private void handleError(EMAError error) throws ChatException {
        if (error.errCode() != 0) {
            throw new ChatException(error);
        }
    }

    public List<ChatMessage> searchMsgFromDB(ChatMessage.Type type, long timeStamp, int maxCount, String from, Conversation.SearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == Conversation.SearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = this.emaObject.searchMessages(type.ordinal(), timeStamp, maxCount, from, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((ChatMessage)new ChatMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<ChatMessage> searchMsgFromDB(String keywords, long timeStamp, int maxCount, String from, Conversation.SearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == Conversation.SearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = this.emaObject.searchMessages(keywords, timeStamp, maxCount, from, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((ChatMessage)new ChatMessage(eMAMessage));
        }
        return abstractList;
    }

    public void deleteMessagesBeforeTimestamp(final long timeStamp, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                boolean bl = ChatManager.this.emaObject.removeMessagesBeforeTimestamp(timeStamp);
                if (bl) {
                    for (Conversation.MessageCache messageCache : ChatManager.this.caches.values()) {
                        for (ChatMessage chatMessage : messageCache.getAllMessages()) {
                            if (chatMessage.getMsgTime() >= timeStamp) continue;
                            messageCache.removeMessage(chatMessage.getMsgId());
                        }
                    }
                    callback.onSuccess();
                } else {
                    callback.onError(3, "Database operation failed");
                }
            }
        });
    }

    public void asyncReportMessage(final String msgId, final String tag, final String reportReason, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatManager.this.reportMessage(msgId, tag, reportReason);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void reportMessage(String msgId, String tag, String reportReason) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.reportMessage(msgId, tag, reportReason, eMAError);
        this.handleError(eMAError);
    }

    public void fetchSupportLanguages(final ValueCallBack<List<Language>> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<Language> arrayList = new ArrayList<Language>();
                    EMAError eMAError = new EMAError();
                    List<List<String>> list = ChatManager.this.emaObject.fetchSupportLanguages(eMAError);
                    ChatManager.this.handleError(eMAError);
                    for (List<String> list2 : list) {
                        arrayList.add(new Language(list2.get(0), list2.get(1), list2.get(2)));
                    }
                    callBack.onSuccess(arrayList);
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void translateMessage(final ChatMessage message, final List<String> languages, final ValueCallBack<ChatMessage> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAMessage eMAMessage = ChatManager.this.emaObject.translateMessage((EMAMessage)message.emaObject, languages, eMAError);
                    ChatManager.this.handleError(eMAError);
                    callBack.onSuccess(new ChatMessage(eMAMessage));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void addReaction(String messageId, String reaction) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaReactionObject.addReaction(messageId, reaction, eMAError);
        this.handleError(eMAError);
    }

    public void asyncAddReaction(String messageId, String reaction, CallBack callback) {
        ChatClient.getInstance().execute(() -> {
            block3: {
                try {
                    this.addReaction(messageId, reaction);
                    if (null != callback) {
                        callback.onSuccess();
                    }
                }
                catch (ChatException chatException) {
                    EMLog.e(TAG, "asyncAddReaction error code:" + chatException.getErrorCode() + ",error message:" + chatException.getDescription());
                    if (null == callback) break block3;
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void removeReaction(String messageId, String reaction) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaReactionObject.removeReaction(messageId, reaction, eMAError);
        this.handleError(eMAError);
    }

    public void asyncRemoveReaction(String messageId, String reaction, CallBack callback) {
        ChatClient.getInstance().execute(() -> {
            block3: {
                try {
                    this.removeReaction(messageId, reaction);
                    if (null != callback) {
                        callback.onSuccess();
                    }
                }
                catch (ChatException chatException) {
                    EMLog.e(TAG, "asyncRemoveReaction error code:" + chatException.getErrorCode() + ",error message:" + chatException.getDescription());
                    if (null == callback) break block3;
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public Map<String, List<MessageReaction>> getReactionList(List<String> messageIdList, ChatMessage.ChatType chatType, String groupId) throws ChatException {
        EMAError eMAError = new EMAError();
        String string = "chat";
        if (ChatMessage.ChatType.Chat == chatType) {
            string = "chat";
        } else if (ChatMessage.ChatType.GroupChat == chatType) {
            string = "groupchat";
        }
        Map<String, List<EMAMessageReaction>> map = this.emaReactionObject.getReactionList(messageIdList, string, groupId, eMAError);
        this.handleError(eMAError);
        HashMap<String, List<MessageReaction>> hashMap = new HashMap<String, List<MessageReaction>>(map.size());
        if (map.size() > 0) {
            for (Map.Entry<String, List<EMAMessageReaction>> entry : map.entrySet()) {
                ArrayList<MessageReaction> arrayList = new ArrayList<MessageReaction>(entry.getValue().size());
                for (EMAMessageReaction eMAMessageReaction : entry.getValue()) {
                    if (null == eMAMessageReaction) continue;
                    arrayList.add(new MessageReaction(eMAMessageReaction));
                }
                hashMap.put(entry.getKey(), arrayList);
            }
        }
        return hashMap;
    }

    public void asyncGetReactionList(List<String> messageIdList, ChatMessage.ChatType chatType, String groupId, ValueCallBack<Map<String, List<MessageReaction>>> callback) {
        ChatClient.getInstance().execute(() -> {
            try {
                if (null != callback) {
                    callback.onSuccess(this.getReactionList(messageIdList, chatType, groupId));
                }
            }
            catch (ChatException chatException) {
                EMLog.e(TAG, "asyncGetReactionList error code:" + chatException.getErrorCode() + ",error message:" + chatException.getDescription());
                callback.onError(chatException.getErrorCode(), chatException.getDescription());
            }
        });
    }

    public CursorResult<MessageReaction> getReactionDetail(String messageId, String reaction, String cursor, int pageSize) throws ChatException {
        EMAError eMAError = new EMAError();
        CursorResult<EMAMessageReaction> cursorResult = this.emaReactionObject.getReactionDetail(messageId, reaction, cursor, pageSize, eMAError);
        this.handleError(eMAError);
        CursorResult<MessageReaction> cursorResult2 = new CursorResult<MessageReaction>();
        cursorResult2.setCursor(cursorResult.getCursor());
        if (null != cursorResult.getData()) {
            ArrayList<MessageReaction> arrayList = new ArrayList<MessageReaction>(((List)cursorResult.getData()).size());
            for (EMAMessageReaction eMAMessageReaction : (List)cursorResult.getData()) {
                if (null == eMAMessageReaction) continue;
                arrayList.add(new MessageReaction(eMAMessageReaction));
            }
            cursorResult2.setData(arrayList);
        }
        return cursorResult2;
    }

    public void asyncGetReactionDetail(String messageId, String reaction, String cursor, int pageSize, ValueCallBack<CursorResult<MessageReaction>> callback) {
        ChatClient.getInstance().execute(() -> {
            try {
                if (null != callback) {
                    callback.onSuccess(this.getReactionDetail(messageId, reaction, cursor, pageSize));
                }
            }
            catch (ChatException chatException) {
                EMLog.e(TAG, "asyncGetReactionDetail error code:" + chatException.getErrorCode() + ",error message:" + chatException.getDescription());
                callback.onError(chatException.getErrorCode(), chatException.getDescription());
            }
        });
    }

    protected void removeMessagesFromServer(final String conversationId, final Conversation.ConversationType type, final List<String> msgIdList, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = ChatManager.this.emaObject.deleteRoamMsgFromServerById(conversationId, type, msgIdList);
                if (eMAError.errCode() == 0) {
                    ChatManager.this.clearCaches(conversationId, msgIdList);
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                } else if (callBack != null) {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    protected void removeMessagesFromServer(final String conversationId, final Conversation.ConversationType type, final long beforeTimeStamp, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = ChatManager.this.emaObject.deleteRoamMsgFromServerByTime(conversationId, type, beforeTimeStamp);
                if (eMAError.errCode() == 0) {
                    ChatManager.this.clearCaches(conversationId, beforeTimeStamp);
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                } else if (callBack != null) {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    void clearCaches(String conversationId, long beforeTimeStamp) {
        if (this.caches.containsKey(conversationId) && this.caches.get(conversationId) != null && this.caches.get(conversationId).getAllMessages().size() > 0) {
            for (ChatMessage chatMessage : this.caches.get(conversationId).getAllMessages()) {
                if (chatMessage.getMsgTime() > beforeTimeStamp) continue;
                this.caches.get(conversationId).removeMessage(chatMessage.getMsgId());
            }
        }
    }

    void clearCaches(String conversationId, List<String> msgIdList) {
        if (msgIdList != null && msgIdList.size() > 0) {
            for (String string : msgIdList) {
                if (!this.caches.containsKey(conversationId) || this.caches.get(conversationId) == null) continue;
                this.caches.get(conversationId).removeMessage(string);
            }
        }
    }
}

