/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.http.X509TrustManagerExtensions;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import inner.com.getkeepsafe.relinker.ReLinker;
import io.agora.CallBack;
import io.agora.ChatLogListener;
import io.agora.ConnectionListener;
import io.agora.MultiDeviceListener;
import io.agora.ValueCallBack;
import io.agora.chat.ChatCheckType;
import io.agora.chat.ChatManager;
import io.agora.chat.ChatOptions;
import io.agora.chat.ChatRoomManager;
import io.agora.chat.ChatStatisticsManager;
import io.agora.chat.ChatThreadManager;
import io.agora.chat.ContactManager;
import io.agora.chat.Conversation;
import io.agora.chat.DeviceInfo;
import io.agora.chat.EMContact;
import io.agora.chat.EMEncryptProvider;
import io.agora.chat.EMLoginType;
import io.agora.chat.EMSessionManager;
import io.agora.chat.EMSmartHeartBeat;
import io.agora.chat.EMTimeTag;
import io.agora.chat.GroupManager;
import io.agora.chat.PresenceManager;
import io.agora.chat.PushManager;
import io.agora.chat.TranslationManager;
import io.agora.chat.UserInfoManager;
import io.agora.chat.adapter.EMAChatClient;
import io.agora.chat.adapter.EMAConnectionListener;
import io.agora.chat.adapter.EMADeviceInfo;
import io.agora.chat.adapter.EMAError;
import io.agora.chat.adapter.EMALogCallbackListener;
import io.agora.chat.adapter.EMAMultiDeviceListener;
import io.agora.chat.adapter.EMANetCallback;
import io.agora.chat.core.EMChatConfigPrivate;
import io.agora.chat.core.a;
import io.agora.cloud.EMHttpClient;
import io.agora.exceptions.ChatException;
import io.agora.notification.core.b;
import io.agora.push.PushConfig;
import io.agora.push.PushHelper;
import io.agora.push.PushType;
import io.agora.util.DeviceUuidFactory;
import io.agora.util.EMLog;
import io.agora.util.EasyUtils;
import io.agora.util.NetUtils;
import io.agora.util.PathUtil;
import io.agora.util.Utils;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import javax.net.ssl.X509TrustManager;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatClient {
    public static final String TAG = "ChatClient";
    private static ChatClient instance = null;
    static boolean libraryLoaded = false;
    private GroupManager groupManager;
    private ChatRoomManager chatroomManager;
    private ChatManager chatManager;
    private ContactManager contactManager;
    private UserInfoManager userInfoManager;
    private PushManager pushManager;
    private TranslationManager translationManager;
    private volatile PresenceManager presenceManager;
    private ChatThreadManager threadManager;
    private ChatStatisticsManager statisticsManager;
    private EMAChatClient emaObject;
    private Context mContext;
    private ExecutorService executor = null;
    private ExecutorService logQueue = Executors.newSingleThreadExecutor();
    private ExecutorService mainQueue = Executors.newSingleThreadExecutor();
    private ExecutorService sendQueue = Executors.newSingleThreadExecutor();
    private EMEncryptProvider encryptProvider = null;
    private boolean sdkInited = false;
    private EMChatConfigPrivate mChatConfigPrivate;
    private List<ConnectionListener> connectionListeners = Collections.synchronizedList(new ArrayList());
    private List<ChatLogListener> logListeners = Collections.synchronizedList(new ArrayList());
    private ClientLogListener clientLogListener;
    private MyConnectionListener connectionListener;
    private EMSmartHeartBeat smartHeartbeat = null;
    private List<MultiDeviceListener> multiDeviceListeners = Collections.synchronizedList(new ArrayList());
    private MyMultiDeviceListener multiDeviceListenerImpl;
    private PowerManager.WakeLock wakeLock;
    private ConnectivityManager connManager;
    private EMAChatClient.EMANetwork currentNetworkType = EMAChatClient.EMANetwork.NETWORK_NONE;
    private boolean mIsLoginWithAgoraToken = false;
    public static final String VERSION = "1.2.1";
    private BroadcastReceiver connectivityBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            EMAChatClient.EMANetwork eMANetwork;
            String string = intent.getAction();
            if (!string.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                EMLog.d(ChatClient.TAG, "skip no connectivity action");
                return;
            }
            EMLog.d(ChatClient.TAG, "connectivity receiver onReceiver");
            NetUtils.Types types = NetUtils.getNetworkTypes(ChatClient.this.getContext());
            switch (types) {
                case WIFI: 
                case OTHERS: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_WIFI;
                    break;
                }
                case MOBILE: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_MOBILE;
                    break;
                }
                case ETHERNET: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_CABLE;
                    break;
                }
                default: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_NONE;
                }
            }
            boolean bl = ChatClient.this.currentNetworkType != EMAChatClient.EMANetwork.NETWORK_NONE;
            boolean bl2 = eMANetwork != EMAChatClient.EMANetwork.NETWORK_NONE;
            ChatClient.this.currentNetworkType = eMANetwork;
            if (bl == bl2 && bl2) {
                ChatClient.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (ChatClient.this.smartHeartbeat != null) {
                            EMLog.i(ChatClient.TAG, "Network availability no change, just return. " + (Object)((Object)ChatClient.this.currentNetworkType) + ", but check ping");
                            ChatClient.this.smartHeartbeat.sendPingCheckConnection();
                        }
                    }
                });
                return;
            }
            EMLog.i(ChatClient.TAG, "Network availability changed, notify... " + (Object)((Object)ChatClient.this.currentNetworkType));
            ChatClient.this.execute(new Runnable(){

                @Override
                public void run() {
                    ChatClient.this.emaObject.onNetworkChanged(ChatClient.this.currentNetworkType);
                }
            });
        }
    };
    private AppStateListener appStateListener;
    private List<Activity> resumeActivityList = new ArrayList<Activity>();
    private boolean duringChecking = false;

    private ChatClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChatClient getInstance() {
        if (instance != null) return instance;
        Class<ChatClient> clazz = ChatClient.class;
        synchronized (ChatClient.class) {
            if (instance != null) return instance;
            instance = new ChatClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context, ChatOptions options) {
        if (this.sdkInited) {
            return;
        }
        this.executor = Executors.newCachedThreadPool();
        final EMTimeTag eMTimeTag = new EMTimeTag();
        eMTimeTag.start();
        this.mContext = context.getApplicationContext();
        this.connManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        this.registerActivityLifecycleCallbacks();
        this.loadLibrary();
        this.mChatConfigPrivate = new EMChatConfigPrivate();
        this.mChatConfigPrivate.a(this.mContext, options);
        options.setConfig(this.mChatConfigPrivate);
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(this.mContext);
        this.mChatConfigPrivate.f(deviceUuidFactory.getDeviceUuid().toString());
        String string = Build.MANUFACTURER + Build.MODEL;
        EMLog.e(TAG, "system device name :" + string);
        if (TextUtils.isEmpty((CharSequence)options.getCustomDeviceName())) {
            this.mChatConfigPrivate.i(string);
        }
        this.mChatConfigPrivate.g(this.getDidInfo());
        this.mChatConfigPrivate.h(UUID.randomUUID().toString());
        PushConfig pushConfig = options.getPushConfig();
        if (pushConfig == null) {
            pushConfig = new PushConfig.Builder(this.mContext).build();
        }
        PushConfig.Builder builder = new PushConfig.Builder(this.mContext, pushConfig);
        PushHelper.getInstance().init(this.mContext, builder.build());
        this.emaObject = EMAChatClient.create(this.mChatConfigPrivate.a);
        this.connectionListener = new MyConnectionListener();
        this.emaObject.addConnectionListener(this.connectionListener);
        this.multiDeviceListenerImpl = new MyMultiDeviceListener();
        this.emaObject.addMultiDeviceListener(this.multiDeviceListenerImpl);
        this.initManagers();
        this.mIsLoginWithAgoraToken = EMSessionManager.getInstance().getIsLoginWithAgoraToken();
        final String string2 = EMSessionManager.getInstance().getLastLoginUser();
        EMLog.e(TAG, "is autoLogin : " + options.getAutoLogin());
        EMLog.e(TAG, "lastLoginUser : " + string2);
        EMLog.e(TAG, "hyphenate SDK is initialized with version : " + this.getChatConfigPrivate().e());
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.wakeLock = powerManager.newWakeLock(1, "emclient");
        b.a().a(this.mContext);
        this.sdkInited = true;
        this.mContext.registerReceiver(this.connectivityBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.onNetworkChanged();
        if (options.getAutoLogin() && this.isLoggedInBefore()) {
            String string3 = EMSessionManager.getInstance().getLastLoginToken();
            String string4 = EMSessionManager.getInstance().getLastLoginPwd();
            EMSessionManager.getInstance().currentUser = new EMContact(string2);
            CallBack callBack = new CallBack(){

                @Override
                public void onSuccess() {
                    EMSessionManager.getInstance().currentUser = new EMContact(string2);
                    Log.d((String)ChatClient.TAG, (String)"hyphenate login onSuccess");
                    eMTimeTag.stop();
                    EMLog.d(ChatClient.TAG, "[Collector][sdk init]init time is : " + eMTimeTag.timeStr());
                }

                @Override
                public void onError(int code, String error) {
                    Log.d((String)ChatClient.TAG, (String)"hyphenate login onError");
                    eMTimeTag.stop();
                    EMLog.d(ChatClient.TAG, "[Collector][sdk init]init time is : " + eMTimeTag.timeStr());
                }

                @Override
                public void onProgress(int progress, String status) {
                }
            };
            this._login(string2, EMSessionManager.getInstance().isLastLoginWithToken() ? string3 : string4, callBack, true, EMSessionManager.getInstance().isLastLoginWithToken() ? EMLoginType.LOGIN_TOKEN : EMLoginType.LOGIN_PASSWORD);
        } else {
            eMTimeTag.stop();
            EMLog.d(TAG, "[Collector][sdk init]init time is : " + eMTimeTag.timeStr());
        }
    }

    private String getDidInfo() {
        String string = Build.MANUFACTURER;
        String string2 = Build.MODEL;
        String string3 = Build.HARDWARE;
        int n = Build.VERSION.SDK_INT;
        String string4 = Build.VERSION.RELEASE;
        String string5 = string + "/" + string2 + "/" + string3 + "/" + n + "/" + string4;
        return string5;
    }

    public void createAccount(String username, String password) throws ChatException {
        username = username.toLowerCase();
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9_.-]+$");
        boolean bl = pattern.matcher(username).find();
        if (!bl) {
            throw new ChatException(205, "illegal user name");
        }
        EMAError eMAError = this.emaObject.createAccount(username, password);
        this.handleError(eMAError);
    }

    public void login(String id, String password, @NonNull CallBack callback) {
        if (id == null || password == null || id.equals("") || password.equals("")) {
            callback.onError(110, "username or password is null or empty!");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.getChatConfigPrivate().k())) {
            callback.onError(110, "please setup your App Key  either in AndroidManifest.xml or through the ChatOptions");
            return;
        }
        if (!this.sdkInited) {
            callback.onError(1, "sdk not initialized");
            return;
        }
        id = id.toLowerCase();
        this.initLoginWithAgoraData(false, "", 0L);
        this._login(id, password, callback, false, EMLoginType.LOGIN_PASSWORD);
    }

    public void loginWithToken(String username, String token, @NonNull CallBack callback) {
        if (TextUtils.isEmpty((CharSequence)this.getChatConfigPrivate().k())) {
            callback.onError(110, "please setup your App Key  either in AndroidManifest.xml or through the ChatOptions");
            return;
        }
        if (username == null || token == null || username.equals("") || token.equals("")) {
            callback.onError(110, "username or token is null or empty!");
            return;
        }
        if (!this.sdkInited) {
            callback.onError(1, "sdk not initialized");
            return;
        }
        username = username.toLowerCase();
        this.initLoginWithAgoraData(false, "", 0L);
        this._login(username, token, callback, false, EMLoginType.LOGIN_TOKEN);
    }

    public void loginWithAgoraToken(String username, String agoraToken, @NonNull CallBack callback) {
        if (TextUtils.isEmpty((CharSequence)this.getChatConfigPrivate().k())) {
            callback.onError(110, "please setup your App Key  either in AndroidManifest.xml or through the ChatOptions");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)username) || TextUtils.isEmpty((CharSequence)agoraToken)) {
            callback.onError(110, "username or agoraToken is null or empty!");
            return;
        }
        if (!this.sdkInited) {
            callback.onError(1, "sdk not initialized");
            return;
        }
        this._login(username.toLowerCase(), agoraToken, callback, false, EMLoginType.LOGIN_AGORA_TOKEN);
    }

    private synchronized void getChatToken(String username, String agoraToken, CallBack callback) {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.getChatTokenbyAgoraToken(agoraToken, eMAError);
        if (eMAError.errCode() == 0) {
            EMLog.d(TAG, "getChatTokenbyAgoraToken success");
            if (string != null && string.length() > 0) {
                try {
                    JSONObject jSONObject = new JSONObject(string);
                    if (jSONObject != null) {
                        String string2 = jSONObject.optString("access_token");
                        String string3 = jSONObject.optString("expire_timestamp");
                        long l = Long.valueOf(string3) - System.currentTimeMillis();
                        if (TextUtils.isEmpty((CharSequence)string2)) {
                            throw new Exception("chatToken  is null or empty!");
                        }
                        this.initLoginWithAgoraData(true, string3, l);
                        this._login(username.toLowerCase(), string2, callback, false, EMLoginType.LOGIN_AGORA_TOKEN);
                    }
                }
                catch (Exception exception) {
                    EMLog.e(TAG, "getChatTokenbyAgoraToken Exception:" + exception.getMessage());
                    callback.onError(1, "getChatTokenbyAgoraToken Exception:" + exception.getMessage());
                }
            } else {
                EMLog.e(TAG, "getChatTokenbyAgoraToken response is null");
                callback.onError(1, "getChatTokenbyAgoraToken response is null or empty!");
            }
        } else {
            callback.onError(eMAError.errCode(), eMAError.errMsg());
            EMLog.e(TAG, "getChatTokenbyAgoraToken failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
        }
    }

    private void initLoginWithAgoraData(boolean isLoginWithAgoraToken, String expireTimestamp, long tokenAvailablePeriod) {
        this.mIsLoginWithAgoraToken = isLoginWithAgoraToken;
        if (isLoginWithAgoraToken) {
            EMSessionManager.getInstance().setLoginWithAgoraData(isLoginWithAgoraToken, expireTimestamp, tokenAvailablePeriod);
        } else {
            EMSessionManager.getInstance().clearLoginWithAgoraTokenData();
        }
    }

    public void notifyTokenExpired(String response) {
        if (this.connectionListener != null && this.mIsLoginWithAgoraToken) {
            try {
                JSONObject jSONObject = new JSONObject(response);
                if (jSONObject != null) {
                    String string = jSONObject.optString("error_description");
                    EMLog.e(TAG, "notifyTokenExpired--errorDescription:" + string);
                    if (string.contains("milliseconds ago") || string.contains("has expired") || string.contains("Unable to authenticate due to expired access Token")) {
                        this.connectionListener.onTokenNotification(401);
                        EMLog.e(TAG, "notifyTokenExpired--onTokenNotification(401) ");
                    }
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    public void renewToken(final String newAgoraToken) {
        if (this.mIsLoginWithAgoraToken && this.emaObject.isLoggedIn()) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    ChatClient.this.getChatToken(ChatClient.this.getCurrentUser(), newAgoraToken, new CallBack(){

                        @Override
                        public void onSuccess() {
                        }

                        @Override
                        public void onError(int code, String error) {
                        }

                        @Override
                        public void onProgress(int progress, String status) {
                        }
                    });
                }
            });
        } else {
            EMLog.e(TAG, "the method  excepted to be called when login by agoraToken and login state is loggeIn");
        }
    }

    public int logout(boolean unbindToken) {
        if (!this.emaObject.isLogout()) {
            String string = a.a().q();
            String string2 = a.a().r();
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
                try {
                    this.pushManager().unBindDeviceToken();
                }
                catch (Exception exception) {
                    return 212;
                }
            } else {
                boolean bl = PushHelper.getInstance().unregister(unbindToken);
                if (!bl) {
                    return 212;
                }
            }
        } else {
            PushHelper.getInstance().unregister(false);
            EMLog.e(TAG, "already logout, skip unbind token");
        }
        this.logout();
        return 0;
    }

    void logout() {
        EMLog.d(TAG, " SDK Logout");
        try {
            if (this.connectivityBroadcastReceiver != null) {
                this.mContext.unregisterReceiver(this.connectivityBroadcastReceiver);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EMSessionManager.getInstance().clearLastLoginUser();
        EMSessionManager.getInstance().clearLastLoginToken();
        EMSessionManager.getInstance().clearLoginWithAgoraTokenData();
        if (this.smartHeartbeat != null) {
            this.smartHeartbeat.stop();
        }
        this.releaseWakelock();
        if (this.emaObject != null) {
            this.emaObject.logout();
        }
        if (this.chatManager != null) {
            this.chatManager.onLogout();
        }
        if (this.groupManager != null) {
            this.groupManager.onLogout();
        }
        if (this.contactManager != null) {
            this.contactManager.onLogout();
        }
        if (this.chatroomManager != null) {
            this.chatroomManager.onLogout();
        }
        if (EMChatConfigPrivate.a()) {
            io.agora.a.a.c();
        }
    }

    public void logout(final boolean unbindToken, final CallBack callback) {
        new Thread(){

            @Override
            public void run() {
                int n = ChatClient.this.logout(unbindToken);
                if (n != 0) {
                    if (callback != null) {
                        callback.onError(n, "faild to unbind device token");
                    }
                } else if (callback != null) {
                    callback.onSuccess();
                }
            }
        }.start();
    }

    void logout(final CallBack callback) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (callback != null) {
                    callback.onProgress(0, null);
                }
                ChatClient.this.logout();
                if (callback != null) {
                    callback.onSuccess();
                }
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    public void changeAppkey(String appkey) throws ChatException {
        EMAError eMAError = this.emaObject.changeAppkey(appkey);
        if (eMAError.errCode() == 0) {
            this.getOptions().updatePath(appkey);
        }
        this.handleError(eMAError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(final ConnectionListener listener) {
        if (listener == null) {
            return;
        }
        List<ConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            if (!this.connectionListeners.contains(listener)) {
                this.connectionListeners.add(listener);
            }
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                if (ChatClient.this.isConnected()) {
                    listener.onConnected();
                } else if (ChatClient.this.isLoggedIn()) {
                    listener.onDisconnected(2);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener listener) {
        if (listener == null) {
            return;
        }
        List<ConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            this.connectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogListener(ChatLogListener listener) {
        if (listener == null) {
            return;
        }
        List<ChatLogListener> list = this.logListeners;
        synchronized (list) {
            if (!this.logListeners.contains(listener)) {
                this.logListeners.add(listener);
            }
        }
        if (this.clientLogListener == null) {
            this.clientLogListener = new ClientLogListener();
            this.emaObject.addLogCallbackListener(this.clientLogListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogListener(ChatLogListener listener) {
        if (listener == null) {
            return;
        }
        List<ChatLogListener> list = this.logListeners;
        synchronized (list) {
            this.logListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GroupManager groupManager() {
        if (this.groupManager != null) return this.groupManager;
        Class<ChatClient> clazz = ChatClient.class;
        synchronized (ChatClient.class) {
            if (this.groupManager != null) return this.groupManager;
            this.groupManager = new GroupManager(this, this.emaObject.getGroupManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.groupManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PushManager pushManager() {
        if (this.pushManager != null) return this.pushManager;
        Class<ChatClient> clazz = ChatClient.class;
        synchronized (ChatClient.class) {
            if (this.pushManager != null) return this.pushManager;
            this.pushManager = new PushManager(this, this.emaObject.getPushMnager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.pushManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChatRoomManager chatroomManager() {
        if (this.chatroomManager != null) return this.chatroomManager;
        Class<ChatClient> clazz = ChatClient.class;
        synchronized (ChatClient.class) {
            if (this.chatroomManager != null) return this.chatroomManager;
            this.chatroomManager = new ChatRoomManager(this, this.emaObject.getChatRoomManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.chatroomManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChatManager chatManager() {
        if (this.chatManager != null) return this.chatManager;
        Class<ChatClient> clazz = ChatClient.class;
        synchronized (ChatClient.class) {
            if (this.chatManager != null) return this.chatManager;
            this.chatManager = new ChatManager(this, this.emaObject.getChatManager(), this.emaObject.getReactionManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.chatManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UserInfoManager userInfoManager() {
        if (this.userInfoManager != null) return this.userInfoManager;
        Class<ChatClient> clazz = ChatClient.class;
        synchronized (ChatClient.class) {
            if (this.userInfoManager != null) return this.userInfoManager;
            this.userInfoManager = new UserInfoManager(this.emaObject.getUserInfoManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.userInfoManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ContactManager contactManager() {
        if (this.contactManager != null) return this.contactManager;
        Class<ChatClient> clazz = ChatClient.class;
        synchronized (ChatClient.class) {
            if (this.contactManager != null) return this.contactManager;
            this.contactManager = new ContactManager(this, this.emaObject.getContactManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.contactManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TranslationManager translationManager() {
        if (this.translationManager != null) return this.translationManager;
        Class<ChatClient> clazz = ChatClient.class;
        synchronized (ChatClient.class) {
            if (this.translationManager != null) return this.translationManager;
            this.translationManager = new TranslationManager(this.emaObject.getTranslateManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.translationManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PresenceManager presenceManager() {
        if (this.presenceManager != null) return this.presenceManager;
        Class<ChatClient> clazz = ChatClient.class;
        synchronized (ChatClient.class) {
            if (this.presenceManager != null) return this.presenceManager;
            this.presenceManager = new PresenceManager(this.emaObject.getPresenceManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.presenceManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChatThreadManager chatThreadManager() {
        if (this.threadManager != null) return this.threadManager;
        Class<ChatClient> clazz = ChatClient.class;
        synchronized (ChatClient.class) {
            if (this.threadManager != null) return this.threadManager;
            this.threadManager = new ChatThreadManager(this, this.emaObject.getThreadManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.threadManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChatStatisticsManager statisticsManager() {
        if (this.statisticsManager != null) return this.statisticsManager;
        Class<ChatClient> clazz = ChatClient.class;
        synchronized (ChatClient.class) {
            if (this.statisticsManager != null) return this.statisticsManager;
            this.statisticsManager = new ChatStatisticsManager(this, this.emaObject.getStatisticsManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.statisticsManager;
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public synchronized String getCurrentUser() {
        if (EMSessionManager.getInstance().currentUser == null || EMSessionManager.getInstance().currentUser.username == null || EMSessionManager.getInstance().currentUser.username.equals("")) {
            return EMSessionManager.getInstance().getLastLoginUser();
        }
        return EMSessionManager.getInstance().currentUser.username;
    }

    public void getUserTokenFromServer(final String username, final String password, final ValueCallBack<String> callBack) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                String string = ChatClient.this.emaObject.getUserTokenFromServer(username, password, eMAError);
                if (callBack == null) {
                    return;
                }
                if (eMAError.errCode() == 0) {
                    callBack.onSuccess(string);
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public boolean isLoggedInBefore() {
        EMSessionManager eMSessionManager = EMSessionManager.getInstance();
        String string = eMSessionManager.getLastLoginUser();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string2 = eMSessionManager.getLastLoginPwd();
        String string3 = eMSessionManager.getLastLoginToken();
        return string != null && !string.isEmpty() && (string2 != null && !string2.isEmpty() || string3 != null && !string3.isEmpty());
    }

    public boolean isConnected() {
        return this.emaObject.isConnected();
    }

    public boolean isLoggedIn() {
        return this.emaObject.isLoggedIn();
    }

    public void setDebugMode(boolean debugMode) {
        EMLog.debugMode = debugMode;
        this.getChatConfigPrivate().c(debugMode);
    }

    public void uploadLog(CallBack callback) {
        this.chatManager().emaObject.uploadLog();
    }

    public ChatOptions getOptions() {
        return this.mChatConfigPrivate.b();
    }

    public String compressLogs() throws ChatException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.compressLogs(eMAError);
        this.handleError(eMAError);
        return string;
    }

    public void addMultiDeviceListener(MultiDeviceListener listener) {
        this.multiDeviceListeners.add(listener);
    }

    public void removeMultiDeviceListener(MultiDeviceListener listener) {
        this.multiDeviceListeners.remove(listener);
    }

    public List<DeviceInfo> getLoggedInDevicesFromServer(String username, String password) throws ChatException {
        EMAError eMAError = new EMAError();
        List<EMADeviceInfo> list = this.emaObject.getLoggedInDevicesFromServer(username, password, eMAError);
        this.handleError(eMAError);
        ArrayList<DeviceInfo> arrayList = new ArrayList<DeviceInfo>();
        for (EMADeviceInfo eMADeviceInfo : list) {
            arrayList.add(new DeviceInfo(eMADeviceInfo));
        }
        return arrayList;
    }

    public List<DeviceInfo> getLoggedInDevicesFromServerWithToken(@NonNull String username, @NonNull String token) throws ChatException {
        EMAError eMAError = new EMAError();
        List<EMADeviceInfo> list = this.emaObject.getLoggedInDevicesFromServerWithToken(username, token, eMAError);
        this.handleError(eMAError);
        ArrayList<DeviceInfo> arrayList = new ArrayList<DeviceInfo>();
        for (EMADeviceInfo eMADeviceInfo : list) {
            arrayList.add(new DeviceInfo(eMADeviceInfo));
        }
        return arrayList;
    }

    public void kickDevice(String username, String password, String resource) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.kickDevice(username, password, resource, eMAError);
        this.handleError(eMAError);
    }

    public void kickDeviceWithToken(@NonNull String username, @NonNull String token, String resource) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.kickDeviceWithToken(username, token, resource, eMAError);
        this.handleError(eMAError);
    }

    public void kickAllDevices(String username, String password) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.kickAllDevices(username, password, eMAError);
        this.handleError(eMAError);
    }

    public void kickAllDevicesWithToken(@NonNull String username, @NonNull String token) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.kickAllDevicesWithToken(username, token, eMAError);
        this.handleError(eMAError);
    }

    public void sendFCMTokenToServer(String fcmToken) {
        EMLog.d(TAG, "sendFCMTokenToServer: " + fcmToken);
        if (TextUtils.isEmpty((CharSequence)fcmToken)) {
            return;
        }
        String string = this.getCurrentUser();
        if (TextUtils.isEmpty((CharSequence)string)) {
            EMLog.i(TAG, "No user login currently, stop upload the token.");
            return;
        }
        PushType pushType = PushHelper.getInstance().getPushType();
        EMLog.i(TAG, "pushType: " + (Object)((Object)pushType));
        if (pushType == PushType.FCM) {
            PushHelper.getInstance().onReceiveToken(pushType, fcmToken);
        }
    }

    public void sendHMSPushTokenToServer(String token) {
        if (PushHelper.getInstance().getPushType() == PushType.HMSPUSH) {
            PushHelper.getInstance().onReceiveToken(PushType.HMSPUSH, token);
        }
    }

    public void sendHonorPushTokenToServer(String token) {
        if (PushHelper.getInstance().getPushType() == PushType.HONORPUSH) {
            PushHelper.getInstance().onReceiveToken(PushType.HONORPUSH, token);
        }
    }

    private void initManagers() {
        EMHttpClient.getInstance().onInit(this.mChatConfigPrivate);
        this.chatManager();
        this.contactManager();
        this.groupManager();
        this.chatroomManager();
        this.presenceManager();
        this.chatThreadManager();
        this.setNatvieNetworkCallback();
        EMSessionManager.getInstance().init(this, this.emaObject.getSessionManager());
    }

    void _login(final String username, final String code, final CallBack callback, final boolean autoLogin, final EMLoginType loginType) {
        if (this.getChatConfigPrivate() == null || !this.sdkInited) {
            callback.onError(1, "");
            return;
        }
        EMLog.e(TAG, "emchat manager login in process:" + Process.myPid());
        this.execute(new Runnable(){

            @Override
            public void run() {
                EMLog.e(ChatClient.TAG, "emchat manager login in process:" + Process.myPid() + " threadName:" + Thread.currentThread().getName() + " ID:" + Thread.currentThread().getId());
                if (username == null) {
                    callback.onError(101, "Invalid user name");
                    return;
                }
                EMAError eMAError = new EMAError();
                ChatClient.this.emaObject.login(username, code, autoLogin, loginType.ordinal(), eMAError);
                if (eMAError.errCode() == 0) {
                    EMSessionManager.getInstance().setLastLoginUser(username);
                    if (loginType == EMLoginType.LOGIN_TOKEN || loginType == EMLoginType.LOGIN_AGORA_TOKEN) {
                        ChatClient.this.saveToken();
                    } else {
                        EMSessionManager.getInstance().setLastLoginPwd(code);
                        EMSessionManager.getInstance().setLastLoginWithToken(false);
                        EMSessionManager.getInstance().clearLastLoginToken();
                    }
                    if (autoLogin) {
                        ChatClient.this.loadDataFromDb();
                    }
                    ChatClient.this.onNewLogin();
                    PushHelper.getInstance().register();
                    callback.onSuccess();
                } else {
                    callback.onError(eMAError.errCode(), eMAError.errMsg());
                    if (eMAError.errCode() == 200 && ChatClient.this.mIsLoginWithAgoraToken) {
                        ChatClient.this.emaObject.renewToken(code);
                        EMSessionManager.getInstance().setLastLoginToken(code);
                        EMSessionManager.getInstance().startCountDownTokenAvailableTime(ChatClient.this.connectionListener);
                    }
                }
                if (eMAError.errCode() == 202) {
                    EMSessionManager.getInstance().clearLastLoginPwd();
                    EMSessionManager.getInstance().clearLastLoginToken();
                }
            }
        });
    }

    private void loadDataFromDb() {
        this.execute(() -> {
            this.groupManager().loadAllGroups();
            this.chatManager().loadAllConversationsFromDB();
        });
    }

    private void saveToken() {
        if (this.emaObject == null) {
            return;
        }
        EMAError eMAError = new EMAError();
        String string = this.emaObject.getUserToken(false, eMAError);
        if (eMAError.errCode() == 0) {
            EMSessionManager.getInstance().setLastLoginToken(string);
            EMSessionManager.getInstance().setLastLoginWithToken(true);
            EMSessionManager.getInstance().clearLastLoginPwd();
            if (this.mIsLoginWithAgoraToken) {
                EMSessionManager.getInstance().startCountDownTokenAvailableTime(this.connectionListener);
            }
        }
    }

    public boolean isFCMAvailable() {
        return PushHelper.getInstance().getPushType() == PushType.FCM;
    }

    void onNewLogin() {
        EMLog.d(TAG, "on new login created");
        String string = EMSessionManager.getInstance().getLastLoginUser();
        PathUtil.getInstance().initDirs(this.getChatConfigPrivate().k(), string, this.mContext);
        if (this.smartHeartbeat == null) {
            this.smartHeartbeat = EMSmartHeartBeat.create(this.mContext);
        }
        if (this.getChatConfigPrivate().a.hasHeartBeatCustomizedParams()) {
            this.smartHeartbeat.setCustomizedParams(this.getChatConfigPrivate().a.getWifiHeartBeatCustomizedParams(), this.getChatConfigPrivate().a.getMobileHeartBeatCustomizedParams());
        }
        this.smartHeartbeat.onInit();
        if (this.getOptions().getFixedInterval() != -1) {
            this.smartHeartbeat.setFixedInterval(this.getOptions().getFixedInterval());
        }
    }

    public String getAccessToken() {
        return this.getChatConfigPrivate().m();
    }

    public boolean isSdkInited() {
        return this.sdkInited;
    }

    private boolean _loadLibrary(String library, boolean trace) {
        try {
            ReLinker.loadLibrary(this.mContext, library);
            return true;
        }
        catch (Throwable throwable) {
            if (trace) {
                throwable.printStackTrace();
            }
            return false;
        }
    }

    private boolean _loadLibrary(String library) {
        return this._loadLibrary(library, true);
    }

    private void loadLibrary() {
        if (!libraryLoaded) {
            this._loadLibrary("cipherdb", false);
            ReLinker.loadLibrary(this.mContext, "agora-chat-sdk");
            libraryLoaded = true;
        }
    }

    void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    void executeOnMainQueue(Runnable runnable) {
        this.mainQueue.submit(runnable);
    }

    void executeOnSendQueue(Runnable runnable) {
        this.sendQueue.submit(runnable);
    }

    public EMChatConfigPrivate getChatConfigPrivate() {
        return this.mChatConfigPrivate;
    }

    void setNatvieNetworkCallback() {
        EMANetCallback eMANetCallback = new EMANetCallback(){

            @Override
            public int getNetState() {
                if (!NetUtils.hasDataConnection(ChatClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_NONE.ordinal();
                }
                if (NetUtils.isWifiConnected(ChatClient.this.mContext) || NetUtils.isOthersConnected(ChatClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_WIFI.ordinal();
                }
                if (NetUtils.isMobileConnected(ChatClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_MOBILE.ordinal();
                }
                if (NetUtils.isEthernetConnected(ChatClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_CABLE.ordinal();
                }
                return EMAChatClient.EMANetwork.NETWORK_NONE.ordinal();
            }
        };
        this.mChatConfigPrivate.a.setNetCallback(eMANetCallback);
    }

    void setEncryptProvider(EMEncryptProvider provider) {
        this.encryptProvider = provider;
    }

    EMEncryptProvider getEncryptProvider() {
        if (this.encryptProvider == null) {
            EMLog.d(TAG, "encrypt provider is not set, create default");
            this.encryptProvider = new EMEncryptProvider(){

                @Override
                public byte[] encrypt(byte[] input, String username) {
                    try {
                        String string = new String(input);
                        return ChatClient.this.emaObject.getSessionManager().encrypt(string).getBytes();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return input;
                    }
                }

                @Override
                public byte[] decrypt(byte[] input, String username) {
                    try {
                        String string = new String(input);
                        return ChatClient.this.emaObject.getSessionManager().decrypt(string).getBytes();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return input;
                    }
                }
            };
        }
        return this.encryptProvider;
    }

    boolean sendPing(boolean waitPong, long timeout) {
        return this.emaObject.sendPing(waitPong, timeout);
    }

    void checkTokenAvailability() {
        if (this.mIsLoginWithAgoraToken) {
            EMSessionManager.getInstance().checkTokenAvailability(this.connectionListener);
        }
    }

    void forceReconnect() {
        EMLog.d(TAG, "forceReconnect");
        this.disconnect();
        this.reconnect();
    }

    void reconnect() {
        EMLog.d(TAG, "reconnect");
        try {
            this.wakeLock.acquire();
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.getMessage());
        }
        this.emaObject.reconnect();
        this.releaseWakelock();
    }

    void disconnect() {
        EMLog.d(TAG, "disconnect");
        this.emaObject.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWakelock() {
        ChatClient chatClient = this;
        synchronized (chatClient) {
            if (this.wakeLock != null && this.wakeLock.isHeld()) {
                try {
                    this.wakeLock.release();
                }
                catch (Exception exception) {
                    EMLog.e(TAG, exception.getMessage());
                }
                EMLog.d(TAG, "released the wake lock");
            }
        }
    }

    private void handleError(EMAError error) throws ChatException {
        if (error.errCode() != 0) {
            throw new ChatException(error);
        }
    }

    void onNetworkChanged() {
        try {
            if (NetUtils.isWifiConnected(this.mContext) || NetUtils.isOthersConnected(this.mContext)) {
                EMLog.d(TAG, "has wifi connection");
                this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_WIFI;
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_WIFI);
                return;
            }
            if (NetUtils.isMobileConnected(this.mContext)) {
                EMLog.d(TAG, "has mobile connection");
                this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_MOBILE;
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_MOBILE);
                return;
            }
            if (NetUtils.isEthernetConnected(this.mContext)) {
                EMLog.d(TAG, "has ethernet connection");
                this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_CABLE;
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_CABLE);
                return;
            }
            this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_NONE;
            EMLog.d(TAG, "no data connection");
            this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_NONE);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void onNetworkChanged(EMAChatClient.EMANetwork network) {
        this.emaObject.onNetworkChanged(network);
    }

    void setAppStateListener(AppStateListener appStateListener) {
        this.appStateListener = appStateListener;
    }

    @TargetApi(value=14)
    private void registerActivityLifecycleCallbacks() {
        if (Utils.isSdk14()) {
            Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

                public void onActivityStopped(Activity activity) {
                    ChatClient.this.resumeActivityList.remove(activity);
                    if (ChatClient.this.resumeActivityList.isEmpty() && ChatClient.this.appStateListener != null) {
                        ChatClient.this.appStateListener.onBackground();
                    }
                }

                public void onActivityResumed(Activity activity) {
                }

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                }

                public void onActivityStarted(Activity activity) {
                    if (!ChatClient.this.resumeActivityList.contains(activity)) {
                        ChatClient.this.resumeActivityList.add(activity);
                        if (ChatClient.this.resumeActivityList.size() == 1 && ChatClient.this.appStateListener != null) {
                            ChatClient.this.appStateListener.onForeground();
                        }
                    }
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            };
            ((Application)this.mContext).registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
        }
    }

    public void check(String username, String password, CheckResultListener listener) {
        Object object;
        if (this.duringChecking) {
            EMLog.i("EMServiceChecker", "During service checking, please hold on...");
            return;
        }
        this.duringChecking = true;
        if (this.isLoggedInBefore()) {
            username = this.getCurrentUser();
            object = EMSessionManager.getInstance();
            password = ((EMSessionManager)object).getLastLoginPwd();
        }
        object = username;
        String string = password;
        new Thread(new Runnable((String)object, string, listener){
            final /* synthetic */ String val$finalUser;
            final /* synthetic */ String val$finalPwd;
            final /* synthetic */ CheckResultListener val$listener;
            {
                this.val$finalUser = string;
                this.val$finalPwd = string2;
                this.val$listener = checkResultListener;
            }

            @Override
            public void run() {
                ChatClient.this.emaObject.check(this.val$finalUser, this.val$finalPwd, new EMAChatClient.CheckResultListener(){

                    @Override
                    public void onResult(int type, int result, String desc) {
                        EMLog.i("EMServiceChecker", "type: " + type + ", result: " + result + ", desc: " + desc);
                        ChatClient.this.notifyCheckResult(val$listener, type, result, desc);
                        if (result != 0) {
                            ChatClient.this.duringChecking = false;
                            return;
                        }
                        if (type == 3) {
                            ChatClient.this.checkLogout(val$listener);
                        }
                    }
                });
            }
        }).start();
    }

    private void checkLogout(CheckResultListener listener) {
        if (!this.isLoggedInBefore()) {
            this.logout();
            this.notifyCheckResult(listener, 5, 0, "");
        }
        this.duringChecking = false;
    }

    private void notifyCheckResult(CheckResultListener listener, @ChatCheckType.CheckType int type, int result, String desc) {
        if (listener == null) {
            return;
        }
        listener.onResult(type, result, desc);
    }

    public static interface CheckResultListener {
        public void onResult(@ChatCheckType.CheckType int var1, int var2, String var3);
    }

    static interface AppStateListener {
        public void onForeground();

        public void onBackground();
    }

    class ClientLogListener
    extends EMALogCallbackListener {
        ClientLogListener() {
        }

        @Override
        public void onLogCallback(String log) {
            ChatClient.this.logQueue.submit(() -> {
                List list = ChatClient.this.logListeners;
                synchronized (list) {
                    for (ChatLogListener chatLogListener : ChatClient.this.logListeners) {
                        try {
                            chatLogListener.onLog(log);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    class MyMultiDeviceListener
    extends EMAMultiDeviceListener {
        MyMultiDeviceListener() {
        }

        @Override
        public void onContactEvent(final int event, final String target, final String ext) {
            EMLog.d(ChatClient.TAG, "onContactEvent:" + event + " target:" + target + " ext:" + ext);
            ChatClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = ChatClient.this.multiDeviceListeners;
                    synchronized (list) {
                        try {
                            for (MultiDeviceListener multiDeviceListener : ChatClient.this.multiDeviceListeners) {
                                multiDeviceListener.onContactEvent(event, target, ext);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onGroupEvent(final int event, final String target, final List<String> usernames) {
            EMLog.d(ChatClient.TAG, "onGroupEvent:" + event + " target:" + target + " usernames:" + usernames);
            ChatClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = ChatClient.this.multiDeviceListeners;
                    synchronized (list) {
                        try {
                            for (MultiDeviceListener multiDeviceListener : ChatClient.this.multiDeviceListeners) {
                                multiDeviceListener.onGroupEvent(event, target, usernames);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onRoamDeleteEvent(final String conversation, final List<String> msgIdList, final String deviceId, final long beforeTimeStamp) {
            EMLog.d(ChatClient.TAG, "onRoamDeleteEvent:" + conversation + " " + deviceId);
            if (TextUtils.isEmpty((CharSequence)conversation)) {
                return;
            }
            ChatClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = ChatClient.this.multiDeviceListeners;
                    synchronized (list) {
                        try {
                            if (msgIdList != null && msgIdList.size() > 0) {
                                ChatClient.this.chatManager.clearCaches(conversation, msgIdList);
                            } else {
                                ChatClient.this.chatManager.clearCaches(conversation, beforeTimeStamp);
                            }
                            for (MultiDeviceListener multiDeviceListener : ChatClient.this.multiDeviceListeners) {
                                multiDeviceListener.onMessageRemoved(conversation, deviceId);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onThreadEvent(int event, String target, List<String> username) {
            EMLog.d(ChatClient.TAG, "onThreadEvent:" + event + " target:" + target + " usernames:" + username);
            ChatClient.this.execute(() -> {
                List list = ChatClient.this.multiDeviceListeners;
                synchronized (list) {
                    for (MultiDeviceListener multiDeviceListener : ChatClient.this.multiDeviceListeners) {
                        try {
                            multiDeviceListener.onChatThreadEvent(event, target, username);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onConversationEvent(int event, String conversationId, int type) {
            EMLog.d(ChatClient.TAG, "onConversationEvent: " + event + " conversationId: " + conversationId + " type: " + type);
            Conversation.ConversationType conversationType = type == Conversation.ConversationType.GroupChat.ordinal() ? Conversation.ConversationType.GroupChat : Conversation.ConversationType.Chat;
            ChatClient.this.execute(() -> {
                List list = ChatClient.this.multiDeviceListeners;
                synchronized (list) {
                    for (MultiDeviceListener multiDeviceListener : ChatClient.this.multiDeviceListeners) {
                        try {
                            multiDeviceListener.onConversationEvent(event, conversationId, conversationType);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    class MyConnectionListener
    extends EMAConnectionListener {
        MyConnectionListener() {
        }

        @Override
        public void onConnected() {
            ChatClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = ChatClient.this.connectionListeners;
                    synchronized (list) {
                        try {
                            for (ConnectionListener connectionListener : ChatClient.this.connectionListeners) {
                                connectionListener.onConnected();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onDisconnected(final int errCode, final String info) {
            EMLog.e(ChatClient.TAG, "onDisconnected errcode = " + errCode + ",info = " + info);
            ChatClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = ChatClient.this.connectionListeners;
                    synchronized (list) {
                        switch (errCode) {
                            case 207: {
                                EMSessionManager.getInstance().clearLastLoginUser();
                                EMSessionManager.getInstance().clearLastLoginToken();
                                EMSessionManager.getInstance().clearLastLoginPwd();
                                break;
                            }
                            case 8: 
                            case 206: 
                            case 213: 
                            case 214: 
                            case 216: 
                            case 217: 
                            case 220: 
                            case 305: {
                                EMSessionManager.getInstance().clearLastLoginToken();
                                EMSessionManager.getInstance().clearLastLoginPwd();
                                if (!ChatClient.this.isSdkInited()) break;
                                a.a().i("");
                                a.a().h("");
                            }
                        }
                        try {
                            for (ConnectionListener connectionListener : ChatClient.this.connectionListeners) {
                                connectionListener.onDisconnected(errCode);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (errCode == 206 || errCode == 207 || errCode == 213 || errCode == 220 || errCode == 305 || errCode == 214 || errCode == 216 || errCode == 217 || errCode == 8) {
                            for (ConnectionListener connectionListener : ChatClient.this.connectionListeners) {
                                try {
                                    connectionListener.onLogout(errCode, info);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                    }
                }
            });
        }

        @Override
        public boolean verifyServerCert(List<String> certschain, String domain) {
            if (certschain == null) {
                EMLog.d(ChatClient.TAG, "List<String> certschain : null ");
                return false;
            }
            if (TextUtils.isEmpty((CharSequence)domain)) {
                EMLog.d(ChatClient.TAG, "domain is empty or null ");
                return false;
            }
            EMLog.d(ChatClient.TAG, "domain = " + domain);
            X509Certificate[] x509CertificateArray = EasyUtils.convertToCerts(certschain);
            try {
                X509TrustManager x509TrustManager = EasyUtils.getSystemDefaultTrustManager();
                X509TrustManagerExtensions x509TrustManagerExtensions = new X509TrustManagerExtensions(x509TrustManager);
                x509TrustManagerExtensions.checkServerTrusted(x509CertificateArray, x509CertificateArray[0].getType(), domain);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                EMLog.e(ChatClient.TAG, exception.getMessage());
                EMLog.d(ChatClient.TAG, "List<String> certschain :" + certschain.toString());
                return false;
            }
            return true;
        }

        @Override
        public void onTokenNotification(final int code) {
            ChatClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = ChatClient.this.connectionListeners;
                    synchronized (list) {
                        try {
                            if (code == 108 || code == 401) {
                                ChatClient.this.logout();
                                for (ConnectionListener connectionListener : ChatClient.this.connectionListeners) {
                                    EMLog.d(ChatClient.TAG, "MyConnectionListener onTokenExpired code: " + code);
                                    connectionListener.onTokenExpired();
                                }
                            } else {
                                for (ConnectionListener connectionListener : ChatClient.this.connectionListeners) {
                                    EMLog.d(ChatClient.TAG, "MyConnectionListener onTokenWillExpire code: " + code);
                                    connectionListener.onTokenWillExpire();
                                }
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            EMLog.e(ChatClient.TAG, "MyConnectionListener onTokenNotification Exception: " + exception.getMessage());
                        }
                    }
                }
            });
        }

        @Override
        public void onReceiveToken(String token, long expireTimestamp) {
            if (TextUtils.isEmpty((CharSequence)token) || expireTimestamp <= 0L) {
                EMLog.e(ChatClient.TAG, "onReceiveToken: params received is invalid");
                return;
            }
            long l = expireTimestamp - System.currentTimeMillis();
            ChatClient.this.initLoginWithAgoraData(true, String.valueOf(expireTimestamp), l);
            ChatClient.this.saveToken();
        }

        @Override
        public void onDatabaseOpened(int errCode) {
            EMLog.e(ChatClient.TAG, "onDatabaseOpened: errCode: " + errCode);
        }
    }
}

