package io.agora.push.platform.meizu;

import android.content.Context;
import android.util.Log;

import io.agora.push.PushHelper;
import io.agora.push.PushType;
import com.meizu.cloud.pushsdk.MzPushMessageReceiver;
import com.meizu.cloud.pushsdk.handler.MzPushMessage;
import com.meizu.cloud.pushsdk.platform.message.PushSwitchStatus;
import com.meizu.cloud.pushsdk.platform.message.RegisterStatus;
import com.meizu.cloud.pushsdk.platform.message.SubAliasStatus;
import com.meizu.cloud.pushsdk.platform.message.SubTagsStatus;
import com.meizu.cloud.pushsdk.platform.message.UnRegisterStatus;

public class MzMsgReceiver extends MzPushMessageReceiver {
    @Override
    public void onRegister(Context context, String s) {
    }

    @Override
    public void onUnRegister(Context context, boolean b) {
    }

    @Override
    public void onPushStatus(Context context, PushSwitchStatus pushSwitchStatus) {
    }

    @Override
    public void onRegisterStatus(Context context, RegisterStatus registerStatus) {
        // 20190218：咨询魅族推送客服人员得知，该pushId有过期时间，若30天内未收到魅族任何推送信息则该Id过期，
        // 需要重新#register()获取新的Id，目前sdk内部无法知道Id过期事件。
        String pushId = registerStatus.getPushId();
        Log.i("MeizuPush", "pushId: " + pushId);
        // upload pushId to hyphenate server.
        PushHelper.getInstance().onReceiveToken(PushType.MEIZUPUSH, pushId);
    }

    @Override
    public void onUnRegisterStatus(Context context, UnRegisterStatus unRegisterStatus) {
    }

    @Override
    public void onSubTagsStatus(Context context, SubTagsStatus subTagsStatus) {
    }

    @Override
    public void onSubAliasStatus(Context context, SubAliasStatus subAliasStatus) {
    }

    @Override
    public void onNotificationClicked(Context context, MzPushMessage
            mzPushMessage) {
        //通知栏消息点击回调
        Log.i("MeizuPush", "onNotificationClicked: " + mzPushMessage.toString());
    }

    @Override
    public void onNotificationDeleted(Context context, MzPushMessage
            mzPushMessage) {
        //通知栏消息删除回调；flyme6 基于 android6.0 以上不再回调
        Log.i("MeizuPush", "onNotificationDeleted: " + mzPushMessage.toString());
    }
}
