package io.agora.notification;

import android.os.Parcel;
import android.os.Parcelable;

public class EMNotificationMessage implements Parcelable {

    /**
     * \~english
     * Push the title
     *
     */
    String notificationTitle;

    /**
     * \~english
     * Push the content
     *
     */
    String notificationContent;

    /**
     * \~english
     * Push type
     *
     */
    int notificationStyle;

    /**
     * \~english
     * Push icon URL
     *
     */
    String notificationIconUrl;

    /**
     * \~english
     * Push large image URL
     *
     */
    String notificationBigPicPath;

    /**
     * \~english
     * Push long text
     *
     */
    String notificationBigText;

    /**
     * \~english
     * Notification Channel ID
     *
     */
    String notificationChannelId;

    /**
     * \~english
     * Notification Channel Name
     *
     */
    String notificationChannelName;

    /**
     * \~english
     * Notify the level
     *
     */
    int notificationChannelLevel;

    /**
     * \~english
     * Notification ID
     *
     */
    int notificationNotifyId;

    /**
     * \~english
     * Notification type
     *
     */
    boolean notificationAutoClear;

    /**
     * \~english
     * Notification sound
     *
     */
    boolean notificationSound;

    /**
     * \~english
     * Notification vibration
     *
     */
    boolean notificationVibrate;

    /**
     * \~english
     * Notice of expiration
     *
     */
    long notificationExpiresTime;

    /**
     * \~english
     * Cancellation time
     *
     */
    long notificationCancelTime;

    /**
     * \~english
     * Push click type
     *
     */
    int openType;

    /**
     * \~english
     * Push click url
     *
     */
    String openUrl;

    /**
     * \~english
     * Push click action
     *
     */
    String openAction;

    /**
     * \~english
     * Push click activity
     *
     */
    String openActivity;

    /**
     * \~english
     * Push additional field
     *
     */
    String extras;

    /**
     * \~english
     * Push autoincrement number
     *
     */
    int badgeAdd;

    /**
     * \~english
     * Push coverage horn number
     *
     */
    int badgeSet;

    /**
     * \~english
     * App start page (for Huawei badge)
     *
     */
    String badgeClass;

    /**
     * \~english
     * Whether or not notice of
     * true：Notification Message
     * false：Command Message
     *
     */
    boolean needNotification;

    @Override
    public String toString() {
        return "EMNotificationMessage{" +
                "notificationTitle='" + notificationTitle + '\'' +
                ", notificationContent='" + notificationContent + '\'' +
                ", notificationStyle=" + notificationStyle +
                ", notificationIconUrl='" + notificationIconUrl + '\'' +
                ", notificationBigPicPath='" + notificationBigPicPath + '\'' +
                ", notificationBigText='" + notificationBigText + '\'' +
                ", notificationChannelId='" + notificationChannelId + '\'' +
                ", notificationChannelName='" + notificationChannelName + '\'' +
                ", notificationChannelLevel=" + notificationChannelLevel +
                ", notificationNotifyId=" + notificationNotifyId +
                ", notificationAutoClear=" + notificationAutoClear +
                ", notificationSound=" + notificationSound +
                ", notificationVibrate=" + notificationVibrate +
                ", notificationExpiresTime=" + notificationExpiresTime +
                ", notificationCancelTime=" + notificationCancelTime +
                ", openType=" + openType +
                ", openUrl='" + openUrl + '\'' +
                ", openAction='" + openAction + '\'' +
                ", openActivity='" + openActivity + '\'' +
                ", extras='" + extras + '\'' +
                ", badgeAdd=" + badgeAdd +
                ", badgeSet=" + badgeSet +
                ", badgeClass='" + badgeClass + '\'' +
                ", needNotification=" + needNotification +
                '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.notificationTitle);
        dest.writeString(this.notificationContent);
        dest.writeInt(this.notificationStyle);
        dest.writeString(this.notificationIconUrl);
        dest.writeString(this.notificationBigPicPath);
        dest.writeString(this.notificationBigText);
        dest.writeString(this.notificationChannelId);
        dest.writeString(this.notificationChannelName);
        dest.writeInt(this.notificationChannelLevel);
        dest.writeInt(this.notificationNotifyId);
        dest.writeByte(this.notificationAutoClear ? (byte) 1 : (byte) 0);
        dest.writeByte(this.notificationSound ? (byte) 1 : (byte) 0);
        dest.writeByte(this.notificationVibrate ? (byte) 1 : (byte) 0);
        dest.writeLong(this.notificationExpiresTime);
        dest.writeLong(this.notificationCancelTime);
        dest.writeInt(this.openType);
        dest.writeString(this.openUrl);
        dest.writeString(this.openAction);
        dest.writeString(this.openActivity);
        dest.writeString(this.extras);
        dest.writeInt(this.badgeAdd);
        dest.writeInt(this.badgeSet);
        dest.writeString(this.badgeClass);
        dest.writeByte(this.needNotification ? (byte) 1 : (byte) 0);
    }

    public void readFromParcel(Parcel source) {
        this.notificationTitle = source.readString();
        this.notificationContent = source.readString();
        this.notificationStyle = source.readInt();
        this.notificationIconUrl = source.readString();
        this.notificationBigPicPath = source.readString();
        this.notificationBigText = source.readString();
        this.notificationChannelId = source.readString();
        this.notificationChannelName = source.readString();
        this.notificationChannelLevel = source.readInt();
        this.notificationNotifyId = source.readInt();
        this.notificationAutoClear = source.readByte() != 0;
        this.notificationSound = source.readByte() != 0;
        this.notificationVibrate = source.readByte() != 0;
        this.notificationExpiresTime = source.readLong();
        this.notificationCancelTime = source.readLong();
        this.openType = source.readInt();
        this.openUrl = source.readString();
        this.openAction = source.readString();
        this.openActivity = source.readString();
        this.extras = source.readString();
        this.badgeAdd = source.readInt();
        this.badgeSet = source.readInt();
        this.badgeClass = source.readString();
        this.needNotification = source.readByte() != 0;
    }

    public EMNotificationMessage() {
    }

    protected EMNotificationMessage(Parcel in) {
        this.notificationTitle = in.readString();
        this.notificationContent = in.readString();
        this.notificationStyle = in.readInt();
        this.notificationIconUrl = in.readString();
        this.notificationBigPicPath = in.readString();
        this.notificationBigText = in.readString();
        this.notificationChannelId = in.readString();
        this.notificationChannelName = in.readString();
        this.notificationChannelLevel = in.readInt();
        this.notificationNotifyId = in.readInt();
        this.notificationAutoClear = in.readByte() != 0;
        this.notificationSound = in.readByte() != 0;
        this.notificationVibrate = in.readByte() != 0;
        this.notificationExpiresTime = in.readLong();
        this.notificationCancelTime = in.readLong();
        this.openType = in.readInt();
        this.openUrl = in.readString();
        this.openAction = in.readString();
        this.openActivity = in.readString();
        this.extras = in.readString();
        this.badgeAdd = in.readInt();
        this.badgeSet = in.readInt();
        this.badgeClass = in.readString();
        this.needNotification = in.readByte() != 0;
    }

    public static final Parcelable.Creator<EMNotificationMessage> CREATOR = new Parcelable.Creator<EMNotificationMessage>() {
        @Override
        public EMNotificationMessage createFromParcel(Parcel source) {
            return new EMNotificationMessage(source);
        }

        @Override
        public EMNotificationMessage[] newArray(int size) {
            return new EMNotificationMessage[size];
        }
    };

    public String getNotificationTitle() {
        return notificationTitle;
    }

    public void setNotificationTitle(String notificationTitle) {
        this.notificationTitle = notificationTitle;
    }

    public String getNotificationContent() {
        return notificationContent;
    }

    public void setNotificationContent(String notificationContent) {
        this.notificationContent = notificationContent;
    }

    public int getNotificationStyle() {
        return notificationStyle;
    }

    public void setNotificationStyle(int notificationStyle) {
        this.notificationStyle = notificationStyle;
    }

    public String getNotificationIconUrl() {
        return notificationIconUrl;
    }

    public void setNotificationIconUrl(String notificationIconUrl) {
        this.notificationIconUrl = notificationIconUrl;
    }

    public String getNotificationBigPicPath() {
        return notificationBigPicPath;
    }

    public void setNotificationBigPicPath(String notificationBigPicPath) {
        this.notificationBigPicPath = notificationBigPicPath;
    }

    public String getNotificationBigText() {
        return notificationBigText;
    }

    public void setNotificationBigText(String notificationBigText) {
        this.notificationBigText = notificationBigText;
    }

    public String getNotificationChannelId() {
        return notificationChannelId;
    }

    public void setNotificationChannelId(String notificationChannelId) {
        this.notificationChannelId = notificationChannelId;
    }

    public String getNotificationChannelName() {
        return notificationChannelName;
    }

    public void setNotificationChannelName(String notificationChannelName) {
        this.notificationChannelName = notificationChannelName;
    }

    public int getNotificationChannelLevel() {
        return notificationChannelLevel;
    }

    public void setNotificationChannelLevel(int notificationChannelLevel) {
        this.notificationChannelLevel = notificationChannelLevel;
    }

    public int getNotificationNotifyId() {
        return notificationNotifyId;
    }

    public void setNotificationNotifyId(int notificationNotifyId) {
        this.notificationNotifyId = notificationNotifyId;
    }

    public boolean isNotificationAutoClear() {
        return notificationAutoClear;
    }

    public void setNotificationAutoClear(boolean notificationAutoClear) {
        this.notificationAutoClear = notificationAutoClear;
    }

    public boolean isNotificationSound() {
        return notificationSound;
    }

    public void setNotificationSound(boolean notificationSound) {
        this.notificationSound = notificationSound;
    }

    public boolean isNotificationVibrate() {
        return notificationVibrate;
    }

    public void setNotificationVibrate(boolean notificationVibrate) {
        this.notificationVibrate = notificationVibrate;
    }

    public long getNotificationExpiresTime() {
        return notificationExpiresTime;
    }

    public void setNotificationExpiresTime(long notificationExpiresTime) {
        this.notificationExpiresTime = notificationExpiresTime;
    }

    public long getNotificationCancelTime() {
        return notificationCancelTime;
    }

    public void setNotificationCancelTime(long notificationCancelTime) {
        this.notificationCancelTime = notificationCancelTime;
    }

    public int getOpenType() {
        return openType;
    }

    public void setOpenType(int openType) {
        this.openType = openType;
    }

    public String getOpenUrl() {
        return openUrl;
    }

    public void setOpenUrl(String openUrl) {
        this.openUrl = openUrl;
    }

    public String getOpenAction() {
        return openAction;
    }

    public void setOpenAction(String openAction) {
        this.openAction = openAction;
    }

    public String getOpenActivity() {
        return openActivity;
    }

    public void setOpenActivity(String openActivity) {
        this.openActivity = openActivity;
    }

    public String getExtras() {
        return extras;
    }

    public void setExtras(String extras) {
        this.extras = extras;
    }

    public int getBadgeAdd() {
        return badgeAdd;
    }

    public void setBadgeAdd(int badgeAdd) {
        this.badgeAdd = badgeAdd;
    }

    public int getBadgeSet() {
        return badgeSet;
    }

    public void setBadgeSet(int badgeSet) {
        this.badgeSet = badgeSet;
    }

    public String getBadgeClass() {
        return badgeClass;
    }

    public void setBadgeClass(String badgeClass) {
        this.badgeClass = badgeClass;
    }

    public boolean isNeedNotification() {
        return needNotification;
    }

    public void setNeedNotification(boolean needNotification) {
        this.needNotification = needNotification;
    }
}
