package io.agora.chat;

import io.agora.chat.adapter.EMASilentModeTime;

/**
 * \~english
 * For offline push DND time class, you need to create the start time and end time together.
 *
 */
public class SilentModeTime extends EMBase<EMASilentModeTime> {

    public SilentModeTime(int hour, int minute){
        emaObject = new EMASilentModeTime(hour, minute);
    }

    public SilentModeTime(EMASilentModeTime time){
        emaObject = time;
    }

    /**
     * \~english
     * Set the number of hours to 24 hours.
     * @param hour Hours.
     */
    public void setHour(int hour){
        emaObject.setHour(hour);
    }

    /**
     * \~english
     * Get the number of hours in 24 hour format.
     * @return Number of hours.
     */
    public int getHour(){
        if(emaObject != null){
            return emaObject.getHour();
        }
        return 0;
    }

    /**
     * \~english
     * Set minutes.
     * @param minute Minutes.
     *
     */
    public void setMinute(int minute){
        emaObject.setMinute(minute);
    }

    /**
     * \~english
     * Get minutes.
     * @return minutes.
     *
     */
    public int getMinute(){
        if(emaObject != null) {
            return emaObject.getMinute();
        }
        return 0;
    }
}
