package io.agora.chat;

import io.agora.CallBack;
import io.agora.ValueCallBack;
import io.agora.chat.adapter.EMASilentModeItem;
import io.agora.chat.adapter.EMASilentModeTime;

/**
 * \~english
 * Offline push DND result class.
 */
public class SilentModeResult extends EMBase<EMASilentModeItem> {

    public SilentModeResult(EMASilentModeItem item){
        emaObject = item;
    }

    /**
     * \~english
     * Obtain the offline push DND expiration timestamp.
     * @return Do not Disturb expiration timestamp.
     */
    public long getExpireTimestamp(){
        return emaObject.getExpireTimestamp();
    }

    /**
     * \~english
     * Get the Conversation Type.
     * @return The Conversation Type.
     */
    public Conversation.ConversationType getConversationType(){
        return Conversation.ConversationType.values()[emaObject.getConversationType()];
    }

    /**
     * \~english
     * Get the Conversation ID.
     * @return The Conversation ID.
     */
    public String getConversationId(){
        return emaObject.getConversationId();
    }

    /**
     * \~english
     * Whether to enable offline push notification for the conversation.
     * After calling {@link PushManager#setSilentModeForConversation(String, Conversation.ConversationType, SilentModeParam, ValueCallBack)} set remind type, return true.
     * After calling {@link PushManager#clearRemindTypeForConversation(String, Conversation.ConversationType, CallBack)} clear remind type, return false.
     * @return boolean
     */
    public boolean isConversationRemindTypeEnabled(){
        return emaObject.getRemindType() != 0;
    }

    /**
     * \~english
     * Get the offline push notification type.
     * @return The offline push notification type.
     */
    public PushManager.PushRemindType getRemindType(){
        if(emaObject.getRemindType() != 0){
            return PushManager.PushRemindType.values()[emaObject.getRemindType() - 1];
        } else {
            return PushManager.PushRemindType.ALL;
        }
    }

    /**
     * \~english
     * Get the start time of offline push DND.
     * @return The start time.
     */
    public SilentModeTime getSilentModeStartTime(){
        EMASilentModeTime time = emaObject.getSilentModeStartTime();
        return new SilentModeTime(time);
    }

    /**
     * \~english
     * Get the end time of offline push DND.
     * @return The end time.
     */
    public SilentModeTime getSilentModeEndTime(){
        EMASilentModeTime time = emaObject.getSilentModeEndTime();
        return new SilentModeTime(time);
    }
}
