package io.agora.chat;

import io.agora.chat.adapter.EMAPresence;

import java.util.Map;

/**
 * \~english
 * The presence property class that contains presence properties, including the publisher's user ID and current presence state, and the platform used by the online device, as well as the presence's extension information, update time, and subscription expiration time.
 */
public class Presence extends EMBase<EMAPresence> {

    public Presence(EMAPresence emaPresence) {
        emaObject = emaPresence;
    }


    /**
     * \~english
     * @return The user ID of the presence publisher.
     */
    public String getPublisher() {
        return emaObject.getPublisher();
    }

    /**
     *\~english
     * @return The details of the current presence state.
     * key:The platform used by the current online device of the publisher, which can be "ios", "android", "linux", "windows", or "webim".
     * value:The current presence state of the publisher, 0 is offline, 1 is online.
     */
    public Map<String, Integer> getStatusList() {
        return emaObject.getStatusList();
    }

    /**
     * \~english
     * @return The presence extension information.
     */
    public String getExt() {
        return emaObject.getExt();
    }
    /**
     *  \~english
     *  @return The presence update time, which is generated by the server.
     */
    public long getLatestTime() {
        return emaObject.getLatestTime();
    }
    /**
     *  \~english
     * @return  The expiration time of the presence subscription.
     */
    public long getExpiryTime() {
        return emaObject.getExpiryTime();
    }

    @Override
    public String toString() {
        return "Presence{" +
                " \n publisher=" + getPublisher() +
                "，\n ext=" + getExt() +
                "，\n latesttime=" + getLatestTime() +
                "，\n expirytime=" + getExpiryTime() +
                "，\n statusList=" + getStatuListString(getStatusList()) +
                " }";
    }

    private String getStatuListString(Map<String, Integer> map) {
        String statu = "";
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            statu += "platform=" + entry.getKey() + ",value=" + entry.getValue() + "\n";
        }
        return statu;
    }

}
