/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package io.agora.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;

import io.agora.chat.adapter.message.EMAFileMessageBody;
import io.agora.util.FileHelper;
import io.agora.util.EMLog;

import java.io.File;

/**
 * \~english
 * The normal file message body.
 */
public class NormalFileMessageBody extends FileMessageBody implements Parcelable {

    /**
     * \~english
     * Creates a file message body by the file.
     * @param file The file instance.
     */
	public NormalFileMessageBody(File file){
		this(Uri.fromFile(file));
	}
	

    /**
     * \~english
     * Creates a file message body by the file Uri.
     * @param localPath The file Uri.
     */
	public NormalFileMessageBody(Uri localPath){
		super(localPath);
		((EMAFileMessageBody) emaObject).setDisplayName(FileHelper.getInstance().getFilename(localPath));
	}

	NormalFileMessageBody(String fileName, String remoteUrl){
		super(fileName);
		super.setRemoteUrl(remoteUrl);
		EMLog.d("NormalFileMessageBody", "filename = "+fileName);
    }
	
	NormalFileMessageBody(EMAFileMessageBody body) {
		super(body);
	}
	
	@Override
	public int describeContents() {
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeString(((EMAFileMessageBody)emaObject).displayName());
		dest.writeString(((EMAFileMessageBody)emaObject).getLocalUrl());
		dest.writeString(((EMAFileMessageBody)emaObject).getRemoteUrl());
		dest.writeLong(((EMAFileMessageBody)emaObject).fileLength());
		dest.writeString(((EMAFileMessageBody)emaObject).getSecret());
	}

	public static final Parcelable.Creator<NormalFileMessageBody> CREATOR = new Parcelable.Creator<NormalFileMessageBody>() {
		public NormalFileMessageBody createFromParcel(Parcel in) {
			return new NormalFileMessageBody(in);
		}

		public NormalFileMessageBody[] newArray(int size) {
			return new NormalFileMessageBody[size];
		}
	};
	
	public NormalFileMessageBody() {
		super("");
	}
	
	private NormalFileMessageBody(Parcel in) {
		super("");
		// members from FileMessageBody
		((EMAFileMessageBody)emaObject).setDisplayName(in.readString());
		((EMAFileMessageBody)emaObject).setLocalPath(in.readString());
		((EMAFileMessageBody)emaObject).setRemotePath(in.readString());
		((EMAFileMessageBody)emaObject).setFileLength(in.readLong());
		((EMAFileMessageBody)emaObject).setSecretKey(in.readString());

	}
	
	public String toString() {
		return "normal file:" + ((EMAFileMessageBody)emaObject).displayName() + ",localUrl:" + ((EMAFileMessageBody)emaObject).getLocalUrl() 
				+ ",remoteUrl:" + ((EMAFileMessageBody)emaObject).getRemoteUrl()
				+ ",file size:" + ((EMAFileMessageBody)emaObject).fileLength();
	}

	/**
	 * \~english
	 * Gets the size of the file.
	 * @return The size of the file.
	 */
	public long getFileSize() {
		return ((EMAFileMessageBody)emaObject).fileLength();
	}
		
}
