package io.agora.chat;


import io.agora.chat.adapter.EMAMessageReaction;
import io.agora.chat.adapter.EMAMessageReactionChange;
import io.agora.chat.adapter.EMAMessageReactionOperation;

import java.util.ArrayList;
import java.util.List;

/**
 * \~english
 * The message reaction change entity class, which has the following attributes:
 *
 *  ConversionID: The conversion ID.
 *  MessageId: The message ID.
 *  MessageReactionList: The list of Reactions.
 */
public class MessageReactionChange extends EMBase<EMAMessageReactionChange> {

    public MessageReactionChange(EMAMessageReactionChange reactionChange) {
        emaObject = reactionChange;
    }

    /**
     * \~english
     * Gets the conversion ID.
     * @return  The conversion ID.
     */
    public String getConversionID() {
        if (ChatClient.getInstance().getCurrentUser().equals(emaObject.getTo())) {
            return emaObject.getFrom();
        }
        return emaObject.getTo();
    }

    /**
     * \~english
     * Gets the message ID.
     * @return  The message ID.
     */
    public String getMessageId() {
        return emaObject.getMessageId();
    }

    /**
     * \~english
     * Gets the list of Reactions.
     * @return  The list of Reactions.
     */
    public List<MessageReaction> getMessageReactionList() {
        List<EMAMessageReaction> list = emaObject.getMessageReactionList();
        List<MessageReaction> messageReactionList = new ArrayList<>(list.size());
        for (EMAMessageReaction reaction : list) {
            messageReactionList.add(new MessageReaction(reaction));
        }
        return messageReactionList;
    }

    /**
     * \~english
     * Gets the list of Reaction operations.
     * @return  The list of Reaction operations.
     */
    public List<MessageReactionOperation> getOperations() {
        List<EMAMessageReactionOperation> operations = emaObject.getOperations();
        List<MessageReactionOperation> result = new ArrayList<>();
        if(operations == null || operations.isEmpty()) {
            return result;
        }
        for(int i = 0; i < operations.size(); i++) {
            MessageReactionOperation operation = new MessageReactionOperation(operations.get(i));
            result.add(operation);
        }
        return result;
    }

}