/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package io.agora.chat;

/**
 * \~english
 * The encryption and decryption class.
 * 
 * You can use built-in encryption and decryption alogrithms based on AES or build your own algorithms by usin EncryptProvider to encrypt or decrypt messages and attachments.
 * 
 * For example, encryption:
 * ```java
 *       EaseMobChat.getInstance().setEncryptionMode(true);
 *       EaseMobChat.getInstance().setEncryptProvider(new MyEncryptProvider());
 * ```
 * 
 * When sending a message, if EncryptProvider is configured, the SDK will call the encryption method to encrypt the message before delivery.
 * While receiving a message, if this message is encrypted, the SDK will call the EncryptProvider to decrypt it.
 * 
 */
interface EMEncryptProvider {
    
    /**
     * \~english
     * The encryption method.
     * 
     * @param input The byte array to be encrypted.
     * @param toUserName The user ID of the other side of the conversation.
     * @return Returns the encrypted byte array.
     */
    byte[] encrypt(byte[] input, String toUserName);
    
    /**
     * \~english
     * The decryption method.
     *
     * @param input The encrypted byte array.
     * @param fromUserName The username of the message sender.
     * 
     * @return Returns the decrypted byte array.
     * 
     */
    byte[] decrypt(byte[] input, String fromUserName);
    
}
