/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package io.agora.chat;

import android.os.Parcel;
import android.os.Parcelable;


/**
 * \~english
 * `EMContact` is the object of contact, and this is the base class.
 * 
 */
class EMContact implements Parcelable {
    
    /**
     * \~english
     * The username assigned from the app. It identifies the user and should be unique in the app.
     */
    protected String username;
    protected String nick;
    
	protected EMContact() {
    }
    
    /**
     * \~english
     * Creates the `EMContact` object from username.
     * @param username The user ID.
     */
    public EMContact(String username) {
    	this.username = username;
    }
    
    /**
     * \~english
     * Gets the username of the contact.

     * @return The username.
     */
    public String getUsername() {
        return username;
    }

    /**
     * \~english
     * Sets the nickname.
     * @param nick The nickname.
     */
    public void setNickname(String nick) {
        this.nick = nick;
    }

    /**
     * \~english
     * Gets the nickname.

     *
     * @return The nickname.
     */
    public String getNickname()
    {
        if (nick == null) {
            return getUsername();
        } else {
            return nick;
        }
    }
    
    public String toString() {
        return "<contact " + ", username:" + username + ">";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(username);
    }
    
    public static final Parcelable.Creator<EMContact> CREATOR
            = new Parcelable.Creator<EMContact>() {
        public EMContact createFromParcel(Parcel in) {
            return new EMContact(in);
        }

        public EMContact[] newArray(int size) {
            return new EMContact[size];
        }
    };

    private EMContact(Parcel in) {
        username = in.readString();
    }
}
