package io.agora.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;

import io.agora.chat.adapter.message.EMACombineMessageBody;
import io.agora.chat.adapter.message.EMAMessageBody;

import java.util.List;

public class CombineMessageBody extends FileMessageBody{

    public CombineMessageBody() {
        super(Uri.parse(""), EMAMessageBody.EMAMessageBodyTYPE_COMBINE);
        emaObject = new EMACombineMessageBody();
    }

    public CombineMessageBody(String title, String summary, String compatibleText, List<String> messageIdList) {
        this();
        ((EMACombineMessageBody)emaObject).setTitle(title);
        ((EMACombineMessageBody)emaObject).setSummary(summary);
        ((EMACombineMessageBody)emaObject).setCompatibleText(compatibleText);
        ((EMACombineMessageBody)emaObject).setMessageList(messageIdList);
    }

    public CombineMessageBody(EMACombineMessageBody body) {
        super(body);
    }

    /**
     * \~english
     * Sets the title of the combined message.
     * @param The title of the combined message.
     */
    public void setTitle(String title) {
        ((EMACombineMessageBody)emaObject).setTitle(title);
    }

    /**
     * \~english
     * Gets the title of the combined message.
     * @return  The title of the combined message.
     */
    public String getTitle() {
        return ((EMACombineMessageBody)emaObject).getTitle();
    }

    /**
     * \~english
     * Sets the summary of the combined message.
     * @param summary
     */
    public void setSummary(String summary) {
        ((EMACombineMessageBody)emaObject).setSummary(summary);
    }

    /**
     * \~english
     * Gets the summary of the combined message.
     * @return The summary of the combined message.
     */
    public String getSummary() {
        return ((EMACombineMessageBody)emaObject).getSummary();
    }

    /**
     * \~english
     * Sets the compatible text of the combined message.
     *
     * The compatible text is used to be compatible with versions that do not support combined messages. 
     * Specifically, when an SDK sends a combined message to an SDK that does not support this feature, 
     * the latter SDK will parse the compatible text as the content of a text message when receiving the combined message.
     *
     * @param compatibleText The compatible text of the combined message.
     */
    public void setCompatibleText(String compatibleText) {
        ((EMACombineMessageBody)emaObject).setCompatibleText(compatibleText);
    }

    /**
     * \~english
     * Gets the compatible text of the combined message.
     * @return The compatible text of the combined message.
     */
    public String getCompatibleText() {
        return ((EMACombineMessageBody)emaObject).getCompatibleText();
    }

    /**
     * \~english
     * Sets the list of IDs of messages to be combined.
     * @param messageList A list of IDs of messages to be combined. The list cannot be `null` or empty. It can contain a maximum of 300 message IDs.
     */
    public void setMessageList(List<String> messageList) {
        ((EMACombineMessageBody)emaObject).setMessageList(messageList);
    }

    @Override
    public String toString() {
        return "combine: " + ((EMACombineMessageBody)emaObject).getTitle() +
                ", summary: " + ((EMACombineMessageBody)emaObject).getSummary() +
                ", compatibleText: " + ((EMACombineMessageBody)emaObject).getCompatibleText() +
                ", localurl: " + ((EMACombineMessageBody)emaObject).getLocalUrl() +
                ", remoteurl: " + ((EMACombineMessageBody)emaObject).getRemoteUrl();
    }

    public static final Parcelable.Creator<CombineMessageBody> CREATOR
            = new Parcelable.Creator<CombineMessageBody>() {
        public CombineMessageBody createFromParcel(Parcel in) {
            return new CombineMessageBody(in);
        }

        public CombineMessageBody[] newArray(int size) {
            return new CombineMessageBody[size];
        }
    };

    private CombineMessageBody(Parcel in) {
        super((Uri) null, EMAMessageBody.EMAMessageBodyTYPE_COMBINE);
        ((EMACombineMessageBody)emaObject).setDisplayName(in.readString());
        ((EMACombineMessageBody)emaObject).setLocalPath(in.readString());
        ((EMACombineMessageBody)emaObject).setRemotePath(in.readString());
        ((EMACombineMessageBody)emaObject).setSecretKey(in.readString());

        ((EMACombineMessageBody) emaObject).setTitle(in.readString());
        ((EMACombineMessageBody) emaObject).setSummary(in.readString());
        ((EMACombineMessageBody) emaObject).setCompatibleText(in.readString());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMACombineMessageBody)emaObject).displayName());
        dest.writeString(((EMACombineMessageBody)emaObject).getLocalUrl());
        dest.writeString(((EMACombineMessageBody)emaObject).getRemoteUrl());
        dest.writeString(((EMACombineMessageBody)emaObject).getSecret());

        dest.writeString(((EMACombineMessageBody)emaObject).getTitle());
        dest.writeString(((EMACombineMessageBody)emaObject).getSummary());
        dest.writeString(((EMACombineMessageBody)emaObject).getCompatibleText());
    }
}
