/************************************************************
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package io.agora.chat;

import io.agora.ValueCallBack;
import io.agora.chat.adapter.EMAThreadInfo;

/**
 *  \~english
 *  The message thread object class.
 */
public class ChatThread extends EMBase<EMAThreadInfo> {

    public ChatThread(EMAThreadInfo thread) {
        emaObject = thread;
    }

    /**
     * \~english
     * Gets the message thread ID.
     *
     * @return The message thread ID.
     */
    public String getChatThreadId() {
        return emaObject.getThreadId();
    }

    /**
     * \~english
     * Gets the message thread name.
     *
     * @return The message thread name.
     */
    public String getChatThreadName() {
        return emaObject.getThreadName();
    }

    /**
     * \~english
     * Gets the message thread creator.
     * 
     * This message thread creator is returned when you get the message thread details and message thread list.
     *
     * @return The user ID of the message thread creator.
     */
    public String getOwner() {
        return emaObject.getOwner();
    }

    /**
     * \~english
     * Gets the group ID to which the message thread belongs.
     *
     * @return The group ID.
     */
    public String getParentId() {
        return emaObject.getParentId();
    }

    /**
     * \~english
     * Gets the ID of the parent message.
     *
     * @return The ID of the parent message.
     */
    public String getMessageId() {
        return emaObject.getMessageId();
    }

    /**
     * \~english
     * Gets the number of members in the message thread.
     *
     * To get the member count, you need to first call {@link ChatThreadManager#getChatThreadFromServer(String, ValueCallBack)} to get details of the message thread.
     *
     * @return  The number of members in the message thread.
     */
    public int getMemberCount() {
        return emaObject.getMemberCount();
    }

    /**
     * \~english
     * Get the number of messages in a message thread.
     * 
     * To get the number of messages in a message thread, you need to first call {@link ChatMessage#getChatThread()} to get details of the message thread.
     * 
     * @return The message count.
     */
    public int getMessageCount() {
        return emaObject.getMessageCount();
    }

    /**
     * \~english
     * Gets the Unix timestamp when the message thread is created. The unit is millisecond.
     *
     * @return The Unix timestamp when the message thread is created.
     */
    public long getCreateAt() {
        return emaObject.getCreateAt();
    }

    /**
     * \~english
     * Get the last reply in the message thread.
     * 
     * To get the last reply in the message thread, you need to first call {@link ChatMessage#getChatThread()} to get details of the message thread.
     * 
     * @return The last reply in the message thread.
     */
    public ChatMessage getLastMessage() {
        if(emaObject.getLastMessage() == null) {
            return null;
        }
        return new ChatMessage(emaObject.getLastMessage());
    }

    /**
     * \~english
     * Gets the message thread name or ID.
     *
     * This method can be used for adapter sorting.
     *
     * @return  The message thread name or ID.
     */
    public String toString() {
        String str = getChatThreadName();
        return str != null ? str : getChatThreadId();
    }

}
