package io.agora;


import io.agora.chat.Conversation;

import java.util.List;
/**
 * Created by linan on 17/4/17.
 */
/**
 * \~english
 * The multi-device event listener.
 * 
 * The listener listens for callbacks for the current user's actions on other devices, including contact changes and group changes.
 * 
 *     Adds a multi-device event listener:
 * 
 * ```java
 *     ChatClient.getInstance().addMultiDeviceListener(mMultiDeviceListener);
 * ```
 * 
 *     Removes a multi-device event listener:
 * 
 * ```java
 *     ChatClient.getInstance().removeMultiDeviceListener(mMultiDeviceListener);
 * ```
 */
@SuppressWarnings("unused")
public interface MultiDeviceListener {

//    /**
//     * \~english
//     * The current user initiated a friend request on another device.
//     */
//    int CONTACT_ADD = 1;

    /**
     * \~english
     * The current user removed a contact on another device.
     */
    int CONTACT_REMOVE = 2;

    /**
     * \~english
     * The current user accepted a friend request on another device.
     */
    int CONTACT_ACCEPT          = 3;

    /**
     * \~english
     * The current user declined a friend request on another device.
     */
    int CONTACT_DECLINE         = 4;

    /**
     * \~english
     * The current user added a contact to the block list on another device.
     */
     int CONTACT_BAN           = 5;

    /**
     * \~english
     * The current user removed a contact from the block list on another device.
     */
     int CONTACT_ALLOW         = 6;



    /**
     * \~english
     * The current user created a group on another device.
     */
    int GROUP_CREATE            = 10;

    /**
     * \~english
     * The current user destroyed a group on another device.
     */
    int GROUP_DESTROY           = 11;

    /**
     * \~english
     * The current user joined a group on another device.
     */
    int GROUP_JOIN              = 12;

    /**
     * \~english
     * The current user left a group on another device.
     */
    int GROUP_LEAVE             = 13;

    /**
     * \~english
     * The current user requested to join a group on another device.
     */
    int GROUP_APPLY             = 14;

    /**
     * \~english
     * The current user accepted a group request on another device.
     */
    int GROUP_APPLY_ACCEPT      = 15;

    /**
     * \~english
     * The current user declined a group request on another device.
     */
    int GROUP_APPLY_DECLINE     = 16;

    /**
     * \~english
     * The current user invited a user to join the group on another device.
     */
    int GROUP_INVITE            = 17; //

    /**
     * \~english
     * The current user accepted a group invitation on another device.
     */
    int GROUP_INVITE_ACCEPT     = 18; //

    /**
     * \~english
     * The current user declined a group invitation on another device.
     */
    int GROUP_INVITE_DECLINE    = 19;

    /**
     * \~english
     * The current user kicked a member out of a group on another device.
     */
    int GROUP_KICK              = 20;

    /**
     * \~english
     * The current user added a member to a group block list on another device.
     */
    int GROUP_BAN               = 21; //加入群组黑名单

    /**
     * \~english
     * The current user removed a member from a group block list on another device.
     */
    int GROUP_ALLOW             = 22;

    /**
     * \~english
     * The current user blocked a group on another device.
     */
    int GROUP_BLOCK             = 23;

    /**
     * \~english
     * The current user unblocked a group on another device.
     */
    int GROUP_UNBLOCK           = 24;

    /**
     * \~english
     * The current user transferred the group ownership on another device.
     */
    int GROUP_ASSIGN_OWNER      = 25;

    /**
     * \~english
     * The current user added an admin on another device.
     */
    int GROUP_ADD_ADMIN         = 26;

    /**
     * \~english
     * The current user removed an admin on another device.
     */
    int GROUP_REMOVE_ADMIN      = 27;

    /**
     * \~english
     * The current user muted a member on another device.
     */
    int GROUP_ADD_MUTE          = 28;

    /**
     * \~english
     * The current user unmuted a member on another device.
     */
    int GROUP_REMOVE_MUTE       = 29;

    /**
     * \~english
     * The current user adds other users to the group allow list on another device.
     */
    int GROUP_ADD_USER_WHITE_LIST     = 30;

    /**
     * \~english
     * The current user removes other users from the group allow list on another device.
     */
    int GROUP_REMOVE_USER_WHITE_LIST  = 31;

    /**
     * \~english
     * The current user muted all members of a group on another device.
     */
    int GROUP_ALL_BAN                 = 32;

    /**
     * \~english
     * The current user unmuted all members of a group on another device.
     */
    int GROUP_REMOVE_ALL_BAN          = 33;

    /**
     * \~english
     * The current user created a message thread on another device.
     */
    int THREAD_CREATE                 = 40;// thread创建事件
    /**
     * \~english
     * The current user destroyed a message thread on another device.
     */
    int THREAD_DESTROY                = 41;//销毁
    /**
     * \~english
     * The current user joined a message thread on another device.
     */
    int THREAD_JOIN                   = 42; //thread加入事件(自己)
    /**
     * \~english
     * The current user left a message thread on another device.
     */
    int THREAD_LEAVE                  = 43; //leave thread
    /**
     * \~english
     * The current user updated message thread information on another device.
     */
    int THREAD_UPDATE                 = 44;
    /**
     * \~english
     * The current user kicked a member out of a message thread on another device.
     */
    int THREAD_KICK                   = 45;
    /**
     * \~english
     * The current user modified custom attributes of a group member on another device.
     */
    int GROUP_METADATA_CHANGED        = 52;

    /**
     * \~english
     * The current user pinned a conversation on another device.
     */
    int CONVERSATION_PINNED           = 60;
    /**
     * \~english
     * The current user unpinned a conversation on another device.
     */
    int CONVERSATION_UNPINNED         = 61;
    /**
     * \~english
     * The current user removed a conversation from the server.
     */
    int CONVERSATION_DELETED         = 62;

    /**
     * \~english
     * The multi-device contact event.
     * 
     * @param event     The contact event. See {@link MultiDeviceListener}.
     * @param target    The user ID of the contact.
     * @param ext       The extension information.
     */
    void onContactEvent(int event, String target, String ext);

    /**
     * \~english
     * The multi-device group event.
     * 
     * @param event         The group event. See {@link MultiDeviceListener}.
     * @param target        The group ID.
     * @param usernames     The operation target ID(s).
     */
    void onGroupEvent(int event, String target, List<String> usernames);

    /**
     * \~english
     * The multi-device message thread event.
     * @param event         The message thread event. See {@link MultiDeviceListener}.
     * @param target        The message thread ID.
     * @param usernames     The operation target ID(s).
     */
    default void onChatThreadEvent(int event, String target, List<String> usernames) {}

    /**
     * \~english
     * The multi-device event of historical message deletion from the server.
     * 
     * @param conversationId    The conversation ID.
     * @param deviceId          The device ID.
     */
    default void onMessageRemoved(String conversationId,String deviceId){}


    /**
     * \~english
     * The multi-device conversation event.
     * 
     * @param event             The conversation event. See {@link #CONVERSATION_PINNED}, {@link #CONVERSATION_UNPINNED}, and {@link #CONVERSATION_DELETED}.
     * @param conversationId    The conversation ID.
     * @param type              The conversation type. See {@link Conversation.ConversationType}.
     */
    default void onConversationEvent(int event, String conversationId, Conversation.ConversationType type) {}

}
