/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package io.agora;

/**
 * \~english
 * The error constant class in the SDK, which defines common error codes in the SDK.
 */
public class Error {
    
    /**
     * \~english
     * No error.
     */
    public final static int EM_NO_ERROR = 0;

    /**
     * \~english
     * The general error occurs. 
     * 
     * Undefined errors are generally thrown with this error code.
     */
    public final static int GENERAL_ERROR = 1;
    
    /**
     * \~english
     * A network error occurs. 
     */
    public final static int NETWORK_ERROR = 2;

    /**
     * \~english
     * A database operation fails.
     */
    public final static int DATABASE_ERROR = 3;

    /**
     * \~english
     * The service limit is exceeded. 
     */
    public final static int EXCEED_SERVICE_LIMIT = 4;

    /**
     * \~english
     * The balance is insufficient.
     */
    public final static int SERVICE_ARREARAGES = 5;

    /**
     * \~english
     * Fails to report push information to the server.
     */
    public final static int PUSH_REPORT_ACTION_FAILED = 6;


    /**
     * \~english
     * request success but had some error value
     */
    public final static int PARTIAL_SUCCESS = 7;


    /**
     * \~english
     * The number of daily active users (DAU) or monthly active users (MAU) for the app has reached the upper limit .
     */
    public final static int APP_ACTIVE_NUMBER_REACH_LIMITATION = 8;


    /**
     * \~english
     * The App Key is invalid.
     */
    public final static int INVALID_APP_KEY = 100;

    /**
     * \~english
     * The user ID is invalid.
     */
    public final static int INVALID_USER_NAME = 101;

    /**
     * \~english
     * The password is invalid.
     */
    public final static int INVALID_PASSWORD = 102;
    
    /**
     * \~english
     * The URL is invalid.
     */
    public final static int INVALID_URL = 103;

    /**
     * \~english
     * The token is invalid.
     */
    public final static int INVALID_TOKEN = 104;

    /**
     * \~english
     * The user ID is too long.
     */
    public final static int USER_NAME_TOO_LONG = 105;

    /**
     * \~english
     * The function of getting conversations from the server has not been activated.
     */
    public final static int CHANNEL_SYNC_NOT_OPEN = 106;

    /**
     * \~english
     * Invalid conversation.
     */
    public final static int INVALID_CONVERSATION = 107;


    /**
     * \~english
     *  The Agora token has expired.
     */
    public final static int TOKEN_EXPIRED = 108;

    /**
     * \~english
     *  The Agora token is about to expire.
     */
    public final static int TOKEN_WILL_EXPIRE = 109;

    /**
     * \~english
     * The parameter is invalid.
     */
    public final static int INVALID_PARAM = 110;

    /**
     * \~english
     *  The operation is not supported.
     */
    public final static int OPERATION_UNSUPPORTED = 111;

    /**
     * \~english
     *  Query param reaches limit
     */
    public final static int QUERY_PARAM_REACHES_LIMIT = 112;

    /**
     * \~english
     * The user is already logged in.
     */
    public final static int USER_ALREADY_LOGIN = 200;

    /**
     * \~english
     * The user is not logged in.
     */
    public final static int USER_NOT_LOGIN = 201;

    /**
     * \~english
     * The user ID or password is incorrect.
     */
    public final static int USER_AUTHENTICATION_FAILED = 202;

    /**
     * \~english
     * The user already exists.
     */
    public final static int USER_ALREADY_EXIST = 203;

    /**
     * \~english
     * The user is not found.
     */
    public final static int USER_NOT_FOUND = 204;

    /**
     * \~english
     * Invalid parameter.
     */
    public final static int USER_ILLEGAL_ARGUMENT = 205;
    
    /**
     * \~english
     * The user is logged in from another device.
     */
    public final static int USER_LOGIN_ANOTHER_DEVICE = 206;

    /**
     * \~english
     * The user is removed from the server.
     */
    public final static int USER_REMOVED = 207;

    /**
     * \~english
     * The user registration fails.
     */
    public final static int USER_REG_FAILED = 208;

    /**
     * \~english
     * Fails to update user information.
     */
    public final static int USER_UPDATEINFO_FAILED = 209;

    /**
     * \~english
     * The user has no operation permission.
     */
    public final static int USER_PERMISSION_DENIED = 210;
    
    /**
     * \~english
     * Fails to bind the device token.
     */
    public final static int USER_BINDDEVICETOKEN_FAILED = 211;
    
    /**
     * \~english
     * Fails to unbind the device token.
     */
    public final static int USER_UNBIND_DEVICETOKEN_FAILED = 212;

    /**
     * \~english
     * The user is bound to another device and automatic login is not allowed.
     */
    public final static int USER_BIND_ANOTHER_DEVICE = 213;

    /**
     * \~english
     * The user has logged in on too many devices. 
     */
    public final static int USER_LOGIN_TOO_MANY_DEVICES = 214;

    /**
     * \~english
     * The user is muted in the chat group or chat room. 
     */
    public final static int USER_MUTED = 215;

    /**
     * \~english
     * The user has changed the password.
     */
    public final static int USER_KICKED_BY_CHANGE_PASSWORD = 216;

    /**
     * \~english
     * The user is kicked off from another device. 
     */
    public final static int USER_KICKED_BY_OTHER_DEVICE = 217;
    /**
     * \~english
     * The user has already logged in from another device. 
     */
    public final static int USER_ALREADY_LOGIN_ANOTHER = 218;
    /**
     * \~english
     * The user is muted by the admin. 
     */
    public final static int USER_MUTED_BY_ADMIN = 219;

    /**
     * \~english
     * The current login device is not the same as last time and you need to log in again.
     * 
     * By default, the user is allowed to log in to the current device, but will be kicked off from another device. This method works only when the switch of not kicking off users from other devices is turned on.
     */
    public final static int USER_DEVICE_CHANGED = 220;

    /**
     * \~english
     * The user is not on your contact list and you cannot send messages to the user.
     * 
     * By default, you can send messages to strangers.
     * 
     * This error will be reported only when you have turned on the function of allowing you to send messages only to your contacts.
     */
    public final static int USER_NOT_ON_ROSTER = 221;

    /**
     * \~english
     * Unable to access the server.
     */
    public final static int SERVER_NOT_REACHABLE = 300;
    
    /**
     * \~english
     * The server response times out. 
     */
    public final static int SERVER_TIMEOUT = 301;

    /**
     * \~english
     * The server is busy.
     */
    public final static int SERVER_BUSY = 302;
    
    /**
     * \~english
     * An unknown server error.
     */
    public final static int SERVER_UNKNOWN_ERROR = 303;

    /**
     * \~english
     * Fails to get the DNS server list.
     */
    public final static int SERVER_GET_DNSLIST_FAILED = 304;

    /**
     * \~english
     * The chat function is restricted.
     */
    public final static int SERVER_SERVICE_RESTRICTED = 305;

    /**
     * \~english
     * Server transfer decryption failed.
     */
    public final static int SERVER_DECRYPTION_FAILED   = 306;


    /**
     * \~english
     * The file is not found. 
     */
    public final static int FILE_NOT_FOUND = 400;
    
    /**
     * \~english
     * The file is invalid.
     */
    public final static int FILE_INVALID = 401;
    
    /**
     * \~english
     * The file upload fails.
     */
    public final static int FILE_UPLOAD_FAILED = 402;
    
    /**
     * \~english
     * The file download fails.
     */
    public final static int FILE_DOWNLOAD_FAILED = 403;

    /**
     * \~english
     * The file deletion fails.
     */
    public final static int FILE_DELETE_FAILED = 404;

    /**
     * \~english
     * The file is too large.
     */
    public final static int FILE_TOO_LARGE = 405;

    /**
     * \~english
     * The file contains improper content.
     */
    public final static int FILE_CONTENT_IMPROPER = 406;

    /**
     * \~english
     * The message is invalid.
     */
    public final static int MESSAGE_INVALID = 500;
 
    /**
     * \~english
     * The message contains invalid content or sensitive words.
     */
    public final static int MESSAGE_INCLUDE_ILLEGAL_CONTENT = 501;

    /**
     * \~english
     * The traffic limit for message sending is exceeded.
     */
    public final static int MESSAGE_SEND_TRAFFIC_LIMIT = 502;

    /**
     * \~english
     * The message encryption/decryption error.
     */
    public final static int MESSAGE_ENCRYPTION_ERROR = 503;

    /**
     * \~english
     * The message recall times out.
     */
    public final static int MESSAGE_RECALL_TIME_LIMIT = 504;

    /**
     * \~english
     * The service is not enabled.
     */
    public final static int SERVICE_NOT_ENABLED = 505;

    /**
     * \~english
     * The message has expired.
     */
    public final static int MESSAGE_EXPIRED = 506;

    /**
     * \~english
     * All members in a group or chat room are muted and the current user is not on the allow list.
     */
    public final static int MESSAGE_ILLEGAL_WHITELIST = 507;

    /**
     * \~english
     * A message is blocked by pre-delivery callback.
     */
    public final static int MESSAGE_EXTERNAL_LOGIC_BLOCKED = 508;

    /**
     * \~english
     * You have exceeded the maximum frequency of sending group messages.
     */
    public final static int MESSAGE_CURRENT_LIMITING = 509;

    /**
     * \~english
     * You have exceeded the maximum allowed size of a message body.
     */
    public final static int MESSAGE_SIZE_LIMIT = 510; 

    /**
     * \~english
     * The message modification failed.
     */
    public final static int MESSAGE_EDIT_FAILED = 511;


    /**
     * \~english
     * The group ID is incorrect.
     */
    public final static int GROUP_INVALID_ID = 600;     
    /**
     * \~english
     * The user is already in the group.
     */
    public final static int GROUP_ALREADY_JOINED = 601;
    /**
     * \~english
     * The user is not in the group.
     */
    public final static int GROUP_NOT_JOINED = 602;
    /**
     * \~english
     * The user does not have group operation permissions.
     */
    public final static int GROUP_PERMISSION_DENIED = 603;      
    /**
     * \~english
     * The group has reached the maximum member capacity.
     */
    public final static int GROUP_MEMBERS_FULL = 604;

    /**
     * \~english
     * The group shared file ID is invalid.
     */
    public final static int GROUP_SHARED_FILE_INVALIDID = 605;

    /**
     * \~english
     * The group does not exist.
     */
    public final static int GROUP_NOT_EXIST = 606;

    /**
     * \~english
     * The group is disabled.
     */
    public final static int GROUP_DISABLED = 607;

    /**
     * \~english
     * The group name is inappropriate.
     */
    public final static int GROUP_NAME_VIOLATION = 608;
    /**
     * \~english
     * The total length of custom attributes of the group member has exceeded the upper limit (4 KB).
     */
    public final static int GROUP_MEMBER_ATTRIBUTES_REACH_LIMIT = 609;
    /**
     * \~english
     * Fails to set the custom attribute(s) of the group member.
     */
    public final static int GROUP_MEMBER_ATTRIBUTES_UPDATE_FAILED = 610;
    /**
     * \~english
     * The key of a custom attribute(s) of the group member has exceeded the maximum allowed length of 16 bytes.
     */
    public final static int GROUP_MEMBER_ATTRIBUTES_KEY_REACH_LIMIT = 611;
    /**
     * \~english
     * The value of a custom attribute(s) of the group member has exceeded the maximum allowed length of 512 bytes.
     */
    public final static int GROUP_MEMBER_ATTRIBUTES_VALUE_REACH_LIMIT = 612;


    /**
     * \~english
     * The chat room ID is invalid.
     */
    public final static int CHATROOM_INVALID_ID = 700;

    /**
     * \~english
     * The user is already in the chat room.
     */
    public final static int CHATROOM_ALREADY_JOINED = 701;

    /**
     * \~english
     * The user is not in the chat room.
     */
    public final static int CHATROOM_NOT_JOINED = 702;

    /**
     * \~english
     * The user does not have the operation permission.
     */
    public final static int CHATROOM_PERMISSION_DENIED = 703;

    /**
     * \~english
     * The chat room has reached the maximum member capacity.
     */
    public final static int CHATROOM_MEMBERS_FULL = 704;
    
    /**
     * \~english
     * The chat room does not exist.
     */
    public final static int CHATROOM_NOT_EXIST = 705;

    /**
     * \~english
     * The number of users for user information retrieval exceeds the upper limit.
     */
    public final static int USERINFO_USERCOUNT_EXCEED  = 900;

    /**
     * \~english
     * The length of the updated user information exceeds the upper limit.
     */
    public final static int USERINFO_DATALENGTH_EXCEED = 901;

    /**
     * \~english
     * Invalid translation parameters.
     * 
     * @deprecated Deprecated. Use {@link #TRANSLATE_PARAM_INVALID} instead.
     */
    @Deprecated
    public final static int TRANSLATE_INVALID_PARAMS = 903;

    /**
     * \~english
     * Translation failure.
     * 
     * @deprecated
     */
    @Deprecated
    public final static int TRANSLATE_FAIL = 904;

    /**
     * \~english
     * The translation is not initialized.
     * 
     * @deprecated
     */
    @Deprecated
    public final static int TRANSLATE_NOT_INIT = 905;

    /**
     * 添加联系人失败。
     *
     * \~english
     * Failed to add a contact.
     */
    public final static int CONTACT_ADD_FAILED = 1000;
    /**
     * \~english
     * The inviter has reached the maximum number of contacts that can be added.
     */
    public final static int CONTACT_REACH_LIMIT = 1001;
    /**
     * \~english
     * The invitee has reached the maximum number of contacts that can be added.
     */
    public final static int CONTACT_REACH_LIMIT_PEER = 1002;

    /**
     * \~english
     * The parameter length of the presence method exceeds the upper limit.
     */
    public final static int  PRESENCE_PARAM_LENGTH_EXCEED = 1100;

    /**
     * \~english
     * Presence can't subscribe yourself.
     */
    public final static int PRESENCE_CANNOT_SUBSCRIBE_YOURSELF = 1101;

    /**
     * \~english
     * Translation parameter error.
     */
    public final static int TRANSLATE_PARAM_INVALID = 1110;

    /**
     * \~english
     * The translation service has not been enabled.
     */
    public final static int TRANSLATE_SERVICE_NOT_ENABLE = 1111;

    /**
     * \~english
     * You have reached the maximum number of characters for translation.
     */
    public final static int TRANSLATE_USAGE_LIMIT = 1112;

    /**
     * \~english
     * Failed to obtain the translation service.
     */
    public final static int TRANSLATE_MESSAGE_FAIL = 1113;

    /**
     * \~english
     * The third-party content moderation service rates the message as "Reject".
     */
    public final static int MODERATION_FAILED = 1200;

    /**
     * \~english
     * Another third-party moderation service rather than the third-party content moderation service rates the message as "Reject".
     */
    public final static int THIRD_SERVER_FAILED = 1299;

    /**
     * \~english
     * The number of Reactions has reached the upper limit.
     */
    public final static int REACTION_REACH_LIMIT = 1300;

    /**
     * \~english
     * The Reaction already exists.
     */
    public final static int REACTION_HAS_BEEN_OPERATED = 1301;

    /**
     * \~english
     * The user does not have the permission for the Reaction operation. 
     * 
     * For example, the user who does not add the reaction attempts to delete it, or the user that is neither the sender nor recipient of the one-to-one message attempts to add the Reaction.
     */
    public final static int REACTION_OPERATION_IS_ILLEGAL = 1302;

    /**
     * \~english
     * The message thread does not exist.
     */
    public final static int THREAD_NOT_EXIST = 1400;

    /**
     * \~english
     * 	The message thread you are attempting to create already exists in a chat group.
     */
    public final static int THREAD_ALREADY_EXIST = 1401;

    /**
     * \~english
     * The parent message of the message thread is invalid.
     */
    public final static int THREAD_CREATE_MESSAGE_ILLEGAL = 1402;

    /**
     * \~english
     * The current device does not support push.
     */
    public final static int PUSH_NOT_SUPPORT = 1500;

    /**
     * \~english
     * Fails to bind the push token.
     */
    public final static int PUSH_BIND_FAILED = 1501;

    /**
     * \~english
     * Fails to unbind the push token.
     */
    public final static int PUSH_UNBIND_FAILED = 1502;
}
