/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package io.agora;

/**
 *  \~english
 *  The contact updates listener.
 * 
 *  Listen for the contact changes, including requests to add friends, notifications to delete friends,
 *  requests to accept friends, and requests to reject friends.
 * 
 *     Register listener：
 *     ```java
 *     ChatClient.getInstance().contactManager().setContactListener(mContactListener);
 *     ```
 * 
 *     Unregister listener：
 *     ```java
 *     ChatClient.getInstance().contactManager().removeContactListener(mContactListener);
 *     ```
 */
public interface ContactListener {
    
    /**
     * \~english
     * Occurs when user is added as a contact by another user.
     * @param username   The new contact to be added.
     */
    void onContactAdded(String username);
    
    /**
     * \~english
     * Occurs when a user is removed from the contact list by another user.
     * @param username    The user who is removed from the contact list by another user.
     */
    void onContactDeleted(String username);

    /**
     * \~english
     * Occurs when a user receives a friend request.
     * @param username    The user who initiated the friend request.
     * @param reason      The invitation message. 
     */
    void onContactInvited(String username, String reason);
    
    /**
     * \~english
     * Occurs when a friend request is approved.
     * @param username The user who initiated the friend request.
     */
    void onFriendRequestAccepted(String username);

    /**
     * \~english
     * Occurs when a friend request is declined.
     * @param username The user who initiated the friend request.
     */
    void onFriendRequestDeclined(String username);
}
