/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package io.agora;

/**
 * \~english
 * The chat connection listener.
 * 
 * For the occasion of onDisconnected during unstable network condition, you don't need to reconnect manually,
 * the chat SDK will handle it automatically.
 * 
 * There are only two states: onConnected, onDisconnected.
 * 
 * Note: We recommend not to update UI based on those methods, because this method is called on worker thread. If you update UI in those methods, other UI errors might be invoked.
 * Also do not insert heavy computation work here, which might invoke other listeners to handle this connection event.
 *
 *     Register:
 *     ```java
 *     ChatClient.getInstance().addConnectionListener(mConnectionListener);
 *     ```
 * 
 *     Unregister:
 *     ```java
 *     ChatClient.getInstance().removeConnectionListener(mConnectionListener);
 *     ```
 *
 */
public interface ConnectionListener {
    /**
     * \~english
     * Occurs when the SDK connects to the chat server successfully.
     */
    void onConnected();

    /**
     * \~english
     * Occurs when the SDK disconnect from the chat server.
     * 
     * Note that the logout may not be performed at the bottom level when the SDK is disconnected.
     * 
     * Common errors are as follows: 
     * {@link Error#USER_REMOVED},{@link Error#USER_LOGIN_ANOTHER_DEVICE},
     * {@link Error#SERVER_SERVICE_RESTRICTED},{@link Error#USER_KICKED_BY_CHANGE_PASSWORD} and
     * {@link Error#USER_KICKED_BY_OTHER_DEVICE}
     */
    void onDisconnected(final int errorCode);

    /**
     * \~english
     * Occurs when the token has expired.
     * 
     * Common errors are as follows: 
     * {@link Error#TOKEN_EXPIRED},{@link Error#TOKEN_WILL_EXPIRE},
     */

    default void onTokenExpired(){}

    /**
     * \~english
     * Occurs when the token is about to expire.
     */
    default void onTokenWillExpire(){}

    /**
     * \~english
     * Occurs when the UNDERLYING SDK logs out.
     * 
     * Common errors are as follows:
     * {@link Error#USER_LOGIN_ANOTHER_DEVICE}，{@link Error#USER_REMOVED}，
     * {@link Error#USER_BIND_ANOTHER_DEVICE}，{@link Error#SERVER_SERVICE_RESTRICTED}，
     * {@link Error#USER_LOGIN_TOO_MANY_DEVICES}，{@link Error#USER_KICKED_BY_CHANGE_PASSWORD}，
     * {@link Error#USER_KICKED_BY_OTHER_DEVICE}
     * @param errorCode
     *
     * @deprecated use {@link ConnectionListener#onLogout(int, java.lang.String)} instead。
     */
    @Deprecated
    default void onLogout(final int errorCode){}
    /**
     * \~english
     * Occurs when the UNDERLYING SDK logs out.
     *
     * @param errorCode error code .
     * Common errors are as follows:
     * {@link Error#USER_LOGIN_ANOTHER_DEVICE}，{@link Error#USER_REMOVED}，
     * {@link Error#USER_BIND_ANOTHER_DEVICE}，{@link Error#SERVER_SERVICE_RESTRICTED}，
     * {@link Error#USER_LOGIN_TOO_MANY_DEVICES}，{@link Error#USER_KICKED_BY_CHANGE_PASSWORD}，
     * {@link Error#USER_KICKED_BY_OTHER_DEVICE}
     *
     * @param info error extend info .
     * If errorCode is {@link Error#USER_LOGIN_ANOTHER_DEVICE}, info is the user-defined device name of the peer that kicks or squeeches the current device.
     * If the peer device does not have a user-defined device name, the device name of the peer device is called back by default.In other error code scenarios, info is empty.
     */
    default void onLogout(final int errorCode,String info){}


}
