/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package io.agora;

import io.agora.chat.ChatThreadEvent;

/**
 * \~english
 * The message thread listener interface, which listens for message thread events such as creating or leaving a message thread.
 *
 * <pre>
 *     Adds a message thread event listener:
 *     ChatClient.getInstance().chatThreadManager().addChatThreadChangeListener(mChatThreadChangeListener);
 *
 *     Removes a message thread event listener:
 *     ChatClient.getInstance().chatThreadManager().removeChatThreadChangeListener(mChatThreadChangeListener);
 * </pre>
 */
public interface ChatThreadChangeListener {

	/**
	 * \~english
	 * Occurs when a message thread is created.
	 *
	 * Each member of the group to which the message thread belongs can receive the callback.
	 */
	void onChatThreadCreated(ChatThreadEvent event);

	/**
	 * \~english
	 * Occurs when a message thread is updated.
	 *
	 * This callback is triggered when the message thread name is changed or a threaded reply is added or recalled.
	 *
	 * Each member of the group to which the message thread belongs can receive the callback.
	 */
	void onChatThreadUpdated(ChatThreadEvent event);

	/**
	 * \~english
	 * Occurs when a message thread is destroyed.
	 *
	 * Each member of the group to which the message thread belongs can receive the callback.
	 */
	void onChatThreadDestroyed(ChatThreadEvent event);

	/**
	 * \~english
	 * Occurs when the current user is removed from the message thread by the group owner or a group admin to which the message thread belongs.
	 */
	void onChatThreadUserRemoved(ChatThreadEvent event);

}