/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRevocationInformation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.IntValueConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.policy.jaxb.ValueConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.crs.CertificateRevocationSelector;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.RevocationFreshnessChecker;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks.RevocationDataAvailableCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.AuthorityInfoAccessPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.BasicConstraintsCACheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.BasicConstraintsMaxPathLengthCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateForbiddenExtensionsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateIssuedToLegalPersonCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateIssuedToNaturalPersonCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateIssuerNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateMinQcEuRetentionPeriodCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateMinQcTransactionLimitCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateNameConstraintsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateNotOnHoldCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateNotRevokedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateNotSelfSignedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePS2DQcCompetentAuthorityIdCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePS2DQcCompetentAuthorityNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePS2DQcRolesOfPSPCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePolicyIdsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePolicyQualifiedIdsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePolicySupportedByQSCDIdsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificatePolicyTreeCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcCCLegislationCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcComplianceCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcEuLimitValueCurrencyCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcEuPDSLocationCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcSSCDCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateQcTypeCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateRevocationSelectorResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSelfSignedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSemanticsIdentifierCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSignatureValidCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSupportedCriticalExtensionsCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateValidityRangeCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CommonNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CountryCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.ExtendedKeyUsageCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.GivenNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.IdPkixOcspNoCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.KeyUsageCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.OrganizationNameCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.OrganizationUnitCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.PseudoUsageCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.PseudonymCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationFreshnessCheckerResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationInfoAccessPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationIssuerTrustedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationIssuerValidityRangeCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.SerialNumberCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.SurnameCheck;
import java.util.Collection;
import java.util.Date;

public class SubX509CertificateValidation
extends Chain<XmlSubXCV> {
    private final CertificateWrapper currentCertificate;
    private final Date currentTime;
    private final Context context;
    private final SubContext subContext;
    private final ValidationPolicy validationPolicy;

    public SubX509CertificateValidation(I18nProvider i18nProvider, CertificateWrapper currentCertificate, Date currentTime, Context context, SubContext subContext, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlSubXCV());
        ((XmlSubXCV)this.result).setId(currentCertificate.getId());
        ((XmlSubXCV)this.result).setTrustAnchor(Boolean.valueOf(currentCertificate.isTrusted()));
        ((XmlSubXCV)this.result).setSelfSigned(Boolean.valueOf(currentCertificate.isSelfSigned()));
        this.currentCertificate = currentCertificate;
        this.currentTime = currentTime;
        this.context = context;
        this.subContext = subContext;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.SUB_XCV;
    }

    @Override
    protected void initChain() {
        if (this.currentCertificate.isTrusted()) {
            return;
        }
        ChainItem<XmlSubXCV> item = this.firstItem = this.serialNumber(this.currentCertificate, this.subContext);
        item = item.setNextItem(this.surname(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.givenName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.commonName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.pseudoUsage(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.pseudonym(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.country(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.organizationUnit(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.organizationName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.selfSigned(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.notSelfSigned(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePolicyIds(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePolicyQualifiedIds(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePolicySupportedByQSCDIds(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcCompliance(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcEuLimitValueCurrency(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateMinQcEuLimitValue(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcEuRetentionPeriod(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcSSCD(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcEuPDSLocation(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcType(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateQcCCLegislation(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateIssuedToNaturalPerson(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateIssuedToLegalPerson(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateSemanticsIdentifier(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePS2DQcRolesOfPSP(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePS2DQcCompetentAuthorityName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificatePS2DQcCompetentAuthorityId(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.certificateSignatureValid(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.ca(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.issuerName(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.maxPathLength(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.keyUsage(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.extendedKeyUsage(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.aiaPresent(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.policyTree(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.nameConstraints(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.supportedCriticalCertificateExtensions(this.currentCertificate, this.subContext));
        item = item.setNextItem(this.forbiddenCertificateExtensions(this.currentCertificate, this.subContext));
        CertificateRevocationWrapper latestCertificateRevocation = null;
        if (this.currentCertificate.isIdPkixOcspNoCheck()) {
            item = item.setNextItem(this.idPkixOcspNoCheck(this.currentCertificate));
        }
        if (ValidationProcessUtils.isRevocationCheckRequired(this.currentCertificate)) {
            item = item.setNextItem(this.revocationInfoAccessPresent(this.currentCertificate, this.subContext));
            item = item.setNextItem(this.revocationDataPresent(this.currentCertificate, this.subContext));
            if (Utils.isCollectionNotEmpty((Collection)this.currentCertificate.getCertificateRevocationData())) {
                CertificateRevocationSelector certificateRevocationSelector = new CertificateRevocationSelector(this.i18nProvider, this.currentCertificate, this.currentTime, this.validationPolicy);
                XmlCRS xmlCRS = (XmlCRS)certificateRevocationSelector.execute();
                ((XmlSubXCV)this.result).setCRS(xmlCRS);
                item = item.setNextItem(this.checkCertificateRevocationSelectorResult(xmlCRS));
                latestCertificateRevocation = certificateRevocationSelector.getLatestAcceptableCertificateRevocation();
                if (latestCertificateRevocation != null && latestCertificateRevocation.isRevoked()) {
                    this.attachRevocationInformation(latestCertificateRevocation);
                }
                if (this.isValid((XmlConstraintsConclusion)xmlCRS)) {
                    item = item.setNextItem(this.certificateNotRevoked(latestCertificateRevocation, this.subContext));
                    item = item.setNextItem(this.certificateNotOnHold(latestCertificateRevocation, this.subContext));
                    RevocationFreshnessChecker rfc = new RevocationFreshnessChecker(this.i18nProvider, (RevocationWrapper)latestCertificateRevocation, this.currentTime, this.context, this.subContext, this.validationPolicy);
                    XmlRFC rfcResult = (XmlRFC)rfc.execute();
                    ((XmlSubXCV)this.result).setRFC(rfcResult);
                    item = item.setNextItem(this.checkRevocationFreshnessCheckerResult(rfcResult));
                }
            }
        }
        item = item.setNextItem(this.certificateCryptographic(this.currentCertificate, this.context, this.subContext));
        if (SubContext.SIGNING_CERT == this.subContext) {
            CertificateWrapper revocationIssuerCertificate;
            item = item.setNextItem(this.certificateValidityRange(this.currentCertificate, latestCertificateRevocation, this.subContext));
            if (latestCertificateRevocation != null && (revocationIssuerCertificate = latestCertificateRevocation.getSigningCertificate()) != null) {
                item = revocationIssuerCertificate.isTrusted() ? item.setNextItem(this.revocationDataIssuerTrusted(revocationIssuerCertificate)) : item.setNextItem(this.revocationIssuerValidityRange(latestCertificateRevocation, this.subContext));
            }
        }
    }

    private void attachRevocationInformation(CertificateRevocationWrapper certificateRevocation) {
        XmlRevocationInformation revocationInfo = new XmlRevocationInformation();
        revocationInfo.setCertificateId(this.currentCertificate.getId());
        revocationInfo.setRevocationId(certificateRevocation.getId());
        revocationInfo.setRevocationDate(certificateRevocation.getRevocationDate());
        revocationInfo.setReason(certificateRevocation.getReason());
        ((XmlSubXCV)this.result).setRevocationInfo(revocationInfo);
    }

    private ChainItem<XmlSubXCV> certificateValidityRange(CertificateWrapper certificate, CertificateRevocationWrapper usedCertificateRevocation, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotExpiredConstraint(this.context, subContext);
        return new CertificateValidityRangeCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, usedCertificateRevocation, this.currentTime, constraint);
    }

    private ChainItem<XmlSubXCV> revocationDataIssuerTrusted(CertificateWrapper revocationIssuer) {
        return new RevocationIssuerTrustedCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, revocationIssuer, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlSubXCV> revocationIssuerValidityRange(CertificateRevocationWrapper usedCertificateRevocation, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getRevocationIssuerNotExpiredConstraint(this.context, subContext);
        return new RevocationIssuerValidityRangeCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, (RevocationWrapper)usedCertificateRevocation, this.currentTime, constraint);
    }

    private ChainItem<XmlSubXCV> ca(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateCAConstraint(this.context, subContext);
        return new BasicConstraintsCACheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> issuerName(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateIssuerNameConstraint(this.context, subContext);
        return new CertificateIssuerNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> maxPathLength(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateMaxPathLengthConstraint(this.context, subContext);
        return new BasicConstraintsMaxPathLengthCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> keyUsage(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateKeyUsageConstraint(this.context, subContext);
        return new KeyUsageCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, this.context, subContext, constraint);
    }

    private ChainItem<XmlSubXCV> extendedKeyUsage(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateExtendedKeyUsageConstraint(this.context, subContext);
        return new ExtendedKeyUsageCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, this.context, subContext, constraint);
    }

    private ChainItem<XmlSubXCV> aiaPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateAuthorityInfoAccessPresentConstraint(this.context, subContext);
        return new AuthorityInfoAccessPresentCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> policyTree(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificatePolicyTreeConstraint(this.context, subContext);
        return new CertificatePolicyTreeCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> nameConstraints(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNameConstraintsConstraint(this.context, subContext);
        return new CertificateNameConstraintsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> supportedCriticalCertificateExtensions(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateSupportedCriticalExtensionsConstraint(this.context, subContext);
        return new CertificateSupportedCriticalExtensionsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> forbiddenCertificateExtensions(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateForbiddenExtensionsConstraint(this.context, subContext);
        return new CertificateForbiddenExtensionsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> revocationInfoAccessPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateRevocationInfoAccessPresentConstraint(this.context, subContext);
        return new RevocationInfoAccessPresentCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> revocationDataPresent(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getRevocationDataAvailableConstraint(this.context, subContext);
        return new RevocationDataAvailableCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> checkCertificateRevocationSelectorResult(XmlCRS crsResult) {
        LevelConstraint constraint = this.validationPolicy.getAcceptableRevocationDataFoundConstraint(this.context, this.subContext);
        return new CertificateRevocationSelectorResultCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, crsResult, constraint);
    }

    private ChainItem<XmlSubXCV> checkRevocationFreshnessCheckerResult(XmlRFC rfcResult) {
        return new RevocationFreshnessCheckerResultCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, rfcResult, this.getFailLevelConstraint());
    }

    private ChainItem<XmlSubXCV> surname(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateSurnameConstraint(this.context, subContext);
        return new SurnameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> givenName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateGivenNameConstraint(this.context, subContext);
        return new GivenNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> commonName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateCommonNameConstraint(this.context, subContext);
        return new CommonNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> pseudonym(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificatePseudonymConstraint(this.context, subContext);
        return new PseudonymCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> country(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateCountryConstraint(this.context, subContext);
        return new CountryCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> organizationName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateOrganizationNameConstraint(this.context, subContext);
        return new OrganizationNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> organizationUnit(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateOrganizationUnitConstraint(this.context, subContext);
        return new OrganizationUnitCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> serialNumber(CertificateWrapper signingCertificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSerialNumberConstraint(this.context, subContext);
        return new SerialNumberCheck(this.i18nProvider, (XmlSubXCV)this.result, signingCertificate, constraint);
    }

    private ChainItem<XmlSubXCV> pseudoUsage(CertificateWrapper signingCertificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificatePseudoUsageConstraint(this.context, subContext);
        return new PseudoUsageCheck(this.i18nProvider, (XmlSubXCV)this.result, signingCertificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateSignatureValid(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSignatureConstraint(this.context, subContext);
        return new CertificateSignatureValidCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateNotRevoked(CertificateRevocationWrapper latestCertificateRevocation, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotRevokedConstraint(this.context, subContext);
        return new CertificateNotRevokedCheck(this.i18nProvider, (XmlSubXCV)this.result, latestCertificateRevocation, this.currentTime, constraint, subContext);
    }

    private ChainItem<XmlSubXCV> certificateNotOnHold(CertificateRevocationWrapper latestCertificateRevocation, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotOnHoldConstraint(this.context, subContext);
        return new CertificateNotOnHoldCheck(this.i18nProvider, (XmlSubXCV)this.result, latestCertificateRevocation, this.currentTime, constraint);
    }

    private ChainItem<XmlSubXCV> notSelfSigned(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateNotSelfSignedConstraint(this.context, subContext);
        return new CertificateNotSelfSignedCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> selfSigned(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateSelfSignedConstraint(this.context, subContext);
        return new CertificateSelfSignedCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePolicyIds(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificatePolicyIdsConstraint(this.context, subContext);
        return new CertificatePolicyIdsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePolicyQualifiedIds(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificatePolicyQualificationIdsConstraint(this.context, subContext);
        return new CertificatePolicyQualifiedIdsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePolicySupportedByQSCDIds(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificatePolicySupportedByQSCDIdsConstraint(this.context, subContext);
        return new CertificatePolicySupportedByQSCDIdsCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcCompliance(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateQCComplianceConstraint(this.context, subContext);
        return new CertificateQcComplianceCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateMinQcEuLimitValue(CertificateWrapper certificate, SubContext subContext) {
        IntValueConstraint constraint = this.validationPolicy.getCertificateMinQcEuLimitValueConstraint(this.context, subContext);
        return new CertificateMinQcTransactionLimitCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcEuLimitValueCurrency(CertificateWrapper certificate, SubContext subContext) {
        ValueConstraint constraint = this.validationPolicy.getCertificateQcEuLimitValueCurrencyConstraint(this.context, subContext);
        return new CertificateQcEuLimitValueCurrencyCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcEuRetentionPeriod(CertificateWrapper certificate, SubContext subContext) {
        IntValueConstraint constraint = this.validationPolicy.getCertificateMinQcEuRetentionPeriodConstraint(this.context, subContext);
        return new CertificateMinQcEuRetentionPeriodCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcSSCD(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateQcSSCDConstraint(this.context, subContext);
        return new CertificateQcSSCDCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcEuPDSLocation(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateQcEuPDSLocationConstraint(this.context, subContext);
        return new CertificateQcEuPDSLocationCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcType(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateQcTypeConstraint(this.context, subContext);
        return new CertificateQcTypeCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateQcCCLegislation(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateQcCCLegislationConstraint(this.context, subContext);
        return new CertificateQcCCLegislationCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateIssuedToNaturalPerson(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateIssuedToNaturalPersonConstraint(this.context, subContext);
        return new CertificateIssuedToNaturalPersonCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateIssuedToLegalPerson(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.validationPolicy.getCertificateIssuedToLegalPersonConstraint(this.context, subContext);
        return new CertificateIssuedToLegalPersonCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificateSemanticsIdentifier(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificateSemanticsIdentifierConstraint(this.context, subContext);
        return new CertificateSemanticsIdentifierCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePS2DQcRolesOfPSP(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificatePS2DQcTypeRolesOfPSPConstraint(this.context, subContext);
        return new CertificatePS2DQcRolesOfPSPCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePS2DQcCompetentAuthorityName(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificatePS2DQcCompetentAuthorityNameConstraint(this.context, subContext);
        return new CertificatePS2DQcCompetentAuthorityNameCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> certificatePS2DQcCompetentAuthorityId(CertificateWrapper certificate, SubContext subContext) {
        MultiValuesConstraint constraint = this.validationPolicy.getCertificatePS2DQcCompetentAuthorityIdConstraint(this.context, subContext);
        return new CertificatePS2DQcCompetentAuthorityIdCheck(this.i18nProvider, (XmlSubXCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlSubXCV> idPkixOcspNoCheck(CertificateWrapper certificateWrapper) {
        return new IdPkixOcspNoCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, certificateWrapper, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlSubXCV> certificateCryptographic(CertificateWrapper certificate, Context context, SubContext subcontext) {
        CryptographicConstraint cryptographicConstraint = this.validationPolicy.getCertificateCryptographicConstraint(context, subcontext);
        MessageTag position = ValidationProcessUtils.getCertificateChainCryptoPosition(context);
        return new CryptographicCheck<XmlSubXCV>(this.i18nProvider, (XmlSubXCV)this.result, (TokenProxy)certificate, position, this.currentTime, cryptographicConstraint);
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        XmlRFC xmlRFC;
        super.collectAdditionalMessages(conclusion);
        XmlCRS xmlCRS = ((XmlSubXCV)this.result).getCRS();
        if (xmlCRS != null && this.isValid((XmlConstraintsConclusion)xmlCRS)) {
            this.collectAllMessages(conclusion, xmlCRS.getConclusion());
        }
        if ((xmlRFC = ((XmlSubXCV)this.result).getRFC()) != null && this.isValid((XmlConstraintsConclusion)xmlRFC)) {
            this.collectAllMessages(conclusion, xmlRFC.getConclusion());
        }
    }
}

