/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.policy.jaxb.Algo;
import eu.europa.esig.dss.policy.jaxb.AlgoExpirationDate;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.ListAlgo;
import eu.europa.esig.dss.utils.Utils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptographicConstraintWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(CryptographicConstraintWrapper.class);
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private final CryptographicConstraint constraint;

    public CryptographicConstraintWrapper(CryptographicConstraint constraint) {
        this.constraint = constraint;
    }

    public boolean isEncryptionAlgorithmReliable(EncryptionAlgorithm encryptionAlgorithm) {
        ListAlgo acceptableEncryptionAlgos;
        if (encryptionAlgorithm != null && this.constraint != null && (acceptableEncryptionAlgos = this.constraint.getAcceptableEncryptionAlgo()) != null) {
            for (Algo algo : acceptableEncryptionAlgos.getAlgos()) {
                if (!algo.getValue().equals(encryptionAlgorithm.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDigestAlgorithmReliable(DigestAlgorithm digestAlgorithm) {
        ListAlgo acceptableEncryptionAlgos;
        if (digestAlgorithm != null && this.constraint != null && (acceptableEncryptionAlgos = this.constraint.getAcceptableDigestAlgo()) != null) {
            for (Algo algo : acceptableEncryptionAlgos.getAlgos()) {
                if (!algo.getValue().equals(digestAlgorithm.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEncryptionAlgorithmWithKeySizeReliable(EncryptionAlgorithm encryptionAlgorithm, String keyLength) {
        int keySize = this.parseKeySize(keyLength);
        return this.isEncryptionAlgorithmWithKeySizeReliable(encryptionAlgorithm, keySize);
    }

    public boolean isEncryptionAlgorithmWithKeySizeReliable(EncryptionAlgorithm encryptionAlgorithm, Integer keySize) {
        Integer size;
        return encryptionAlgorithm != null && keySize != 0 && this.constraint != null && (size = this.getAlgoKeySizeFromConstraint(encryptionAlgorithm)) != null && size <= keySize;
    }

    private Integer getAlgoKeySizeFromConstraint(EncryptionAlgorithm encryptionAlgorithm) {
        ListAlgo miniPublicKeySize;
        if (this.constraint != null && (miniPublicKeySize = this.constraint.getMiniPublicKeySize()) != null) {
            for (Algo algo : miniPublicKeySize.getAlgos()) {
                if (!algo.getValue().equals(encryptionAlgorithm.getName())) continue;
                return algo.getSize();
            }
        }
        return null;
    }

    public Date getExpirationDate(EncryptionAlgorithm encryptionAlgorithm, String keyLength) {
        int keySize = this.parseKeySize(keyLength);
        return this.getExpirationDate(encryptionAlgorithm, keySize);
    }

    public Date getExpirationDate(EncryptionAlgorithm encryptionAlgorithm, Integer keySize) {
        Map.Entry floorEntry;
        TreeMap<Integer, Date> dates = new TreeMap<Integer, Date>();
        AlgoExpirationDate algoExpirationDates = this.getAlgoExpirationDates();
        if (algoExpirationDates != null && encryptionAlgorithm != null) {
            SimpleDateFormat dateFormat = this.getUsedDateFormat(algoExpirationDates);
            String algoToSearch = encryptionAlgorithm.getName();
            for (Algo algo : algoExpirationDates.getAlgos()) {
                if (!algo.getValue().equals(algoToSearch)) continue;
                dates.put(algo.getSize(), this.getDate(algo, dateFormat));
            }
        }
        if ((floorEntry = dates.floorEntry(keySize)) == null) {
            return null;
        }
        return (Date)floorEntry.getValue();
    }

    public Date getExpirationDate(DigestAlgorithm digestAlgorithm) {
        AlgoExpirationDate algoExpirationDates = this.getAlgoExpirationDates();
        if (algoExpirationDates != null && digestAlgorithm != null) {
            SimpleDateFormat dateFormat = this.getUsedDateFormat(algoExpirationDates);
            String algoToFind = digestAlgorithm.getName();
            for (Algo algo : algoExpirationDates.getAlgos()) {
                if (!algo.getValue().equals(algoToFind)) continue;
                return this.getDate(algo, dateFormat);
            }
        }
        return null;
    }

    private int parseKeySize(String keyLength) {
        return Utils.isStringDigits((String)keyLength) ? Integer.parseInt(keyLength) : 0;
    }

    private AlgoExpirationDate getAlgoExpirationDates() {
        if (this.constraint != null) {
            return this.constraint.getAlgoExpirationDate();
        }
        return null;
    }

    private SimpleDateFormat getUsedDateFormat(AlgoExpirationDate expirations) {
        return new SimpleDateFormat(Utils.isStringEmpty((String)expirations.getFormat()) ? DEFAULT_DATE_FORMAT : expirations.getFormat());
    }

    private Date getDate(Algo algo, SimpleDateFormat format) {
        if (algo != null) {
            return this.getDate(algo.getDate(), format);
        }
        return null;
    }

    private Date getDate(String dateString, SimpleDateFormat format) {
        if (dateString != null) {
            try {
                return format.parse(dateString);
            }
            catch (ParseException e) {
                LOG.warn("Unable to parse '{}' with format '{}'", (Object)dateString, (Object)format);
            }
        }
        return null;
    }

    public List<DigestAlgorithm> getReliableDigestAlgorithms() {
        ArrayList<DigestAlgorithm> reliableDigestAlgorithms = new ArrayList<DigestAlgorithm>();
        if (this.constraint != null) {
            ListAlgo acceptableDigestAlgo = this.constraint.getAcceptableDigestAlgo();
            for (Algo algo : acceptableDigestAlgo.getAlgos()) {
                try {
                    DigestAlgorithm digestAlgorithm = DigestAlgorithm.forName((String)algo.getValue());
                    reliableDigestAlgorithms.add(digestAlgorithm);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Unable to parse a DigestAlgorithm with name '{}'! Reason : {}", new Object[]{algo.getValue(), e.getMessage(), e});
                }
            }
        }
        return reliableDigestAlgorithms;
    }

    public List<DigestAlgorithm> getReliableDigestAlgorithmsAtTime(Date validationTime) {
        ListAlgo acceptableDigestAlgo;
        ArrayList<DigestAlgorithm> reliableDigestAlgorithms = new ArrayList<DigestAlgorithm>();
        if (this.constraint != null && (acceptableDigestAlgo = this.constraint.getAcceptableDigestAlgo()) != null) {
            List reliableDigestAlgorithmNames = acceptableDigestAlgo.getAlgos().stream().map(Algo::getValue).collect(Collectors.toList());
            AlgoExpirationDate algoExpirationDate = this.constraint.getAlgoExpirationDate();
            if (algoExpirationDate != null) {
                for (Algo algo : algoExpirationDate.getAlgos()) {
                    if (!reliableDigestAlgorithmNames.contains(algo.getValue())) continue;
                    try {
                        DigestAlgorithm digestAlgorithm = DigestAlgorithm.forName((String)algo.getValue());
                        if (digestAlgorithm == null || this.getExpirationDate(digestAlgorithm).before(validationTime)) continue;
                        reliableDigestAlgorithms.add(digestAlgorithm);
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Unable to parse a DigestAlgorithm with name '{}'! Reason : {}", new Object[]{algo.getValue(), e.getMessage(), e});
                    }
                }
            }
        }
        return reliableDigestAlgorithms;
    }

    public List<EncryptionAlgorithm> getReliableEncryptionAlgorithms() {
        ArrayList<EncryptionAlgorithm> reliableEncryptionAlgorithms = new ArrayList<EncryptionAlgorithm>();
        if (this.constraint != null) {
            ListAlgo acceptableEncryptionAlgo = this.constraint.getAcceptableEncryptionAlgo();
            for (Algo algo : acceptableEncryptionAlgo.getAlgos()) {
                try {
                    EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.forName((String)algo.getValue());
                    if (encryptionAlgorithm == null) continue;
                    reliableEncryptionAlgorithms.add(encryptionAlgorithm);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Unable to parse a EncryptionAlgorithm with name '{}'! Reason : {}", new Object[]{algo.getValue(), e.getMessage(), e});
                }
            }
        }
        return reliableEncryptionAlgorithms;
    }

    public Map<EncryptionAlgorithm, Integer> getReliableEncryptionAlgorithmsWithMinimalKeyLengthAtTime(Date validationTime) {
        ListAlgo acceptableEncryptionAlgo;
        EnumMap<EncryptionAlgorithm, Integer> reliableEncryptionAlgorithms = new EnumMap<EncryptionAlgorithm, Integer>(EncryptionAlgorithm.class);
        if (this.constraint != null && (acceptableEncryptionAlgo = this.constraint.getAcceptableEncryptionAlgo()) != null) {
            List reliableEncryptionAlgorithmNames = acceptableEncryptionAlgo.getAlgos().stream().map(Algo::getValue).collect(Collectors.toList());
            AlgoExpirationDate algoExpirationDate = this.constraint.getAlgoExpirationDate();
            if (algoExpirationDate != null) {
                for (Algo algo : algoExpirationDate.getAlgos()) {
                    if (!reliableEncryptionAlgorithmNames.contains(algo.getValue())) continue;
                    try {
                        Integer minimalAcceptedKeySize;
                        EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.forName((String)algo.getValue());
                        if (encryptionAlgorithm == null || !this.isEncryptionAlgorithmWithKeySizeReliable(encryptionAlgorithm, algo.getSize()) || this.getExpirationDate(encryptionAlgorithm, algo.getSize()).before(validationTime) || (minimalAcceptedKeySize = (Integer)reliableEncryptionAlgorithms.get(encryptionAlgorithm)) != null && algo.getSize() >= minimalAcceptedKeySize) continue;
                        reliableEncryptionAlgorithms.put(encryptionAlgorithm, algo.getSize());
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Unable to parse a EncryptionAlgorithm with name '{}'! Reason : {}", new Object[]{algo.getValue(), e.getMessage(), e});
                    }
                }
            }
        }
        return reliableEncryptionAlgorithms;
    }

    public Level getLevel() {
        if (this.constraint != null) {
            return this.constraint.getLevel();
        }
        return null;
    }

    public LevelConstraint getAcceptableEncryptionAlgoLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevelConstraint((LevelConstraint)this.constraint.getAcceptableEncryptionAlgo());
        }
        return null;
    }

    public LevelConstraint getMiniPublicKeySizeLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevelConstraint((LevelConstraint)this.constraint.getMiniPublicKeySize());
        }
        return null;
    }

    public LevelConstraint getAcceptableDigestAlgoLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevelConstraint((LevelConstraint)this.constraint.getAcceptableDigestAlgo());
        }
        return null;
    }

    public LevelConstraint getAlgoExpirationDateLevel() {
        if (this.constraint != null) {
            return this.getCryptographicLevelConstraint((LevelConstraint)this.constraint.getAlgoExpirationDate());
        }
        return null;
    }

    private LevelConstraint getCryptographicLevelConstraint(LevelConstraint cryptoConstraint) {
        if (cryptoConstraint != null && cryptoConstraint.getLevel() != null) {
            return cryptoConstraint;
        }
        return this.constraint;
    }

    public Date getCryptographicSuiteUpdateDate() {
        AlgoExpirationDate algoExpirationDates = this.getAlgoExpirationDates();
        if (algoExpirationDates != null) {
            SimpleDateFormat dateFormat = this.getUsedDateFormat(algoExpirationDates);
            return this.getDate(algoExpirationDates.getUpdateDate(), dateFormat);
        }
        return null;
    }

    public Level getAlgoExpirationDateAfterUpdateLevel() {
        AlgoExpirationDate algoExpirationDate = this.constraint.getAlgoExpirationDate();
        if (algoExpirationDate != null && algoExpirationDate.getLevelAfterUpdate() != null) {
            return algoExpirationDate.getLevelAfterUpdate();
        }
        LevelConstraint levelConstraint = this.getCryptographicLevelConstraint((LevelConstraint)algoExpirationDate);
        return levelConstraint != null ? levelConstraint.getLevel() : null;
    }

    public CryptographicConstraint getConstraint() {
        return this.constraint;
    }
}

