/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.DigestMatcherCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningCertificateDigestAlgorithmCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.BestSignatureTimeNotBeforeCertificateIssuanceCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.pcv.PastCertificateValidation;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.PastSignatureValidationCertificateRevocationSelector;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.BestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpirationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.CurrentTimeIndicationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.POEExistsCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.POENotAfterCARevocationTimeCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.PastCertificateValidationAcceptableCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.PastRevocationDataValidationConclusiveCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.PastSignatureValidationCertificateRevocationSelectorResultCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PastSignatureValidation
extends Chain<XmlPSV> {
    private final TokenProxy token;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final XmlConclusion currentConclusion;
    private final POEExtraction poe;
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final Context context;

    public PastSignatureValidation(I18nProvider i18nProvider, TokenProxy token, Map<String, XmlBasicBuildingBlocks> bbbs, XmlConclusion currentConclusion, POEExtraction poe, Date currentTime, ValidationPolicy policy, Context context) {
        super(i18nProvider, new XmlPSV());
        this.token = token;
        this.bbbs = bbbs;
        this.currentConclusion = currentConclusion;
        this.poe = poe;
        this.currentTime = currentTime;
        this.policy = policy;
        this.context = context;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.PAST_SIGNATURE_VALIDATION;
    }

    @Override
    protected void initChain() {
        boolean poeExists;
        XmlBasicBuildingBlocks tokenBBB = this.bbbs.get(this.token.getId());
        ChainItem<XmlPSV> item = null;
        CertificateWrapper signingCertificate = this.token.getSigningCertificate();
        PastSignatureValidationCertificateRevocationSelector certificateRevocationSelector = new PastSignatureValidationCertificateRevocationSelector(this.i18nProvider, signingCertificate, this.currentTime, this.bbbs, this.token.getId(), this.poe, this.policy);
        XmlCRS xmlCRS = (XmlCRS)certificateRevocationSelector.execute();
        tokenBBB.setPSVCRS(xmlCRS);
        item = this.firstItem = this.checkCertificateRevocationSelectorResult(xmlCRS);
        XmlConclusion sigCertRevocationPoeStatus = new XmlConclusion();
        List signingCertificateRevocations = certificateRevocationSelector.getAcceptableCertificateRevocations();
        if (Utils.isCollectionNotEmpty(signingCertificateRevocations)) {
            sigCertRevocationPoeStatus.setIndication(Indication.PASSED);
        } else {
            sigCertRevocationPoeStatus.setIndication(Indication.INDETERMINATE);
            sigCertRevocationPoeStatus.setSubIndication(SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE);
            signingCertificateRevocations = signingCertificate.getCertificateRevocationData();
        }
        PastCertificateValidation pcv = new PastCertificateValidation(this.i18nProvider, this.token, this.bbbs, this.poe, this.currentTime, this.policy, this.context);
        XmlPCV pcvResult = (XmlPCV)pcv.execute();
        tokenBBB.setPCV(pcvResult);
        item = item.setNextItem(this.pastCertificateValidationAcceptableCheck(pcvResult));
        Date controlTime = pcvResult.getControlTime();
        ((XmlPSV)this.result).setControlTime(controlTime);
        boolean bl = poeExists = controlTime != null && this.poe.isPOEExists(this.token.getId(), controlTime);
        if (poeExists) {
            item = item.setNextItem(this.poeExist());
        }
        if (!poeExists || !Indication.INDETERMINATE.equals((Object)this.currentConclusion.getIndication()) || !SubIndication.REVOKED_NO_POE.equals((Object)this.currentConclusion.getSubIndication()) && !SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE.equals((Object)this.currentConclusion.getSubIndication())) {
            if (poeExists && Indication.INDETERMINATE.equals((Object)this.currentConclusion.getIndication()) && SubIndication.REVOKED_CA_NO_POE.equals((Object)this.currentConclusion.getSubIndication())) {
                CertificateRevocationWrapper latestCARevocationData;
                CertificateWrapper caCertificate = signingCertificate.getSigningCertificate();
                CertificateRevocationWrapper certificateRevocationWrapper = latestCARevocationData = caCertificate == null ? null : ValidationProcessUtils.getLatestAcceptableRevocationData(this.token, caCertificate, caCertificate.getCertificateRevocationData(), this.currentTime, this.bbbs, this.poe);
                if (latestCARevocationData != null) {
                    item = item.setNextItem(this.poeExistNotAfterCARevocationTimeCheck(signingCertificateRevocations, latestCARevocationData.getRevocationDate()));
                }
            } else if (poeExists && Indication.INDETERMINATE.equals((Object)this.currentConclusion.getIndication()) && (SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)this.currentConclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)this.currentConclusion.getSubIndication()))) {
                Date bestSignatureTime = this.poe.getLowestPOETime(this.token.getId());
                item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime, signingCertificate));
                item = item.setNextItem(this.bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(bestSignatureTime, signingCertificate, this.currentConclusion.getSubIndication()));
            } else if (Indication.INDETERMINATE.equals((Object)this.currentConclusion.getIndication()) && SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)this.currentConclusion.getSubIndication())) {
                CryptographicConstraint cryptographicConstraint = this.policy.getSignatureCryptographicConstraint(this.context);
                Date lowestPoeTime = this.getLowestPoeTime(this.token);
                item = item.setNextItem(this.tokenUsedAlgorithmsAreSecureAtPoeTime(this.token, lowestPoeTime, ValidationProcessUtils.getCryptoPosition(this.context), cryptographicConstraint));
                if (Utils.isCollectionNotEmpty((Collection)this.token.getDigestMatchers())) {
                    for (XmlDigestMatcher digestMatcher : this.token.getDigestMatchers()) {
                        item = item.setNextItem(this.digestMatcherIsSecureAtPoeTime(digestMatcher, lowestPoeTime, cryptographicConstraint));
                    }
                }
                for (CertificateRefWrapper certificateRef : this.token.getSigningCertificateReferences()) {
                    item = item.setNextItem(this.signCertRefIsSecureAtPoeTime(certificateRef, lowestPoeTime, this.context));
                }
                item = this.certificateChainReliableAtPoeTime(item, signingCertificateRevocations, this.context);
            } else {
                item = item.setNextItem(this.currentTimeIndicationCheck());
            }
        }
        item = item.setNextItem(this.pastRevocationDataValidationConclusive(sigCertRevocationPoeStatus));
    }

    private ChainItem<XmlPSV> checkCertificateRevocationSelectorResult(XmlCRS crsResult) {
        return new PastSignatureValidationCertificateRevocationSelectorResultCheck(this.i18nProvider, (XmlPSV)this.result, crsResult, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlPSV> currentTimeIndicationCheck() {
        return new CurrentTimeIndicationCheck(this.i18nProvider, (XmlPSV)this.result, this.currentConclusion.getIndication(), this.currentConclusion.getSubIndication(), this.currentConclusion.getErrors(), this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> pastCertificateValidationAcceptableCheck(XmlPCV pcvResult) {
        return new PastCertificateValidationAcceptableCheck(this.i18nProvider, (XmlPSV)this.result, pcvResult, this.token.getId(), this.currentConclusion.getIndication(), this.currentConclusion.getSubIndication(), this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> poeExist() {
        return new POEExistsCheck(this.i18nProvider, (XmlPSV)this.result, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> poeExistNotAfterCARevocationTimeCheck(Collection<CertificateRevocationWrapper> certificateRevocations, Date caRevocationTime) {
        return new POENotAfterCARevocationTimeCheck<CertificateRevocationWrapper>(this.i18nProvider, (XmlPSV)this.result, certificateRevocations, caRevocationTime, this.poe, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> pastRevocationDataValidationConclusive(XmlConclusion currentConclusion) {
        return new PastRevocationDataValidationConclusiveCheck(this.i18nProvider, (XmlPSV)this.result, currentConclusion, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> bestSignatureTimeNotBeforeCertificateIssuance(Date bestSignatureTime, CertificateWrapper signingCertificate) {
        return new BestSignatureTimeNotBeforeCertificateIssuanceCheck<XmlPSV>(this.i18nProvider, (XmlPSV)this.result, bestSignatureTime, signingCertificate, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(Date bestSignatureTime, CertificateWrapper signingCertificate, SubIndication currentTimeSubIndication) {
        return new BestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpirationCheck(this.i18nProvider, (XmlPSV)this.result, bestSignatureTime, signingCertificate, currentTimeSubIndication, this.getFailLevelConstraint());
    }

    private CryptographicCheck<XmlPSV> tokenUsedAlgorithmsAreSecureAtPoeTime(TokenProxy currentToken, Date validationDate, MessageTag position, CryptographicConstraint constraint) {
        return new CryptographicCheck<XmlPSV>(this.i18nProvider, (XmlPSV)this.result, currentToken, position, validationDate, constraint);
    }

    private ChainItem<XmlPSV> digestMatcherIsSecureAtPoeTime(XmlDigestMatcher digestMatcher, Date validationDate, CryptographicConstraint constraint) {
        MessageTag position = ValidationProcessUtils.getDigestMatcherCryptoPosition(digestMatcher);
        return new DigestMatcherCryptographicCheck<XmlPSV>(this.i18nProvider, digestMatcher.getDigestMethod(), (XmlPSV)this.result, validationDate, position, constraint);
    }

    private ChainItem<XmlPSV> signCertRefIsSecureAtPoeTime(CertificateRefWrapper signCertReference, Date validationDate, Context context) {
        SubContext subContext = this.token.getSigningCertificate() != null && this.token.getSigningCertificate().getId().equals(signCertReference.getCertificateId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
        CryptographicConstraint cryptographicConstraint = this.policy.getCertificateCryptographicConstraint(context, subContext);
        LevelConstraint constraint = this.policy.getSigningCertificateDigestAlgorithmConstraint(context);
        return new SigningCertificateDigestAlgorithmCheck<XmlPSV>(this.i18nProvider, signCertReference, (XmlPSV)this.result, validationDate, cryptographicConstraint, constraint);
    }

    private ChainItem<XmlPSV> certificateChainReliableAtPoeTime(ChainItem<XmlPSV> item, List<CertificateRevocationWrapper> signingCertificateRevocations, Context context) {
        return this.certificateChainReliableAtPoeTime(item, this.token.getCertificateChain(), signingCertificateRevocations, context, new ArrayList<String>());
    }

    private ChainItem<XmlPSV> certificateChainReliableAtPoeTime(ChainItem<XmlPSV> item, List<CertificateWrapper> certificateChain, List<CertificateRevocationWrapper> signingCertificateRevocations, Context context, List<String> checkedTokens) {
        for (CertificateWrapper certificate : certificateChain) {
            if (certificate.isTrusted()) break;
            if (checkedTokens.contains(certificate.getId())) continue;
            checkedTokens.add(certificate.getId());
            SubContext subContext = this.token.getSigningCertificate().getId().equals(certificate.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
            List revocationData = SubContext.SIGNING_CERT.equals((Object)subContext) ? signingCertificateRevocations : certificate.getCertificateRevocationData();
            Date certificatePoeTime = this.getLowestPoeTime((TokenProxy)certificate);
            item = item.setNextItem(this.tokenUsedAlgorithmsAreSecureAtPoeTime((TokenProxy)certificate, certificatePoeTime, ValidationProcessUtils.getCertificateChainCryptoPosition(context), this.policy.getCertificateCryptographicConstraint(context, subContext)));
            CertificateRevocationWrapper latestAcceptableRevocation = ValidationProcessUtils.getLatestAcceptableRevocationData(this.token, certificate, revocationData, this.currentTime, this.bbbs, this.poe);
            if (latestAcceptableRevocation == null || checkedTokens.contains(latestAcceptableRevocation.getId())) continue;
            checkedTokens.add(latestAcceptableRevocation.getId());
            Date revocationPoeTime = this.getLowestPoeTime((TokenProxy)certificate);
            item = item.setNextItem(this.tokenUsedAlgorithmsAreSecureAtPoeTime((TokenProxy)latestAcceptableRevocation, revocationPoeTime, ValidationProcessUtils.getCertificateChainCryptoPosition(Context.REVOCATION), this.policy.getSignatureCryptographicConstraint(Context.REVOCATION)));
            item = this.certificateChainReliableAtPoeTime(item, latestAcceptableRevocation.getCertificateChain(), signingCertificateRevocations, Context.REVOCATION, checkedTokens);
        }
        return item;
    }

    private Date getLowestPoeTime(TokenProxy token) {
        return this.poe.getLowestPOETime(token.getId());
    }
}

